/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.FIFOConfiguration;
import org.jboss.cache.eviction.FIFOPolicy;
import org.jboss.cache.eviction.LFUConfiguration;
import org.jboss.cache.eviction.LFUPolicy;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.eviction.MRUConfiguration;
import org.jboss.cache.eviction.MRUPolicy;
import org.jboss.cache.lock.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class EvictionConfigurationTest {
    CacheImpl<Object, Object> cache;
    RegionManager regionManager;

    public void testPolicyPerRegion() throws Exception {
        this.setupCache("META-INF/policyPerRegion-eviction-service.xml");
        AssertJUnit.assertEquals((int)5, (int)this.cache.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds());
        Region region = this.regionManager.getRegion("/org/jboss/data", true);
        EvictionPolicy policy = region.getEvictionPolicy();
        EvictionPolicyConfig configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/data"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LFUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LFUConfiguration));
        AssertJUnit.assertEquals((int)5000, (int)((LFUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)1000, (int)((LFUConfiguration)configuration).getMinNodes());
        region = this.regionManager.getRegion("/org/jboss/test/data", true);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/test/data"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof FIFOPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof FIFOConfiguration));
        AssertJUnit.assertEquals((int)5, (int)((FIFOConfiguration)configuration).getMaxNodes());
        region = this.regionManager.getRegion("/test", true);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/test"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof MRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof MRUConfiguration));
        AssertJUnit.assertEquals((int)10000, (int)((MRUConfiguration)configuration).getMaxNodes());
        region = this.regionManager.getRegion("/maxAgeTest", true);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/maxAgeTest"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LRUConfiguration));
        AssertJUnit.assertEquals((int)10000, (int)((LRUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)8, (int)((LRUConfiguration)configuration).getTimeToLiveSeconds());
        AssertJUnit.assertEquals((int)10, (int)((LRUConfiguration)configuration).getMaxAgeSeconds());
        region = this.regionManager.getRegion("/a/b/c", false);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.ROOT, (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LRUConfiguration));
        AssertJUnit.assertEquals((int)5000, (int)((LRUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)1000, (int)((LRUConfiguration)configuration).getTimeToLiveSeconds());
        AssertJUnit.assertEquals((int)0, (int)((LRUConfiguration)configuration).getMaxAgeSeconds());
        this.cache.stop();
    }

    public void testMixedPolicies() throws Exception {
        this.setupCache("META-INF/mixedPolicy-eviction-service.xml");
        AssertJUnit.assertEquals((int)5, (int)this.cache.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds());
        Region region = this.regionManager.getRegion("/org/jboss/data", true);
        EvictionPolicy policy = region.getEvictionPolicy();
        EvictionPolicyConfig configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/data/"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof FIFOPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof FIFOConfiguration));
        AssertJUnit.assertEquals((int)5000, (int)((FIFOConfiguration)configuration).getMaxNodes());
        region = this.regionManager.getRegion("/test", true);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/test/"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof MRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof MRUConfiguration));
        AssertJUnit.assertEquals((int)10000, (int)((MRUConfiguration)configuration).getMaxNodes());
        region = this.regionManager.getRegion("/a/b/c", false);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.ROOT, (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LRUConfiguration));
        AssertJUnit.assertEquals((int)5000, (int)((LRUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)1000, (int)((LRUConfiguration)configuration).getTimeToLiveSeconds());
        AssertJUnit.assertEquals((int)0, (int)((LRUConfiguration)configuration).getMaxAgeSeconds());
        region = this.regionManager.getRegion("/maxAgeTest", false);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/maxAgeTest/"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LRUConfiguration));
        AssertJUnit.assertEquals((int)10000, (int)((LRUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)8, (int)((LRUConfiguration)configuration).getTimeToLiveSeconds());
        AssertJUnit.assertEquals((int)10, (int)((LRUConfiguration)configuration).getMaxAgeSeconds());
        this.cache.stop();
    }

    public void testLegacyPolicyConfiguration() throws Exception {
        this.setupCache("META-INF/local-lru-eviction-service.xml");
        AssertJUnit.assertEquals((int)5, (int)this.cache.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds());
        Region region = this.regionManager.getRegion("/org/jboss/data", false);
        EvictionPolicy policy = region.getEvictionPolicy();
        EvictionPolicyConfig configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/data/"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LRUConfiguration));
        AssertJUnit.assertEquals((int)5000, (int)((LRUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)1000, (int)((LRUConfiguration)configuration).getTimeToLiveSeconds());
        region = this.regionManager.getRegion("/org/jboss/test/data", false);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/test/data/"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LRUConfiguration));
        AssertJUnit.assertEquals((int)5, (int)((LRUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)4, (int)((LRUConfiguration)configuration).getTimeToLiveSeconds());
        region = this.regionManager.getRegion("/test", true);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/test/"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LRUConfiguration));
        AssertJUnit.assertEquals((int)10000, (int)((LRUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)4, (int)((LRUConfiguration)configuration).getTimeToLiveSeconds());
        region = this.regionManager.getRegion("/maxAgeTest", true);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/maxAgeTest/"), (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LRUConfiguration));
        AssertJUnit.assertEquals((int)10000, (int)((LRUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)8, (int)((LRUConfiguration)configuration).getTimeToLiveSeconds());
        AssertJUnit.assertEquals((int)10, (int)((LRUConfiguration)configuration).getMaxAgeSeconds());
        region = this.regionManager.getRegion("/a/b/c", false);
        policy = region.getEvictionPolicy();
        configuration = region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((Object)Fqn.ROOT, (Object)region.getFqn());
        AssertJUnit.assertTrue((boolean)(policy instanceof LRUPolicy));
        AssertJUnit.assertTrue((boolean)(configuration instanceof LRUConfiguration));
        AssertJUnit.assertEquals((int)5000, (int)((LRUConfiguration)configuration).getMaxNodes());
        AssertJUnit.assertEquals((int)1000, (int)((LRUConfiguration)configuration).getTimeToLiveSeconds());
        AssertJUnit.assertEquals((int)0, (int)((LRUConfiguration)configuration).getMaxAgeSeconds());
        this.cache.stop();
    }

    public void testTwoCacheInstanceConfiguration() throws Exception {
        this.setupCache("META-INF/local-lru-eviction-service.xml");
        this.setupCache("META-INF/local-lru-eviction-service.xml");
    }

    public void testNoEviction() throws Exception {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache();
        this.regionManager = this.cache.getRegionManager();
        AssertJUnit.assertEquals((int)0, (int)this.regionManager.getAllRegions(Region.Type.ANY).size());
    }

    private void setupCache(String configurationName) throws Exception {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(configurationName, false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.start();
        this.regionManager = this.cache.getRegionManager();
    }
}

