/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class FIFOPolicyTest {
    CacheImpl<Object, Object> cache;
    int wakeupIntervalMillis = 0;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    final long DURATION = 10000L;
    boolean isTrue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    void initCaches() throws Exception {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache("META-INF/local-fifo-eviction-service.xml", false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    public void testEviction() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        System.out.println(this.cache.toString(true));
        TestingUtil.sleepThread(this.wakeupIntervalMillis + 500);
        System.out.println(this.cache.toString(true));
        try {
            String val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
            AssertJUnit.assertNull((Object)this.cache.get(rootStr + "1", (Object)(rootStr + "1")));
            AssertJUnit.assertNull((Object)this.cache.get(rootStr + "2", (Object)(rootStr + "2")));
            AssertJUnit.assertNull((Object)this.cache.get(rootStr + "0", (Object)(rootStr + "0")));
            AssertJUnit.assertNull((Object)this.cache.get(rootStr + "4", (Object)(rootStr + "4")));
            AssertJUnit.assertNotNull((Object)this.cache.get(rootStr + "5", (Object)(rootStr + "5")));
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
    }

    public void testEviction2() throws Exception {
        int i;
        String rootStr = "/org/jboss/data";
        int maxNodes = 5000;
        for (i = 0; i < maxNodes * 2; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        TestingUtil.sleepThread(this.wakeupIntervalMillis + 500);
        AssertJUnit.assertEquals((String)"Number of nodes", (int)(maxNodes + 2), (int)this.cache.getNumberOfNodes());
        for (i = 0; i < maxNodes; ++i) {
            String n = rootStr + i;
            AssertJUnit.assertNull((String)("DataNode should be empty " + this.cache.get(n) + " " + n), (Object)this.cache.get(n, (Object)n));
        }
        for (i = maxNodes; i < maxNodes * 2; ++i) {
            AssertJUnit.assertNotNull((Object)this.cache.get(rootStr + Integer.toString(i), (Object)(rootStr + Integer.toString(i))));
        }
        this.cache.put(rootStr + "a", (Object)(rootStr + "a"), (Object)(rootStr + "a"));
        for (i = maxNodes + 1; i < maxNodes; ++i) {
            AssertJUnit.assertNotNull((Object)this.cache.get(rootStr + Integer.toString(i), (Object)(rootStr + Integer.toString(i))));
        }
        AssertJUnit.assertNotNull((Object)this.cache.get(rootStr + "a", (Object)(rootStr + "a")));
    }

    public void testNodeVisited() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        System.out.println("cache is:\n" + this.cache.toString(true));
        int period = this.wakeupIntervalMillis + 500;
        this.log("sleeping for " + period + "ms");
        TestingUtil.sleepThread(period);
        try {
            Fqn fqn;
            String str;
            int i;
            for (i = 0; i < 5; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 5; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
            TestingUtil.sleepThread(period);
            for (i = 5; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                this.cache.get(fqn, (Object)str);
                System.out.println("-- sleeping for " + period + "ms");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to evict" + e));
        }
    }

    public void testNodeRemoved() {
        Fqn fqn2;
        String str2;
        String rootStr = "/org/jboss/test";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i + "/" + i;
            Fqn fqn = Fqn.fromString((String)str);
            str2 = rootStr + i;
            fqn2 = Fqn.fromString((String)str2);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                this.cache.put(fqn2, (Object)str2, (Object)str2);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        int period = this.wakeupIntervalMillis + 500;
        this.log("period is " + period);
        TestingUtil.sleepThread(period);
        String str1 = rootStr + "7";
        Fqn fqn1 = Fqn.fromString((String)str1);
        str2 = rootStr + "7/7";
        fqn2 = Fqn.fromString((String)str2);
        try {
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn2, (Object)str2));
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn1, (Object)str1));
            this.cache.remove(fqn2);
            TestingUtil.sleepThread(period);
            AssertJUnit.assertNull((Object)this.cache.get(fqn2, (Object)str2));
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn1, (Object)str1));
            this.cache.remove(fqn1);
            TestingUtil.sleepThread(period);
            AssertJUnit.assertNull((Object)this.cache.get(fqn1, (Object)str1));
            AssertJUnit.assertNull((Object)this.cache.get(fqn2, (Object)str2));
            String str3 = rootStr + "5/5";
            String str4 = rootStr + "5";
            Fqn fqn3 = Fqn.fromString((String)str3);
            Fqn fqn4 = Fqn.fromString((String)str4);
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn3, (Object)str3));
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn4, (Object)str4));
            TestingUtil.sleepThread(period);
            this.cache.remove(fqn4);
            TestingUtil.sleepThread(period);
            AssertJUnit.assertNull((Object)this.cache.get(fqn3, (Object)str3));
            AssertJUnit.assertNull((Object)this.cache.get(fqn4, (Object)str4));
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to evict" + e));
        }
    }

    public void testConcurrentPutAndEvict() throws Exception {
        this.cache.stop();
        this.cache.destroy();
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.start();
        this.cache.put("/test/concurrentPutAndEvict", (Object)"value", (Object)1);
        for (int i = 0; i < 10; ++i) {
            new MyPutter("Putter" + i).start();
        }
        int counter = 0;
        do {
            ++counter;
            if (this.t1_ex != null) {
                AssertJUnit.fail((String)("Exception generated in put() " + this.t1_ex));
            }
            this.log("nodes/locks: " + this.cache.getNumberOfNodes() + "/" + this.cache.getNumberOfLocksHeld());
            TestingUtil.sleepThread(1000L);
        } while (counter <= 10);
        this.isTrue = false;
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (FIFOPolicyTest.this.isTrue) {
                try {
                    FIFOPolicyTest.this.cache.put(myName + i++, (Object)"value", (Object)i);
                    MyPutter.sleep(1L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (FIFOPolicyTest.this.t1_ex != null) continue;
                    FIFOPolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

