/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction.minttl;

import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionPolicyConfigBase;
import org.jboss.cache.eviction.FIFOConfiguration;
import org.jboss.cache.eviction.minttl.MinTTLTestBase;
import org.jboss.cache.misc.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class FIFOMinTTLTest
extends MinTTLTestBase {
    private Fqn fqn2;
    private Thread busyThread;
    private boolean busyThreadRunning;

    public FIFOMinTTLTest() {
        this.fqn2 = new Fqn(this.region, new Object[]{"b"});
        this.busyThreadRunning = true;
    }

    protected EvictionPolicyConfigBase getEvictionPolicyConfig() {
        this.startBusyThread();
        FIFOConfiguration cfg = new FIFOConfiguration();
        cfg.setMaxNodes(1);
        return cfg;
    }

    @AfterMethod
    public void stopBusyThread() {
        this.busyThreadRunning = false;
        try {
            this.busyThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startBusyThread() {
        this.busyThreadRunning = true;
        this.busyThread = new Thread("BusyThread"){

            public void run() {
                try {
                    FIFOMinTTLTest.this.cacheInitialisedLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (FIFOMinTTLTest.this.busyThreadRunning) {
                    FIFOMinTTLTest.this.cache.put(FIFOMinTTLTest.this.fqn2, (Object)"k", (Object)"v");
                    TestingUtil.sleepRandom(150);
                }
            }
        };
        this.busyThread.setDaemon(true);
        this.busyThread.start();
    }
}

