/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"})
public class InvalidationInterceptorTest {
    private static Log log = LogFactory.getLog(InvalidationInterceptorTest.class);

    public void testPessimisticNonTransactional() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createCache(false);
        CacheImpl<Object, Object> cache2 = this.createCache(false);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        cache1.put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache1.get(fqn, (Object)"key"));
        Assert.assertNull((String)"Should NOT have replicated!", (Object)cache2.get(fqn));
        log.info((Object)"***** Node not replicated, as expected.");
        cache2.put(fqn, (Object)"key", (Object)"value");
        Node n = cache1.get(fqn);
        assert (n != null) : "Should not be null";
        assert (n.getKeys().isEmpty()) : "Should not contain any data";
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        cache1.put(fqn, (Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        n = cache2.get(fqn);
        assert (n != null) : "Should not be null";
        assert (n.getKeys().isEmpty()) : "Should not contain any data";
        cache1.stop();
        cache2.stop();
        cache1 = null;
        cache2 = null;
    }

    public void testUnnecessaryEvictions() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createCache(false);
        CacheImpl<Object, Object> cache2 = this.createCache(false);
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        cache1.put(fqn1, (Object)"hello", (Object)"world");
        AssertJUnit.assertEquals((Object)"world", (Object)cache1.get(fqn1, (Object)"hello"));
        AssertJUnit.assertNull((Object)cache2.get(fqn1, (Object)"hello"));
        cache2.put(fqn2, (Object)"hello", (Object)"world");
        AssertJUnit.assertEquals((Object)"world", (Object)cache1.get(fqn1, (Object)"hello"));
        AssertJUnit.assertNull((Object)cache2.get(fqn1, (Object)"hello"));
        AssertJUnit.assertEquals((Object)"world", (Object)cache2.get(fqn2, (Object)"hello"));
        AssertJUnit.assertNull((Object)cache1.get(fqn2, (Object)"hello"));
        cache2.put(fqn1, (Object)"hello", (Object)"world");
        AssertJUnit.assertEquals((Object)"world", (Object)cache2.get(fqn1, (Object)"hello"));
        AssertJUnit.assertEquals((Object)"world", (Object)cache2.get(fqn2, (Object)"hello"));
        AssertJUnit.assertNull((Object)cache1.get(fqn1, (Object)"hello"));
        AssertJUnit.assertNull((Object)cache1.get(fqn2, (Object)"hello"));
        cache1.stop();
        cache2.stop();
        cache1 = null;
        cache2 = null;
    }

    public void testPessimisticNonTransactionalAsync() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createUnstartedCache(false);
        CacheImpl<Object, Object> cache2 = this.createUnstartedCache(false);
        cache1.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        cache2.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        cache1.start();
        cache2.start();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        cache1.put(fqn, (Object)"key", (Object)"value");
        TestingUtil.sleepThread(500L);
        Assert.assertEquals((Object)"value", (Object)cache1.get(fqn, (Object)"key"));
        Assert.assertNull((String)"Should NOT have replicated!", (Object)cache2.get(fqn));
        log.info((Object)"***** Node not replicated, as expected.");
        cache2.put(fqn, (Object)"key", (Object)"value");
        TestingUtil.sleepThread(500L);
        Node n = cache1.get(fqn);
        assert (n != null) : "Should not be null";
        assert (n.getKeys().isEmpty()) : "Should not contain any data";
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        cache1.put(fqn, (Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        TestingUtil.sleepThread(500L);
        n = cache2.get(fqn);
        assert (n != null) : "Should not be null";
        assert (n.getKeys().isEmpty()) : "Should not contain any data";
        cache1.stop();
        cache2.stop();
        cache1 = null;
        cache2 = null;
    }

    public void testPessimisticTransactional() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createCache(false);
        CacheImpl<Object, Object> cache2 = this.createCache(false);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        cache1.put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache1.get(fqn, (Object)"key"));
        Assert.assertNull((String)"Should NOT have replicated!", (Object)cache2.get(fqn));
        log.info((Object)"***** Node not replicated, as expected.");
        TransactionManager txm = cache2.getTransactionManager();
        Assert.assertEquals((Object)"value", (Object)cache1.get(fqn, (Object)"key"));
        txm.begin();
        cache2.put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        txm.commit();
        Node n = cache1.get(fqn);
        assert (n != null) : "Should not be null";
        assert (n.getKeys().isEmpty()) : "Should not contain any data";
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        txm = cache1.getTransactionManager();
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        txm.begin();
        cache1.put(fqn, (Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        txm.commit();
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        n = cache2.get(fqn);
        assert (n != null) : "Should not be null";
        assert (n.getKeys().isEmpty()) : "Should not contain any data";
        txm = cache2.getTransactionManager();
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        txm.begin();
        cache2.put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        txm.rollback();
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        n = cache2.get(fqn);
        assert (n != null) : "Should not be null";
        assert (n.getKeys().isEmpty()) : "Should not contain any data";
        cache1.stop();
        cache2.stop();
        cache1 = null;
        cache2 = null;
    }

    public void testOptSyncUnableToEvict() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createCache(true);
        CacheImpl<Object, Object> cache2 = this.createCache(true);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        cache2.put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        Node n = cache1.get(fqn);
        assert (n != null) : "Should not be null";
        assert (n.getKeys().isEmpty()) : "But should not contain any data";
        TransactionManager mgr1 = cache1.getTransactionManager();
        TransactionManager mgr2 = cache2.getTransactionManager();
        mgr1.begin();
        cache1.put(fqn, (Object)"key2", (Object)"value2");
        Transaction tx1 = mgr1.suspend();
        mgr2.begin();
        cache2.put(fqn, (Object)"key3", (Object)"value3");
        Transaction tx2 = mgr2.suspend();
        mgr1.resume(tx1);
        try {
            mgr1.commit();
            Assert.assertTrue((String)"Ought to have succeeded!", (boolean)true);
        }
        catch (RollbackException roll) {
            Assert.assertTrue((String)"Ought to have succeeded!", (boolean)false);
        }
        mgr2.resume(tx2);
        try {
            mgr2.commit();
            Assert.assertTrue((String)"Ought to have failed!", (boolean)false);
        }
        catch (RollbackException roll) {
            Assert.assertTrue((String)"Ought to have failed!", (boolean)true);
        }
        cache1.stop();
        cache2.stop();
        cache1 = null;
        cache2 = null;
    }

    public void testPessTxSyncUnableToEvict() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createCache(false);
        CacheImpl<Object, Object> cache2 = this.createCache(false);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        cache1.put("/a/b", (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache1.get(fqn, (Object)"key"));
        Assert.assertNull((Object)cache2.get(fqn));
        TransactionManager mgr1 = cache1.getTransactionManager();
        TransactionManager mgr2 = cache2.getTransactionManager();
        mgr1.begin();
        cache1.put(fqn, (Object)"key2", (Object)"value2");
        Transaction tx1 = mgr1.suspend();
        mgr2.begin();
        cache2.put(fqn, (Object)"key3", (Object)"value3");
        Transaction tx2 = mgr2.suspend();
        mgr1.resume(tx1);
        try {
            mgr1.commit();
            Assert.assertTrue((String)"Ought to have failed!", (boolean)false);
        }
        catch (RollbackException roll) {
            Assert.assertTrue((String)"Ought to have failed!", (boolean)true);
        }
        mgr2.resume(tx2);
        try {
            mgr2.commit();
            Assert.assertTrue((String)"Ought to have succeeded!", (boolean)true);
        }
        catch (RollbackException roll) {
            Assert.assertTrue((String)"Ought to have succeeded!", (boolean)false);
        }
        cache1.stop();
        cache2.stop();
        cache1 = null;
        cache2 = null;
    }

    public void testPessTxAsyncUnableToEvict() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createUnstartedCache(false);
        CacheImpl<Object, Object> cache2 = this.createUnstartedCache(false);
        cache1.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        cache2.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        cache1.start();
        cache2.start();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        cache1.put("/a/b", (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache1.get(fqn, (Object)"key"));
        Assert.assertNull((Object)cache2.get(fqn));
        TransactionManager mgr1 = cache1.getTransactionManager();
        TransactionManager mgr2 = cache2.getTransactionManager();
        mgr1.begin();
        cache1.put(fqn, (Object)"key2", (Object)"value2");
        Transaction tx1 = mgr1.suspend();
        mgr2.begin();
        cache2.put(fqn, (Object)"key3", (Object)"value3");
        Transaction tx2 = mgr2.suspend();
        mgr1.resume(tx1);
        try {
            mgr1.commit();
            Assert.assertTrue((String)"Ought to have succeeded!", (boolean)true);
        }
        catch (RollbackException roll) {
            Assert.assertTrue((String)"Ought to have succeeded!", (boolean)false);
        }
        mgr2.resume(tx2);
        try {
            mgr2.commit();
            Assert.assertTrue((String)"Ought to have succeeded!", (boolean)true);
        }
        catch (RollbackException roll) {
            Assert.assertTrue((String)"Ought to have succeeded!", (boolean)false);
        }
        cache1.stop();
        cache2.stop();
        cache1 = null;
        cache2 = null;
    }

    private void dumpVersionInfo(CacheSPI c1, CacheSPI c2, Fqn fqn) {
        System.out.println("**** Versin Info for Fqn [" + fqn + "] ****");
        NodeSPI n1 = c1.getRoot().getChildDirect(fqn);
        System.out.println("  Cache 1: " + n1.getVersion() + " dataLoaded? " + n1.isDataLoaded());
        NodeSPI n2 = c2.getRoot().getChildDirect(fqn);
        System.out.println("  Cache 2: " + n2.getVersion() + " dataLoaded? " + n2.isDataLoaded());
    }

    public void testOptimistic() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createCache(true);
        CacheImpl<Object, Object> cache2 = this.createCache(true);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        cache1.put(fqn, (Object)"key", (Object)"value");
        this.dumpVersionInfo((CacheSPI)cache1, (CacheSPI)cache2, fqn);
        Assert.assertEquals((Object)"value", (Object)cache1.get(fqn, (Object)"key"));
        Node n2 = cache2.get(fqn);
        assert (n2 != null) : "Should NOT be null; we need to have version info on all instances.";
        assert (n2.get((Object)"key") == null) : "Data should not have replicated!";
        cache2.put(fqn, (Object)"key", (Object)"value");
        this.dumpVersionInfo((CacheSPI)cache1, (CacheSPI)cache2, fqn);
        Node n1 = cache1.get(fqn);
        assert (n1 != null) : "Should NOT be null; we need to have version info on all instances.";
        assert (n1.get((Object)"key") == null) : "Data should not have replicated!";
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        cache1.put(fqn, (Object)"key2", (Object)"value2");
        this.dumpVersionInfo((CacheSPI)cache1, (CacheSPI)cache2, fqn);
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        n2 = cache2.get(fqn);
        assert (n2 != null) : "Should NOT be null; we need to have version info on all instances.";
        assert (n2.get((Object)"key") == null) : "Data should have invalidated!";
        assert (n2.get((Object)"key2") == null) : "Data should have invalidated!";
        TransactionManager txm = cache2.getTransactionManager();
        txm.begin();
        cache2.put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        txm.commit();
        n1 = cache1.get(fqn);
        assert (n1 != null) : "Should NOT be null; we need to have version info on all instances.";
        assert (n1.get((Object)"key") == null) : "Data should be null!";
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        txm = cache1.getTransactionManager();
        txm.begin();
        cache1.put(fqn, (Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        txm.commit();
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        n2 = cache2.get(fqn);
        assert (n2 != null) : "Should NOT be null; we need to have version info on all instances.";
        assert (n2.get((Object)"key2") == null) : "Data should have invalidated!";
        txm = cache2.getTransactionManager();
        txm.begin();
        cache2.put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        Assert.assertEquals((Object)"value", (Object)cache2.get(fqn, (Object)"key"));
        txm.rollback();
        Assert.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)"key2"));
        n2 = cache2.get(fqn);
        assert (n2 != null) : "Should NOT be null; we need to have version info on all instances.";
        assert (n2.get((Object)"key2") == null) : "Should not have committed!";
        cache1.stop();
        cache2.stop();
        cache1 = null;
        cache2 = null;
    }

    public void testPessimisticNonTransactionalWithCacheLoader() throws Exception {
        List<CacheImpl<Object, Object>> caches = this.createCachesWithSharedCL(false);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        caches.get(0).put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        Assert.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        caches.get(1).put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        Assert.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        caches.get(0).put(fqn, (Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value2", (Object)caches.get(0).get(fqn, (Object)"key2"));
        Assert.assertEquals((Object)"value2", (Object)caches.get(1).get(fqn, (Object)"key2"));
        Assert.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        Assert.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        caches.get(0).remove(fqn);
        caches.get(1).remove(fqn);
        caches.get(0).stop();
        caches.get(1).stop();
        caches.set(0, null);
        caches.set(1, null);
    }

    public void testPessimisticTransactionalWithCacheLoader() throws Exception {
        List<CacheImpl<Object, Object>> caches = this.createCachesWithSharedCL(false);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        TransactionManager mgr = caches.get(0).getTransactionManager();
        Assert.assertNull((String)"Should be null", (Object)caches.get(0).get(fqn, (Object)"key"));
        Assert.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key"));
        mgr.begin();
        caches.get(0).put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        mgr.commit();
        Assert.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        Assert.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        mgr.begin();
        caches.get(0).put(fqn, (Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value2", (Object)caches.get(0).get(fqn, (Object)"key2"));
        mgr.rollback();
        Assert.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        Assert.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        Assert.assertNull((String)"Should be null", (Object)caches.get(0).get(fqn, (Object)"key2"));
        Assert.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key2"));
        caches.get(0).remove(fqn);
        caches.get(1).remove(fqn);
        caches.get(0).stop();
        caches.get(1).stop();
        caches.set(0, null);
        caches.set(1, null);
    }

    public void testOptimisticWithCacheLoader() throws Exception {
        List<CacheImpl<Object, Object>> caches = this.createCachesWithSharedCL(true);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        TransactionManager mgr = caches.get(0).getTransactionManager();
        Assert.assertNull((String)"Should be null", (Object)caches.get(0).get(fqn, (Object)"key"));
        Assert.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key"));
        mgr.begin();
        caches.get(0).put(fqn, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        Assert.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key"));
        mgr.commit();
        Assert.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        Assert.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        mgr.begin();
        caches.get(0).put(fqn, (Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value2", (Object)caches.get(0).get(fqn, (Object)"key2"));
        Assert.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key2"));
        mgr.rollback();
        Assert.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        Assert.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        Assert.assertNull((String)"Should be null", (Object)caches.get(0).get(fqn, (Object)"key2"));
        Assert.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key2"));
        caches.get(0).remove(fqn);
        caches.get(1).remove(fqn);
        caches.get(0).stop();
        caches.get(1).stop();
        caches.set(0, null);
        caches.set(1, null);
    }

    public void testInvalidationWithRegionBasedMarshalling() throws Exception {
        this.doRegionBasedTest(false);
    }

    public void testInvalidationWithRegionBasedMarshallingOptimistic() throws Exception {
        this.doRegionBasedTest(true);
    }

    protected void doRegionBasedTest(boolean optimistic) throws Exception {
        ArrayList<CacheImpl<Object, Object>> caches = new ArrayList<CacheImpl<Object, Object>>();
        caches.add(this.createUnstartedCache(false));
        caches.add(this.createUnstartedCache(false));
        ((CacheImpl)caches.get(0)).getConfiguration().setUseRegionBasedMarshalling(true);
        ((CacheImpl)caches.get(1)).getConfiguration().setUseRegionBasedMarshalling(true);
        if (optimistic) {
            ((CacheImpl)caches.get(0)).getConfiguration().setNodeLockingScheme("OPTIMISTIC");
            ((CacheImpl)caches.get(1)).getConfiguration().setNodeLockingScheme("OPTIMISTIC");
        }
        ((CacheImpl)caches.get(0)).start();
        ((CacheImpl)caches.get(1)).start();
        TestingUtil.blockUntilViewsReceived(caches.toArray(new CacheImpl[0]), 5000L);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)caches.get(0)).get(fqn));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)caches.get(1)).get(fqn));
        ((CacheImpl)caches.get(0)).put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"expecting value", (Object)"value", (Object)((CacheImpl)caches.get(0)).get(fqn, (Object)"key"));
        Node n = ((CacheImpl)caches.get(1)).get(fqn);
        if (optimistic) {
            assert (n != null) : "Should NOT be null";
            assert (n.getKeys().isEmpty()) : "but should be empty";
        } else assert (n == null) : "Should be null!";
        ((CacheImpl)caches.get(1)).put(fqn, (Object)"key", (Object)"value2");
        AssertJUnit.assertEquals((String)"expecting value2", (Object)"value2", (Object)((CacheImpl)caches.get(1)).get(fqn, (Object)"key"));
        n = ((CacheImpl)caches.get(0)).get(fqn);
        assert (n != null) : "Should NOT be null";
        assert (n.getKeys().isEmpty()) : "but should be empty";
        ((CacheImpl)caches.get(0)).remove(fqn);
        ((CacheImpl)caches.get(1)).remove(fqn);
        ((CacheImpl)caches.get(0)).stop();
        ((CacheImpl)caches.get(1)).stop();
    }

    protected CacheImpl<Object, Object> createUnstartedCache(boolean optimistic) throws Exception {
        CacheImpl cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        cache.getConfiguration().setClusterName("MyCluster");
        cache.getConfiguration().setStateRetrievalTimeout(3000L);
        cache.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
        if (optimistic) {
            cache.getConfiguration().setNodeLockingScheme("OPTIMISTIC");
        }
        cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        return cache;
    }

    protected CacheImpl<Object, Object> createCache(boolean optimistic) throws Exception {
        CacheImpl<Object, Object> cache = this.createUnstartedCache(optimistic);
        cache.start();
        return cache;
    }

    protected List<CacheImpl<Object, Object>> createCachesWithSharedCL(boolean optimistic) throws Exception {
        ArrayList<CacheImpl<Object, Object>> caches = new ArrayList<CacheImpl<Object, Object>>();
        caches.add(this.createUnstartedCache(optimistic));
        caches.add(this.createUnstartedCache(optimistic));
        ((CacheImpl)caches.get(0)).getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig());
        ((CacheImpl)caches.get(1)).getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig());
        ((CacheImpl)caches.get(0)).start();
        ((CacheImpl)caches.get(1)).start();
        return caches;
    }

    protected CacheLoaderConfig getCacheLoaderConfig() throws Exception {
        String xml = "            <config>\n                <shared>shared</shared>\n                <passivation>false</passivation>\n                <preload></preload>\n                <cacheloader>\n                    <class>org.jboss.cache.loader.DummySharedInMemoryCacheLoader</class>\n                    <async>false</async>\n                    <fetchPersistentState>false</fetchPersistentState>\n                    <ignoreModifications>false</ignoreModifications>\n                </cacheloader>\n                \n            </config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }
}

