/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.jboss.cache.Version;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.eviction.FIFOConfiguration;
import org.jboss.cache.eviction.FIFOPolicy;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.eviction.MRUConfiguration;
import org.jboss.cache.eviction.MRUPolicy;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.cache.jmx.CacheJmxWrapperTestBase;
import org.jboss.cache.loader.FileCacheLoader;
import org.jboss.cache.loader.SingletonStoreCacheLoader;
import org.jboss.cache.loader.jdbm.JdbmCacheLoader;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.multiplexer.MultiplexerTestHelper;
import org.jboss.cache.transaction.BatchModeTransactionManagerLookup;
import org.jboss.cache.xml.XmlHelper;
import org.jgroups.ChannelFactory;
import org.jgroups.jmx.JChannelFactory;
import org.jgroups.jmx.JChannelFactoryMBean;
import org.testng.AssertJUnit;
import org.w3c.dom.Element;

public class LegacyConfigurationTest
extends CacheJmxWrapperTestBase {
    public void testLocalCache() throws Exception {
        CacheJmxWrapper wrapper = new CacheJmxWrapper();
        this.registerWrapper((CacheJmxWrapperMBean<String, String>)wrapper);
        wrapper = MBeanServerInvocationHandler.newProxyInstance(this.mBeanServer, this.mBeanName, CacheJmxWrapperMBean.class, false);
        wrapper.setBuddyReplicationConfig(LegacyConfigurationTest.getBuddyReplicationConfig());
        wrapper.setCacheLoaderConfig(LegacyConfigurationTest.getCacheLoaderConfig());
        wrapper.setCacheMode("REPL_SYNC");
        wrapper.setClusterName("LocalTest");
        wrapper.setClusterConfig(LegacyConfigurationTest.getClusterConfig());
        wrapper.setEvictionPolicyConfig(LegacyConfigurationTest.getEvictionPolicyConfig());
        wrapper.setFetchInMemoryState(false);
        wrapper.setInitialStateRetrievalTimeout(100L);
        wrapper.setInactiveOnStartup(true);
        wrapper.setNodeLockingScheme("OPTIMISTIC");
        wrapper.setIsolationLevel("READ_UNCOMMITTED");
        wrapper.setLockAcquisitionTimeout(200L);
        wrapper.setReplicationVersion("1.0.1");
        wrapper.setReplQueueInterval(15L);
        wrapper.setReplQueueMaxElements(50);
        wrapper.setSyncReplTimeout(300L);
        wrapper.setSyncCommitPhase(true);
        wrapper.setSyncRollbackPhase(true);
        wrapper.setTransactionManagerLookupClass(BatchModeTransactionManagerLookup.class.getName());
        wrapper.setExposeManagementStatistics(false);
        wrapper.setUseRegionBasedMarshalling(true);
        wrapper.setUseReplQueue(true);
        Configuration c = wrapper.getConfiguration();
        AssertJUnit.assertEquals((String)"CacheMode", (String)"REPL_SYNC", (String)wrapper.getCacheMode());
        AssertJUnit.assertEquals((String)"CacheMode", (Object)Configuration.CacheMode.REPL_SYNC, (Object)c.getCacheMode());
        AssertJUnit.assertEquals((String)"ClusterName", (String)"LocalTest", (String)wrapper.getClusterName());
        AssertJUnit.assertEquals((String)"ClusterName", (String)"LocalTest", (String)c.getClusterName());
        AssertJUnit.assertEquals((String)"FetchInMemoryState", (boolean)false, (boolean)wrapper.getFetchInMemoryState());
        AssertJUnit.assertEquals((String)"FetchInMemoryState", (boolean)false, (boolean)c.isFetchInMemoryState());
        AssertJUnit.assertEquals((String)"InitialStateRetrievalTimeout", (long)100L, (long)wrapper.getInitialStateRetrievalTimeout());
        AssertJUnit.assertEquals((String)"InitialStateRetrievalTimeout", (long)100L, (long)c.getStateRetrievalTimeout());
        AssertJUnit.assertEquals((String)"InactiveOnStartup", (boolean)true, (boolean)wrapper.isInactiveOnStartup());
        AssertJUnit.assertEquals((String)"InactiveOnStartup", (boolean)true, (boolean)c.isInactiveOnStartup());
        AssertJUnit.assertEquals((String)"NodeLockingScheme", (String)"OPTIMISTIC", (String)wrapper.getNodeLockingScheme());
        AssertJUnit.assertEquals((String)"NodeLockingScheme", (Object)Configuration.NodeLockingScheme.OPTIMISTIC, (Object)c.getNodeLockingScheme());
        AssertJUnit.assertEquals((String)"IsolationLevel", (String)"READ_UNCOMMITTED", (String)wrapper.getIsolationLevel());
        AssertJUnit.assertEquals((String)"IsolationLevel", (Object)IsolationLevel.READ_UNCOMMITTED, (Object)c.getIsolationLevel());
        AssertJUnit.assertEquals((String)"LockAcquisitionTimeout", (long)200L, (long)wrapper.getLockAcquisitionTimeout());
        AssertJUnit.assertEquals((String)"LockAcquisitionTimeout", (long)200L, (long)c.getLockAcquisitionTimeout());
        AssertJUnit.assertEquals((String)"ReplicationVersion", (String)"1.0.1", (String)wrapper.getReplicationVersion());
        AssertJUnit.assertEquals((String)"ReplicationVersion", (short)Version.getVersionShort((String)"1.0.1"), (short)c.getReplicationVersion());
        AssertJUnit.assertEquals((String)"ReplQueueInterval", (long)15L, (long)wrapper.getReplQueueInterval());
        AssertJUnit.assertEquals((String)"ReplQueueInterval", (long)15L, (long)c.getReplQueueInterval());
        AssertJUnit.assertEquals((String)"ReplQueueMaxElements", (int)50, (int)wrapper.getReplQueueMaxElements());
        AssertJUnit.assertEquals((String)"ReplQueueMaxElements", (int)50, (int)c.getReplQueueMaxElements());
        AssertJUnit.assertEquals((String)"SyncReplTimeout", (long)300L, (long)wrapper.getSyncReplTimeout());
        AssertJUnit.assertEquals((String)"SyncReplTimeout", (long)300L, (long)c.getSyncReplTimeout());
        AssertJUnit.assertEquals((String)"SyncCommitPhase", (boolean)true, (boolean)wrapper.getSyncCommitPhase());
        AssertJUnit.assertEquals((String)"SyncCommitPhase", (boolean)true, (boolean)c.isSyncCommitPhase());
        AssertJUnit.assertEquals((String)"SyncRollbackPhase", (boolean)true, (boolean)wrapper.getSyncRollbackPhase());
        AssertJUnit.assertEquals((String)"SyncRollbackPhase", (boolean)true, (boolean)c.isSyncRollbackPhase());
        AssertJUnit.assertEquals((String)"TransactionManagerLookupClass", (String)BatchModeTransactionManagerLookup.class.getName(), (String)wrapper.getTransactionManagerLookupClass());
        AssertJUnit.assertEquals((String)"TransactionManagerLookupClass", (String)BatchModeTransactionManagerLookup.class.getName(), (String)c.getTransactionManagerLookupClass());
        AssertJUnit.assertEquals((String)"ExposeManagementStatistics", (boolean)false, (boolean)wrapper.getExposeManagementStatistics());
        AssertJUnit.assertEquals((String)"ExposeManagementStatistics", (boolean)false, (boolean)c.getExposeManagementStatistics());
        AssertJUnit.assertEquals((String)"UseRegionBasedMarshalling", (boolean)true, (boolean)wrapper.getUseRegionBasedMarshalling());
        AssertJUnit.assertEquals((String)"UseRegionBasedMarshalling", (boolean)true, (boolean)c.isUseRegionBasedMarshalling());
        AssertJUnit.assertEquals((String)"UseReplQueue", (boolean)true, (boolean)wrapper.getUseReplQueue());
        AssertJUnit.assertEquals((String)"UseReplQueue", (boolean)true, (boolean)c.isUseReplQueue());
        AssertJUnit.assertEquals((String)"ClusterConfig", (String)LegacyConfigurationTest.getClusterConfig().toString(), (String)wrapper.getClusterConfig().toString());
        AssertJUnit.assertEquals((String)"BuddyReplicationConfig", (String)LegacyConfigurationTest.getBuddyReplicationConfig().toString(), (String)wrapper.getBuddyReplicationConfig().toString());
        BuddyReplicationConfig brc = c.getBuddyReplicationConfig();
        AssertJUnit.assertEquals((String)"BR enabled", (boolean)true, (boolean)brc.isEnabled());
        AssertJUnit.assertEquals((String)"BR auto grav", (boolean)false, (boolean)brc.isAutoDataGravitation());
        AssertJUnit.assertEquals((String)"BR remove find", (boolean)false, (boolean)brc.isDataGravitationRemoveOnFind());
        AssertJUnit.assertEquals((String)"BR search backup", (boolean)false, (boolean)brc.isDataGravitationSearchBackupTrees());
        AssertJUnit.assertEquals((String)"BR comm timeout", (int)600000, (int)brc.getBuddyCommunicationTimeout());
        AssertJUnit.assertEquals((String)"BR poolname", (String)"testpool", (String)brc.getBuddyPoolName());
        BuddyReplicationConfig.BuddyLocatorConfig blc = brc.getBuddyLocatorConfig();
        AssertJUnit.assertEquals((String)"BR locator", (String)"org.jboss.cache.buddyreplication.TestBuddyLocator", (String)blc.getBuddyLocatorClass());
        Properties props = blc.getBuddyLocatorProperties();
        AssertJUnit.assertEquals((String)"BR props", (Object)"2", (Object)props.get("numBuddies"));
        AssertJUnit.assertEquals((String)"CacheLoaderConfig", (String)LegacyConfigurationTest.getCacheLoaderConfig().toString(), (String)wrapper.getCacheLoaderConfig().toString());
        CacheLoaderConfig clc = c.getCacheLoaderConfig();
        AssertJUnit.assertEquals((String)"CL passivation", (boolean)false, (boolean)clc.isPassivation());
        AssertJUnit.assertEquals((String)"CL passivation", (boolean)true, (boolean)clc.isShared());
        AssertJUnit.assertEquals((String)"CL preload", (String)"/foo", (String)clc.getPreload());
        List iclcs = clc.getIndividualCacheLoaderConfigs();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = (CacheLoaderConfig.IndividualCacheLoaderConfig)iclcs.get(0);
        AssertJUnit.assertEquals((String)"CL0 class", (String)FileCacheLoader.class.getName(), (String)iclc.getClassName());
        AssertJUnit.assertEquals((String)"CL0 async", (boolean)false, (boolean)iclc.isAsync());
        AssertJUnit.assertEquals((String)"CL0 fetch", (boolean)true, (boolean)iclc.isFetchPersistentState());
        AssertJUnit.assertEquals((String)"CL0 ignore", (boolean)true, (boolean)iclc.isIgnoreModifications());
        AssertJUnit.assertEquals((String)"CL0 purge", (boolean)true, (boolean)iclc.isPurgeOnStartup());
        AssertJUnit.assertEquals((String)"CL0 singleton", (boolean)true, (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"CL0 singleton class", (String)SingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        iclc = (CacheLoaderConfig.IndividualCacheLoaderConfig)iclcs.get(1);
        AssertJUnit.assertEquals((String)"CL1 class", (String)JdbmCacheLoader.class.getName(), (String)iclc.getClassName());
        AssertJUnit.assertEquals((String)"CL1 async", (boolean)true, (boolean)iclc.isAsync());
        AssertJUnit.assertEquals((String)"CL1 fetch", (boolean)false, (boolean)iclc.isFetchPersistentState());
        AssertJUnit.assertEquals((String)"CL1 ignore", (boolean)false, (boolean)iclc.isIgnoreModifications());
        AssertJUnit.assertEquals((String)"CL1 purge", (boolean)false, (boolean)iclc.isPurgeOnStartup());
        AssertJUnit.assertEquals((String)"CL1 singleton", (boolean)false, (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"CL1 singleton class", (String)SingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertEquals((String)"EvictionPolicyConfig", (String)LegacyConfigurationTest.getEvictionPolicyConfig().toString(), (String)wrapper.getEvictionPolicyConfig().toString());
        EvictionConfig ec = c.getEvictionConfig();
        AssertJUnit.assertEquals((String)"EC queue size", (int)20000, (int)ec.getDefaultEventQueueSize());
        AssertJUnit.assertEquals((String)"EC wakeup", (int)5, (int)ec.getWakeupIntervalSeconds());
        AssertJUnit.assertEquals((String)"EC default pol", (String)LRUPolicy.class.getName(), (String)ec.getDefaultEvictionPolicyClass());
        List ercs = ec.getEvictionRegionConfigs();
        EvictionRegionConfig erc = (EvictionRegionConfig)ercs.get(0);
        AssertJUnit.assertEquals((String)"ERC0 name", (String)"/_default_", (String)erc.getRegionName());
        AssertJUnit.assertEquals((String)"ERC0 queue size", (int)1000, (int)erc.getEventQueueSize());
        LRUConfiguration lru = (LRUConfiguration)erc.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((String)"EPC0 pol", (String)LRUPolicy.class.getName(), (String)lru.getEvictionPolicyClass());
        AssertJUnit.assertEquals((String)"EPC0 maxnodes", (int)5000, (int)lru.getMaxNodes());
        AssertJUnit.assertEquals((String)"EPC0 ttl", (int)1000, (int)lru.getTimeToLiveSeconds());
        erc = (EvictionRegionConfig)ercs.get(1);
        AssertJUnit.assertEquals((String)"ERC1 name", (String)"/org/jboss/data", (String)erc.getRegionName());
        AssertJUnit.assertEquals((String)"ERC1 queue size", (int)20000, (int)erc.getEventQueueSize());
        FIFOConfiguration fifo = (FIFOConfiguration)erc.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((String)"EPC1 pol", (String)FIFOPolicy.class.getName(), (String)fifo.getEvictionPolicyClass());
        AssertJUnit.assertEquals((String)"EPC1 maxnodes", (int)5000, (int)fifo.getMaxNodes());
        erc = (EvictionRegionConfig)ercs.get(2);
        AssertJUnit.assertEquals((String)"ERC2 name", (String)"/test", (String)erc.getRegionName());
        AssertJUnit.assertEquals((String)"ERC2 queue size", (int)20000, (int)erc.getEventQueueSize());
        MRUConfiguration mru = (MRUConfiguration)erc.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((String)"EPC2 pol", (String)MRUPolicy.class.getName(), (String)mru.getEvictionPolicyClass());
        AssertJUnit.assertEquals((String)"EPC2 maxnodes", (int)10000, (int)mru.getMaxNodes());
        erc = (EvictionRegionConfig)ercs.get(3);
        AssertJUnit.assertEquals((String)"ERC3 name", (String)"/maxAgeTest", (String)erc.getRegionName());
        AssertJUnit.assertEquals((String)"ERC3 queue size", (int)20000, (int)erc.getEventQueueSize());
        lru = (LRUConfiguration)erc.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((String)"EPC3 pol", (String)LRUPolicy.class.getName(), (String)lru.getEvictionPolicyClass());
        AssertJUnit.assertEquals((String)"EPC3 maxnodes", (int)10000, (int)lru.getMaxNodes());
        AssertJUnit.assertEquals((String)"EPC3 maxage", (int)10, (int)lru.getMaxAgeSeconds());
        AssertJUnit.assertEquals((String)"EPC3 ttl", (int)8, (int)lru.getTimeToLiveSeconds());
    }

    public void testRuntimeConfig() throws Exception {
        CacheJmxWrapper wrapper = new CacheJmxWrapper();
        this.registerWrapper((CacheJmxWrapperMBean<String, String>)wrapper);
        wrapper = MBeanServerInvocationHandler.newProxyInstance(this.mBeanServer, this.mBeanName, CacheJmxWrapperMBean.class, false);
        TransactionManager tm = (TransactionManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TransactionManager.class}, (InvocationHandler)new MockInvocationHandler());
        wrapper.setTransactionManager(tm);
        org.jgroups.JChannelFactory cf = new org.jgroups.JChannelFactory();
        wrapper.setMuxChannelFactory((ChannelFactory)cf);
        RuntimeConfig rc = wrapper.getConfiguration().getRuntimeConfig();
        AssertJUnit.assertSame((String)"Same TM", (Object)tm, (Object)wrapper.getTransactionManager());
        AssertJUnit.assertSame((String)"Same TM", (Object)tm, (Object)rc.getTransactionManager());
        AssertJUnit.assertSame((String)"Same ChannelFactory", (Object)cf, (Object)wrapper.getMuxChannelFactory());
        AssertJUnit.assertSame((String)"Same ChannelFactory", (Object)cf, (Object)rc.getMuxChannelFactory());
    }

    public void testLegacyMuxChannelCreation() throws Exception {
        CacheJmxWrapper wrapper = new CacheJmxWrapper();
        this.registerWrapper((CacheJmxWrapperMBean<String, String>)wrapper);
        wrapper = MBeanServerInvocationHandler.newProxyInstance(this.mBeanServer, this.mBeanName, CacheJmxWrapperMBean.class, false);
        wrapper.setMultiplexerStack("jbc-test");
        org.jgroups.JChannelFactory factory = new org.jgroups.JChannelFactory();
        factory.setDomain("jbc.mux.test");
        factory.setExposeChannels(false);
        factory.setMultiplexerConfig(MultiplexerTestHelper.getClusterConfigElement(this.getDefaultProperties()));
        ObjectName on = new ObjectName("jgroups:service=Mux");
        this.mBeanServer.registerMBean(new JChannelFactory(factory), on);
        wrapper.setMultiplexerService(MBeanServerInvocationHandler.newProxyInstance(this.mBeanServer, on, JChannelFactoryMBean.class, false));
        wrapper.start();
        RuntimeConfig rc = wrapper.getConfiguration().getRuntimeConfig();
        AssertJUnit.assertNotNull((String)"Channel created", (Object)rc.getChannel());
    }

    protected static Element getBuddyReplicationConfig() throws Exception {
        String xmlString = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled>\n          <buddyCommunicationTimeout>600000</buddyCommunicationTimeout>\n          <buddyLocatorClass>org.jboss.cache.buddyreplication.TestBuddyLocator</buddyLocatorClass>\n          <buddyLocatorProperties>numBuddies = 2</buddyLocatorProperties>\n          <buddyPoolName>testpool</buddyPoolName>          <autoDataGravitation>false</autoDataGravitation>\n          <dataGravitationRemoveOnFind>false</dataGravitationRemoveOnFind>\n          <dataGravitationSearchBackupTrees>false</dataGravitationSearchBackupTrees></config>";
        return XmlHelper.stringToElement((String)xmlString);
    }

    protected static Element getCacheLoaderConfig() throws Exception {
        String xml = "<config>\n<passivation>false</passivation>\n<preload>/foo</preload>\n<shared>true</shared>\n<cacheloader>\n<class>org.jboss.cache.loader.FileCacheLoader</class>\n<properties> location=/tmp\n</properties>\n<async>false</async>\n<fetchPersistentState>true</fetchPersistentState>\n<ignoreModifications>true</ignoreModifications>\n<purgeOnStartup>true</purgeOnStartup>\n<singletonStore><enabled>true</enabled></singletonStore></cacheloader>\n<cacheloader>\n<class>org.jboss.cache.loader.jdbm.JdbmCacheLoader</class>\n<properties> location=/home/bstansberry\n</properties>\n<async>true</async>\n<fetchPersistentState>false</fetchPersistentState>\n<ignoreModifications>false</ignoreModifications>\n<purgeOnStartup>false</purgeOnStartup>\n<singletonStore><enabled>false</enabled></singletonStore></cacheloader>\n</config>";
        return XmlHelper.stringToElement((String)xml);
    }

    protected static Element getEvictionPolicyConfig() throws Exception {
        String xml = "<config>\n<attribute name=\"wakeUpIntervalSeconds\">5</attribute>\n<attribute name=\"eventQueueSize\">20000</attribute>\n<attribute name=\"policyClass\">org.jboss.cache.eviction.LRUPolicy</attribute>\n<region name=\"/_default_\" eventQueueSize=\"1000\">\n   <attribute name=\"maxNodes\">5000</attribute>\n   <attribute name=\"timeToLiveSeconds\">1000</attribute>\n</region>\n<region name=\"/org/jboss/data\" policyClass=\"org.jboss.cache.eviction.FIFOPolicy\">\n   <attribute name=\"maxNodes\">5000</attribute>\n</region>\n<region name=\"/test/\" policyClass=\"org.jboss.cache.eviction.MRUPolicy\">\n   <attribute name=\"maxNodes\">10000</attribute>\n</region>\n<region name=\"/maxAgeTest/\">\n   <attribute name=\"maxNodes\">10000</attribute>\n   <attribute name=\"timeToLiveSeconds\">8</attribute>\n   <attribute name=\"maxAgeSeconds\">10</attribute>\n</region>\n </config>\n";
        return XmlHelper.stringToElement((String)xml);
    }

    protected static Element getClusterConfig() throws Exception {
        String xml = "<config>\n  <UDP mcast_addr=\"228.10.10.10\"\n           mcast_port=\"45588\"\n           tos=\"8\"\n           ucast_recv_buf_size=\"20000000\"\n           ucast_send_buf_size=\"640000\"\n           mcast_recv_buf_size=\"25000000\"\n           mcast_send_buf_size=\"640000\"\n           loopback=\"false\"\n           discard_incompatible_packets=\"true\"\n           max_bundle_size=\"64000\"\n           max_bundle_timeout=\"30\"\n           use_incoming_packet_handler=\"true\"\n           ip_ttl=\"2\"\n           enable_bundling=\"false\"\n           enable_diagnostics=\"true\"\n           use_concurrent_stack=\"true\"\n           thread_naming_pattern=\"pl\"\n           thread_pool.enabled=\"true\"\n           thread_pool.min_threads=\"1\"\n           thread_pool.max_threads=\"25\"\n           thread_pool.keep_alive_time=\"30000\"\n           thread_pool.queue_enabled=\"true\"\n           thread_pool.queue_max_size=\"10\"\n           thread_pool.rejection_policy=\"Run\"\n           oob_thread_pool.enabled=\"true\"\n           oob_thread_pool.min_threads=\"1\"\n           oob_thread_pool.max_threads=\"4\"\n           oob_thread_pool.keep_alive_time=\"10000\"\n           oob_thread_pool.queue_enabled=\"true\"\n           oob_thread_pool.queue_max_size=\"10\"\n           oob_thread_pool.rejection_policy=\"Run\"/>\n      <PING timeout=\"2000\" num_initial_members=\"3\"/>\n      <MERGE2 max_interval=\"30000\" min_interval=\"10000\"/>\n      <FD_SOCK/>\n      <FD timeout=\"10000\" max_tries=\"5\" shun=\"true\"/>\n      <VERIFY_SUSPECT timeout=\"1500\"/>\n      <pbcast.NAKACK max_xmit_size=\"60000\"\n                     use_mcast_xmit=\"false\" gc_lag=\"0\"\n                     retransmit_timeout=\"300,600,1200,2400,4800\"\n                     discard_delivered_msgs=\"true\"/>\n      <UNICAST timeout=\"300,600,1200,2400,3600\"/>\n      <pbcast.STABLE stability_delay=\"1000\" desired_avg_gossip=\"50000\"\n                     max_bytes=\"400000\"/>\n      <pbcast.GMS print_local_addr=\"true\" join_timeout=\"5000\"\n                  join_retry_timeout=\"2000\" shun=\"false\"\n                  view_bundling=\"true\" view_ack_collection_timeout=\"5000\"/>\n      <FRAG2 frag_size=\"60000\"/>\n      <pbcast.STREAMING_STATE_TRANSFER use_reading_thread=\"true\"/>\n      <pbcast.FLUSH timeout=\"0\"/>\n</config>";
        return XmlHelper.stringToElement((String)xml);
    }

    protected String getDefaultProperties() {
        return "UDP(mcast_addr=224.0.0.36;mcast_port=55566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=1000;num_initial_members=2):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;max_xmit_size=8192;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8192;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    }

    class MockInvocationHandler
    implements InvocationHandler {
        MockInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }
    }
}

