/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ReadWriteLockTest {
    ReadWriteLock lock;
    Exception ex = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.ex = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.lock = null;
        if (this.ex != null) {
            throw this.ex;
        }
    }

    public void testMoreWriteReleasesThanAcquisitions() throws InterruptedException {
        this.lock = new ReentrantReadWriteLock();
        this.lock.writeLock().lock();
        this.lock.writeLock().unlock();
        try {
            this.lock.writeLock().unlock();
            AssertJUnit.fail((String)"Should have barfed");
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testMoreReadReleasesThanAcquisitions() throws InterruptedException {
        this.lock = new ReentrantReadWriteLock();
        this.lock.readLock().lock();
        this.lock.readLock().unlock();
        try {
            this.lock.readLock().unlock();
            AssertJUnit.fail((String)"read locks cannot be released more than acquired");
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testSimple() throws InterruptedException {
        this.lock = new ReentrantReadWriteLock();
        this.lock.readLock().lock();
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
        this.lock.writeLock().lock();
        this.lock.readLock().lock();
        this.lock.readLock().lock();
        this.lock.writeLock().lock();
        this.lock.writeLock().lock();
    }

    public void testOneWriterMultipleReaders() throws InterruptedException {
        this.lock = new ReentrantReadWriteLock();
        Writer writer = new Writer("writer");
        Reader reader1 = new Reader("reader1");
        Reader reader2 = new Reader("reader2");
        writer.start();
        reader1.start();
        reader2.start();
        writer.join();
        reader1.join();
        reader2.join();
    }

    static void log(String msg) {
        System.out.println(Thread.currentThread().getName() + ": " + msg);
    }

    class Reader
    extends Thread {
        public Reader(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReadWriteLockTest.log("acquiring RL");
                ReadWriteLockTest.this.lock.readLock().lock();
                ReadWriteLockTest.log("acquired RL successfully");
                Reader.sleep(500L);
            }
            catch (InterruptedException e) {
                ReadWriteLockTest.this.ex = e;
            }
            finally {
                ReadWriteLockTest.log("releasing RL");
                ReadWriteLockTest.this.lock.readLock().unlock();
            }
        }
    }

    class Writer
    extends Thread {
        public Writer(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReadWriteLockTest.log("acquiring WL");
                ReadWriteLockTest.this.lock.writeLock().lock();
                ReadWriteLockTest.log("acquired WL successfully");
                Writer.sleep(1000L);
            }
            catch (InterruptedException e) {
                ReadWriteLockTest.this.ex = e;
            }
            finally {
                ReadWriteLockTest.log("releasing WL");
                ReadWriteLockTest.this.lock.writeLock().unlock();
            }
        }
    }
}

