/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.lang.reflect.Method;
import java.util.Collections;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class RemoteCallerReturnValuesTest {
    private CacheImpl<Object, Object> cache;
    private Fqn fqn = Fqn.fromString((String)"/a");
    private Object key = "key";
    private Object value = "value";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache();
        this.cache.put(this.fqn, this.key, this.value);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cache.stop();
    }

    public void testMethodsThatShouldReturnValues() throws Throwable {
        Object retval = this.cache._replicate(MethodCallFactory.create((Method)MethodDeclarations.clusteredGetMethod, (Object[])new Object[]{MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{this.fqn}), false}));
        AssertJUnit.assertNotNull((Object)retval);
        AssertJUnit.assertNotNull((Object)this.cache._replicate(MethodCallFactory.create((Method)MethodDeclarations.dataGravitationMethod, (Object[])new Object[]{this.fqn, false})));
    }

    public void testMethodsThatShouldReturnNull() throws Throwable {
        this.doNullReturnTest(MethodDeclarations.getDataMapMethodLocal, this.fqn);
        this.doNullReturnTest(MethodDeclarations.existsMethod, this.fqn);
        this.doNullReturnTest(MethodDeclarations.getNodeMethodLocal, this.fqn);
        this.doNullReturnTest(MethodDeclarations.getKeysMethodLocal, this.fqn);
        this.doNullReturnTest(MethodDeclarations.getChildrenNamesMethodLocal, this.fqn);
        this.doNullReturnTest(MethodDeclarations.releaseAllLocksMethodLocal, this.fqn);
        this.doNullReturnTest(MethodDeclarations.printMethodLocal, this.fqn);
        this.doNullReturnTest(MethodDeclarations.remoteAnnounceBuddyPoolNameMethod, this.cache.getLocalAddress(), null);
        this.doNullReturnTest(MethodDeclarations.remoteRemoveFromBuddyGroupMethod, "arse");
        this.doNullReturnTest(MethodDeclarations.remoteAssignToBuddyGroupMethod, new BuddyGroup(), Collections.emptyMap());
        this.doNullReturnTest(MethodDeclarations.moveMethodLocal, this.fqn, Fqn.ROOT);
        this.doNullReturnTest(MethodDeclarations.blockChannelLocal, new Object[0]);
        this.doNullReturnTest(MethodDeclarations.unblockChannelLocal, new Object[0]);
    }

    private void doNullReturnTest(Method m, Object ... args) throws Throwable {
        MethodCall c = MethodCallFactory.create((Method)m, (Object[])args);
        AssertJUnit.assertNull((String)(m + " should return a null when called remotely"), (Object)this.cache._replicate(c));
    }
}

