/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticReplicationInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.xml.XmlHelper;
import org.jgroups.Address;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public abstract class AbstractOptimisticTestCase {
    protected Fqn<String> fqn = Fqn.fromString((String)"/blah");
    protected String key = "myKey";
    protected String value = "myValue";
    protected Random random;

    protected CacheImpl<Object, Object> createCacheUnstarted() throws Exception {
        return this.createCacheUnstarted(true);
    }

    protected CacheImpl<Object, Object> createCacheUnstarted(boolean optimistic) throws Exception {
        CacheImpl cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        Configuration c = new Configuration();
        cache.setConfiguration(c);
        if (optimistic) {
            c.setNodeLockingScheme("OPTIMISTIC");
        }
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.setCacheMode("LOCAL");
        return cache;
    }

    protected CacheImpl<Object, Object> createCacheWithListener() throws Exception {
        return this.createCacheWithListener(new TestListener());
    }

    protected CacheImpl<Object, Object> createCacheWithListener(Object listener) throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheUnstarted();
        cache.create();
        cache.start();
        cache.getNotifier().addCacheListener(listener);
        return cache;
    }

    protected CacheImpl<Object, Object> createCacheWithLoader() throws Exception {
        return this.createCacheWithLoader(false);
    }

    protected CacheLoaderConfig getCacheLoaderConfig(boolean shared, boolean passivation) throws Exception {
        String xml = "            <config>\n                <passivation>" + passivation + "</passivation>\n" + "                <preload></preload>\n" + "                <shared>" + shared + "</shared>\n" + "                <cacheloader>\n" + "                    <class>" + (shared ? DummySharedInMemoryCacheLoader.class.getName() : DummyInMemoryCacheLoader.class.getName()) + "</class>\n" + "                    <properties>\n" + "                    </properties>\n" + "                    <async>false</async>\n" + "                    <fetchPersistentState>" + !shared + "</fetchPersistentState>\n" + "                    <ignoreModifications>false</ignoreModifications>\n" + "                </cacheloader>\n" + "            </config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    protected CacheImpl<Object, Object> createCacheWithLoader(boolean passivationEnabled) throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheUnstarted();
        Configuration c = cache.getConfiguration();
        cache.setConfiguration(c);
        c.setCacheLoaderConfig(this.getCacheLoaderConfig(true, passivationEnabled));
        cache.create();
        cache.start();
        return cache;
    }

    protected CacheImpl<Object, Object> createCache() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheUnstarted();
        cache.create();
        cache.start();
        return cache;
    }

    protected void destroyCache(Cache<Object, Object> c) {
        c.stop();
        c.destroy();
    }

    protected CacheImpl<Object, Object> createPessimisticCache() throws Exception {
        CacheImpl cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        Configuration c = new Configuration();
        cache.setConfiguration(c);
        c.setClusterName("name");
        c.setStateRetrievalTimeout(5000L);
        c.setClusterConfig(this.getDefaultProperties());
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cache.create();
        cache.start();
        return cache;
    }

    protected CacheImpl<Object, Object> createPessimisticCacheLocal() throws Exception {
        CacheImpl cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        Configuration c = new Configuration();
        cache.setConfiguration(c);
        c.setClusterName("name");
        c.setStateRetrievalTimeout(5000L);
        c.setClusterConfig(this.getDefaultProperties());
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cache.create();
        cache.start();
        return cache;
    }

    protected String getDefaultProperties() {
        return "UDP(mcast_addr=228.1.2.3;mcast_port=48866;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;loopback=true;ip_mcast=true;bind_addr=127.0.0.1):PING(timeout=1000;num_initial_members=2):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;max_xmit_size=8192;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8192;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    }

    protected CacheImpl<Object, Object> createReplicatedCache(Configuration.CacheMode mode) throws Exception {
        return this.createReplicatedCache("test", mode);
    }

    protected CacheImpl<Object, Object> createReplicatedCache(String name, Configuration.CacheMode mode) throws Exception {
        CacheImpl cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        Configuration c = new Configuration();
        cache.setConfiguration(c);
        c.setClusterName(name);
        c.setStateRetrievalTimeout(5000L);
        c.setClusterConfig(this.getDefaultProperties());
        c.setCacheMode(mode);
        if (mode == Configuration.CacheMode.REPL_SYNC) {
            c.setSyncCommitPhase(true);
            c.setSyncRollbackPhase(true);
        }
        c.setNodeLockingScheme("OPTIMISTIC");
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        cache.create();
        cache.start();
        return cache;
    }

    protected CacheImpl<Object, Object> createReplicatedCacheWithLoader(boolean shared, Configuration.CacheMode cacheMode) throws Exception {
        return this.createReplicatedCacheWithLoader("temp-loader", shared, cacheMode);
    }

    protected CacheImpl<Object, Object> createReplicatedCacheWithLoader(boolean shared) throws Exception {
        return this.createReplicatedCacheWithLoader("temp-loader", shared, Configuration.CacheMode.REPL_SYNC);
    }

    protected CacheImpl<Object, Object> createReplicatedCacheWithLoader(String name, boolean shared) throws Exception {
        return this.createReplicatedCacheWithLoader(name, shared, Configuration.CacheMode.REPL_SYNC);
    }

    protected CacheImpl<Object, Object> createReplicatedCacheWithLoader(String name, boolean shared, Configuration.CacheMode cacheMode) throws Exception {
        CacheImpl cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        Configuration c = new Configuration();
        cache.setConfiguration(c);
        c.setClusterName(name);
        c.setStateRetrievalTimeout(5000L);
        c.setClusterConfig(this.getDefaultProperties());
        c.setCacheMode(cacheMode);
        c.setSyncCommitPhase(true);
        c.setSyncRollbackPhase(true);
        c.setNodeLockingScheme("OPTIMISTIC");
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.setCacheLoaderConfig(this.getCacheLoaderConfig(shared, false));
        cache.create();
        cache.start();
        return cache;
    }

    protected void randomSleep(int min, int max) {
        if (this.random == null) {
            this.random = new Random();
        }
        long l = -1L;
        while (l < (long)min) {
            l = this.random.nextInt(max);
        }
        TestingUtil.sleepThread(l);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TransactionManager mgr = TransactionSetup.getManager();
        try {
            if (mgr.getTransaction() != null) {
                mgr.rollback();
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    protected Interceptor getAlteredInterceptorChain(Interceptor newLast, CacheSPI<Object, Object> spi, boolean replicated) {
        InvocationContextInterceptor ici = new InvocationContextInterceptor();
        ici.setCache(spi);
        TxInterceptor txInterceptor = new TxInterceptor();
        txInterceptor.setCache(spi);
        OptimisticReplicationInterceptor replicationInterceptor = new OptimisticReplicationInterceptor();
        replicationInterceptor.setCache(spi);
        OptimisticCreateIfNotExistsInterceptor createInterceptor = new OptimisticCreateIfNotExistsInterceptor();
        createInterceptor.setCache(spi);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(spi);
        ici.setNext((Interceptor)txInterceptor);
        if (replicated) {
            txInterceptor.setNext((Interceptor)replicationInterceptor);
            replicationInterceptor.setNext((Interceptor)createInterceptor);
        } else {
            txInterceptor.setNext((Interceptor)createInterceptor);
        }
        createInterceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext(newLast);
        return ici;
    }

    protected List<MethodCall> injectDataVersion(List<MethodCall> modifications) {
        LinkedList<MethodCall> newList = new LinkedList<MethodCall>();
        for (MethodCall c : modifications) {
            Object[] oa = c.getArgs();
            Object[] na = new Object[oa.length + 1];
            System.out.println("*** " + oa.length);
            System.arraycopy(oa, 0, na, 0, oa.length);
            na[oa.length] = new DefaultDataVersion();
            newList.add(MethodCallFactory.create((Method)MethodDeclarations.getVersionedMethod((int)c.getMethodId()), (Object[])na));
        }
        return newList;
    }

    protected class DummyAddress
    implements Address {
        private static final long serialVersionUID = -2628268587640985944L;

        protected DummyAddress() {
        }

        public int compareTo(Object arg0) {
            return 0;
        }

        public void readFrom(DataInputStream arg0) {
        }

        public void writeTo(DataOutputStream arg0) {
        }

        public void readExternal(ObjectInput arg0) {
        }

        public void writeExternal(ObjectOutput arg0) {
        }

        public int size() {
            return 0;
        }

        public boolean isMulticastAddress() {
            return false;
        }
    }

    public abstract class ExceptionThread
    extends Thread {
        protected Exception exception;

        public void setException(Exception e) {
            this.exception = e;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

