/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options.cachemodelocal;

import java.util.HashMap;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class CacheModeLocalTestBase {
    protected Configuration.CacheMode cacheMode;
    protected String nodeLockingScheme;
    protected boolean isInvalidation;
    private CacheImpl<String, String> cache1;
    private CacheImpl<String, String> cache2;
    private Fqn fqn = Fqn.fromString((String)"/a");
    private String key = "key";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache1 != null || this.cache2 != null) {
            this.tearDown();
        }
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache1 = (CacheImpl)instance.createCache(false);
        this.cache1.getConfiguration().setClusterName("test");
        this.cache1.getConfiguration().setStateRetrievalTimeout(1000L);
        this.cache1.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache1.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        this.cache1.getConfiguration().setCacheMode(this.cacheMode);
        this.cache1.start();
        this.cache2 = (CacheImpl)instance.createCache(false);
        this.cache2.getConfiguration().setClusterName("test");
        this.cache2.getConfiguration().setStateRetrievalTimeout(1000L);
        this.cache2.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache2.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        this.cache2.getConfiguration().setCacheMode(this.cacheMode);
        this.cache2.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache1 != null) {
            this.cache1.stop();
            this.flushTxs(this.cache1.getTransactionManager());
            this.cache1 = null;
        }
        if (this.cache2 != null) {
            this.cache2.stop();
            this.flushTxs(this.cache2.getTransactionManager());
            this.cache2 = null;
        }
    }

    private void flushTxs(TransactionManager mgr) {
        if (mgr != null) {
            try {
                if (mgr.getTransaction() != null) {
                    mgr.rollback();
                }
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    public void testPutKeyValue() throws Exception {
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        this.delay();
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        Assert.assertNull((String)"Should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
        this.cache1.getInvocationContext().getOptionOverrides().reset();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        this.delay();
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (!this.isInvalidation) {
            Assert.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        } else {
            Assert.assertNull((String)"should be invalidated", (Object)this.cache2.get(this.fqn, (Object)this.key));
        }
        this.cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache2.put(this.fqn, (Object)this.key, (Object)"value2");
        this.delay();
        Assert.assertEquals((String)"value2", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        this.cache2.getInvocationContext().getOptionOverrides().reset();
        this.cache2.put(this.fqn, (Object)this.key, (Object)"value2");
        this.delay();
        Assert.assertEquals((String)"value2", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        if (!this.isInvalidation) {
            Assert.assertEquals((String)"value2", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        } else {
            Assert.assertNull((String)"should be invalidated", (Object)this.cache1.get(this.fqn, (Object)this.key));
        }
    }

    public void testPutData() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.key, "value");
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.put(this.fqn, map);
        this.delay();
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        Assert.assertNull((String)"Should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        this.cache1.put(this.fqn, map);
        this.delay();
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (!this.isInvalidation) {
            Assert.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        } else {
            Assert.assertNull((String)"should be invalidated", (Object)this.cache2.get(this.fqn, (Object)this.key));
        }
        map.put(this.key, "value2");
        this.cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache2.put(this.fqn, map);
        this.delay();
        Assert.assertEquals((String)"value2", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        this.cache2.getInvocationContext().getOptionOverrides().reset();
        this.cache2.put(this.fqn, (Object)this.key, (Object)"value2");
        this.delay();
        Assert.assertEquals((String)"value2", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        if (!this.isInvalidation) {
            Assert.assertEquals((String)"value2", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        } else {
            Assert.assertNull((String)"should be invalidated", (Object)this.cache1.get(this.fqn, (Object)this.key));
        }
    }

    public void testRemoveNode() throws Exception {
        this.cache1.getInvocationContext().setOptionOverrides(null);
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        this.delay();
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (this.isInvalidation) {
            Assert.assertNull((String)"Should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
        } else {
            Assert.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        }
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.removeNode(this.fqn);
        this.delay();
        Assert.assertNull((String)"should be null", (Object)this.cache1.get(this.fqn, (Object)this.key));
        if (this.isInvalidation) {
            Assert.assertNull((String)"Should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
        } else {
            Assert.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        }
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        this.delay();
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (this.isInvalidation) {
            Assert.assertNull((String)"Should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
        } else {
            Assert.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        }
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        this.cache1.remove(this.fqn);
        this.delay();
        Assert.assertNull((String)"should be null", (Object)this.cache1.get(this.fqn, (Object)this.key));
        Assert.assertNull((String)"should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
    }

    public void testRemoveKey() throws Exception {
        this.cache1.getInvocationContext().setOptionOverrides(null);
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        this.delay();
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (this.isInvalidation) {
            Assert.assertNull((String)"Should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
        } else {
            Assert.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        }
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.remove(this.fqn, (Object)this.key);
        this.delay();
        Assert.assertNull((String)"should be null", (Object)this.cache1.get(this.fqn, (Object)this.key));
        if (this.isInvalidation) {
            Assert.assertNull((String)"Should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
        } else {
            Assert.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        }
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        this.delay();
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (this.isInvalidation) {
            Assert.assertNull((String)"Should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
        } else {
            Assert.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        }
        this.cache1.getInvocationContext().getOptionOverrides().reset();
        this.cache1.remove(this.fqn, (Object)this.key);
        this.delay();
        Assert.assertNull((String)"should be null", (Object)this.cache1.get(this.fqn, (Object)this.key));
        Assert.assertNull((String)"should be null", (Object)this.cache2.get(this.fqn, (Object)this.key));
    }

    public void testTransactionalBehaviour() throws Exception {
        TransactionManager mgr = this.cache1.getTransactionManager();
        mgr.begin();
        this.cache1.getInvocationContext().getOptionOverrides().reset();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value1");
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value2");
        mgr.commit();
        this.delay();
        Assert.assertEquals((String)"value2", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (!this.isInvalidation) {
            Assert.assertEquals((String)"value1", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        } else {
            AssertJUnit.assertNull((Object)this.cache2.get(this.fqn, (Object)this.key));
        }
        mgr.begin();
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value3");
        this.cache1.getInvocationContext().getOptionOverrides().reset();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        mgr.commit();
        this.delay();
        Assert.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (!this.isInvalidation) {
            Assert.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        } else {
            Assert.assertNull((String)"should be invalidated", (Object)this.cache2.get(this.fqn, (Object)this.key));
        }
        mgr = this.cache2.getTransactionManager();
        mgr.begin();
        this.cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        this.cache2.put(this.fqn, (Object)this.key, (Object)"value3");
        this.cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache2.put(this.fqn, (Object)this.key, (Object)"value2");
        mgr.commit();
        this.delay();
        Assert.assertEquals((String)"value2", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value3", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        } else {
            AssertJUnit.assertNull((Object)this.cache1.get(this.fqn, (Object)this.key));
        }
        mgr.begin();
        this.cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache2.put(this.fqn, (Object)this.key, (Object)"value2");
        this.cache2.getInvocationContext().getOptionOverrides().reset();
        this.cache2.put(this.fqn, (Object)this.key, (Object)"value2");
        mgr.commit();
        this.delay();
        Assert.assertEquals((String)"value2", (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        if (!this.isInvalidation) {
            Assert.assertEquals((String)"value2", (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        } else {
            Assert.assertNull((String)"should be invalidated", (Object)this.cache1.get(this.fqn, (Object)this.key));
        }
    }

    protected abstract void delay();
}

