/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.event.NodeEvent;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"})
public class ReplicatedPassivationIntegrationTest {
    private CacheImpl<String, String> cache_;
    private CacheImpl<String, String> cache1_;
    protected static final Log log = LogFactory.getLog(ReplicatedPassivationIntegrationTest.class);
    int wakeupIntervalMillis_ = 0;
    PassivationListener listener_ = new PassivationListener();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache_ = (CacheImpl)instance.createCache(false);
        this.initCaches(this.cache_);
        this.cache_.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache_.start();
        this.cache1_ = (CacheImpl)instance.createCache(false);
        this.initCaches(this.cache1_);
        this.cache1_.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache1_.start();
        this.cache1_.getNotifier().addCacheListener((Object)this.listener_);
        this.listener_.resetCounter();
        this.wakeupIntervalMillis_ = this.cache1_.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis_);
        if (this.wakeupIntervalMillis_ <= 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
    }

    void initCaches(CacheImpl<String, String> cache) throws Exception {
        cache.setConfiguration(new XmlConfigurationParser().parseFile("META-INF/replSync-passivation-service.xml"));
        cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cache.getConfiguration().getCacheLoaderConfig().getFirstCacheLoaderConfig().setClassName(DummyInMemoryCacheLoader.class.getName());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache_.stop();
        this.cache1_.stop();
    }

    public void testActivationEvent() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        String rootStr1 = "/__JBossInternal__/5c4o12-pzhlhj-esnuy3sg-1-esnuy3sg-2";
        String str = rootStr + "0";
        this.cache_.remove("/");
        this.cache_.put(str, (Object)str, (Object)str);
        this.cache_.put(rootStr1, (Object)str, (Object)str);
        TestingUtil.sleepThread(11000L);
        AssertJUnit.assertFalse((String)"UnversionedNode should not exist", (boolean)this.cache1_.exists(str, (Object)str));
        String val = (String)this.cache1_.get(str, (Object)str);
        val = (String)this.cache1_.get(rootStr1, (Object)str);
        AssertJUnit.assertNotNull((String)"DataNode should be activated ", (Object)val);
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    @CacheListener
    public class PassivationListener {
        int counter = 0;
        int loadedCounter = 0;

        public int getCounter() {
            return this.counter;
        }

        public void resetCounter() {
            this.counter = 0;
            this.loadedCounter = 0;
        }

        @NodeActivated
        public void nodeActivated(NodeEvent ne) {
            if (!ne.isPre()) {
                ++this.counter;
                System.out.println("nodeActivate(): counter: " + this.counter);
                System.out.println("nodeActivate(): " + ne.getFqn());
            }
        }

        @NodePassivated
        public void nodePassivated(NodeEvent ne) {
            if (ne.isPre()) {
                System.out.println("nodePassivate(): " + ne.getFqn());
            }
        }

        @NodeLoaded
        public void nodeLoaded(NodeEvent ne) {
            if (!ne.isPre()) {
                ++this.loadedCounter;
            }
        }
    }
}

