/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannel;
import org.jgroups.StateTransferException;
import org.jgroups.View;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.mux.Multiplexer;
import org.jgroups.mux.MuxChannel;
import org.jgroups.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JChannelFactory
implements ChannelFactory {
    private ProtocolStackConfigurator configurator;
    private Log log = LogFactory.getLog(this.getClass());
    private final Map<String, String> stacks = new HashMap<String, String>();
    private final Map<String, Entry> channels = new HashMap<String, Entry>();
    private String config = null;
    private MBeanServer server = null;
    private String domain = null;
    private boolean expose_channels = true;
    private boolean expose_protocols = true;
    private static final String PROTOCOL_STACKS = "protocol_stacks";
    private static final String STACK = "stack";
    private static final String NAME = "name";
    private static final String CONFIG = "config";

    public JChannelFactory() {
    }

    public JChannelFactory(File properties) throws ChannelException {
        this.configurator = ConfiguratorFactory.getStackConfigurator(properties);
    }

    public JChannelFactory(Element properties) throws ChannelException {
        this.configurator = ConfiguratorFactory.getStackConfigurator(properties);
    }

    public JChannelFactory(URL properties) throws ChannelException {
        this.configurator = ConfiguratorFactory.getStackConfigurator(properties);
    }

    public JChannelFactory(String properties) throws ChannelException {
        this.configurator = ConfiguratorFactory.getStackConfigurator(properties);
    }

    public void setMultiplexerConfig(Object properties) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream(properties);
        if (input == null) {
            throw new FileNotFoundException(properties.toString());
        }
        try {
            this.parse(input);
        }
        catch (Exception ex) {
            throw new Exception("failed parsing " + properties, ex);
        }
        finally {
            Util.close(input);
        }
    }

    public void setMultiplexerConfig(File file) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream(file);
        if (input == null) {
            throw new FileNotFoundException(file.toString());
        }
        try {
            this.parse(input);
        }
        catch (Exception ex) {
            throw new Exception("failed parsing " + file.toString(), ex);
        }
        finally {
            Util.close(input);
        }
    }

    public void setMultiplexerConfig(Element properties) throws Exception {
        this.parse(properties);
    }

    public void setMultiplexerConfig(URL url) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream(url);
        if (input == null) {
            throw new FileNotFoundException(url.toString());
        }
        try {
            this.parse(input);
        }
        catch (Exception ex) {
            throw new Exception("failed parsing " + url.toString(), ex);
        }
        finally {
            Util.close(input);
        }
    }

    public String getMultiplexerConfig() {
        return this.config;
    }

    public void setMultiplexerConfig(String properties) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream(properties);
        if (input == null) {
            throw new FileNotFoundException(properties);
        }
        try {
            this.parse(input);
            this.config = properties;
        }
        catch (Exception ex) {
            throw new Exception("failed parsing " + properties, ex);
        }
        finally {
            Util.close(input);
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isExposeChannels() {
        return this.expose_channels;
    }

    public void setExposeChannels(boolean expose_channels) {
        this.expose_channels = expose_channels;
    }

    public boolean isExposeProtocols() {
        return this.expose_protocols;
    }

    public void setExposeProtocols(boolean expose_protocols) {
        this.expose_protocols = expose_protocols;
        if (expose_protocols) {
            this.expose_channels = true;
        }
    }

    public Channel createChannel(Object properties) throws ChannelException {
        return new JChannel(properties);
    }

    public Channel createChannel() throws ChannelException {
        return new JChannel(this.configurator);
    }

    public Channel createMultiplexerChannel(String stack_name, String id) throws Exception {
        return this.createMultiplexerChannel(stack_name, id, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel createMultiplexerChannel(String stack_name, String id, boolean register_for_state_transfer, String substate_id) throws Exception {
        Entry entry;
        if (stack_name == null || id == null) {
            throw new IllegalArgumentException("stack name and service ID have to be non null");
        }
        Object object = this.channels;
        synchronized (object) {
            entry = this.channels.get(stack_name);
            if (entry == null) {
                entry = new Entry();
                this.channels.put(stack_name, entry);
            }
        }
        object = entry;
        synchronized (object) {
            Multiplexer mux;
            JChannel ch = entry.channel;
            if (ch == null) {
                String props = this.getConfig(stack_name);
                entry.channel = ch = new JChannel(props);
                if (this.expose_channels && this.server != null) {
                    this.registerChannel(ch, stack_name);
                }
            }
            if ((mux = entry.multiplexer) == null) {
                entry.multiplexer = mux = new Multiplexer(ch);
            }
            if (register_for_state_transfer) {
                mux.registerForStateTransfer(id, substate_id);
            }
            return mux.createMuxChannel(this, id, stack_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMuxChannel(String stack_name, String id) {
        Entry entry = null;
        Object object = this.channels;
        synchronized (object) {
            entry = this.channels.get(stack_name);
        }
        if (entry != null) {
            object = entry;
            synchronized (object) {
                if (entry.multiplexer != null) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 6, 7] lbl16 : MonitorExitStatement: MONITOREXIT : var4_4
                    Set<String> services = entry.multiplexer.getServiceIds();
                    return services != null && services.contains(id);
                }
            }
        }
        return false;
    }

    private void registerChannel(JChannel ch, String stack_name) throws Exception {
        JmxConfigurator.registerChannel(ch, this.server, this.domain, stack_name, this.expose_protocols);
    }

    private void unregister(String name) throws Exception {
        JmxConfigurator.unregister(this.server, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MuxChannel ch) throws ChannelException {
        Entry entry;
        Object object = this.channels;
        synchronized (object) {
            entry = this.channels.get(ch.getStackName());
        }
        if (entry != null) {
            object = entry;
            synchronized (object) {
                block19: {
                    if (entry.channel == null || entry.multiplexer == null) {
                        throw new ChannelException("channel has to be created before it can be connected");
                    }
                    entry.multiplexer.addServiceIfNotPresent(ch.getId(), ch);
                    if (!entry.channel.isConnected()) {
                        entry.channel.connect(ch.getStackName());
                        try {
                            entry.multiplexer.fetchServiceInformation();
                        }
                        catch (Exception e) {
                            if (!this.log.isErrorEnabled()) break block19;
                            this.log.error((Object)"failed fetching service state", (Throwable)e);
                        }
                    }
                }
                try {
                    boolean successfulFlush;
                    Address addr = entry.channel.getLocalAddress();
                    if (entry.channel.flushSupported() && !(successfulFlush = entry.channel.startFlush(3000L, false)) && this.log.isWarnEnabled()) {
                        this.log.warn((Object)("Flush failed at " + ch.getLocalAddress() + " " + ch.getId()));
                    }
                    entry.multiplexer.sendServiceUpMessage(ch.getId(), addr, true);
                }
                catch (Exception e) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"failed sending SERVICE_UP message", (Throwable)e);
                    }
                }
                finally {
                    if (entry.channel.flushSupported()) {
                        entry.channel.stopFlush();
                    }
                }
            }
            ch.setClosed(false);
            ch.setConnected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MuxChannel ch, Address target, String state_id, long timeout) throws ChannelException {
        Entry entry;
        boolean stateTransferOk = false;
        Object object = this.channels;
        synchronized (object) {
            entry = this.channels.get(ch.getStackName());
        }
        if (entry != null) {
            object = entry;
            synchronized (object) {
                block19: {
                    if (entry.channel == null || entry.multiplexer == null) {
                        throw new ChannelException("channel has to be created before it can be connected");
                    }
                    entry.multiplexer.addServiceIfNotPresent(ch.getId(), ch);
                    if (!entry.channel.isConnected()) {
                        entry.channel.connect(ch.getStackName());
                        try {
                            entry.multiplexer.fetchServiceInformation();
                        }
                        catch (Exception e) {
                            if (!this.log.isErrorEnabled()) break block19;
                            this.log.error((Object)"failed fetching service state", (Throwable)e);
                        }
                    }
                }
                try {
                    boolean fetchState;
                    block20: {
                        boolean successfulFlush;
                        Address addr = entry.channel.getLocalAddress();
                        if (entry.channel.flushSupported() && !(successfulFlush = entry.channel.startFlush(3000L, false)) && this.log.isWarnEnabled()) {
                            this.log.warn((Object)("Flush failed at " + ch.getLocalAddress() + " " + ch.getId()));
                        }
                        try {
                            entry.multiplexer.sendServiceUpMessage(ch.getId(), addr, true);
                        }
                        catch (Exception e) {
                            if (!this.log.isWarnEnabled()) break block20;
                            this.log.warn((Object)("Failed sending SERVICE_UP message for " + ch));
                        }
                    }
                    View serviceView = entry.multiplexer.getServiceView(ch.getId());
                    boolean bl = fetchState = serviceView != null && serviceView.size() > 1;
                    if (fetchState && !(stateTransferOk = ch.getState(target, state_id, timeout, false))) {
                        throw new StateTransferException("Could not retrieve state " + state_id + " from " + target);
                    }
                }
                finally {
                    if (entry.channel.flushSupported()) {
                        entry.channel.stopFlush();
                    }
                }
            }
            ch.setClosed(false);
            ch.setConnected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MuxChannel ch) {
        Entry entry;
        Object object = this.channels;
        synchronized (object) {
            entry = this.channels.get(ch.getStackName());
        }
        if (entry != null) {
            object = entry;
            synchronized (object) {
                Multiplexer mux = entry.multiplexer;
                if (mux != null) {
                    Address addr = entry.channel.getLocalAddress();
                    try {
                        boolean successfulFlush;
                        if (entry.channel.flushSupported() && !(successfulFlush = entry.channel.startFlush(3000L, false)) && this.log.isWarnEnabled()) {
                            this.log.warn((Object)("Flush failed at " + ch.getLocalAddress() + ch.getId()));
                        }
                        mux.sendServiceDownMessage(ch.getId(), addr, true);
                    }
                    catch (Exception e) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)"failed sending SERVICE_DOWN message", (Throwable)e);
                        }
                    }
                    finally {
                        if (entry.channel.flushSupported()) {
                            entry.channel.stopFlush();
                        }
                    }
                    mux.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(MuxChannel ch) {
        Entry entry;
        String stack_name = ch.getStackName();
        boolean all_closed = false;
        Object object = this.channels;
        synchronized (object) {
            entry = this.channels.get(stack_name);
        }
        if (entry != null) {
            object = entry;
            synchronized (object) {
                Multiplexer mux = entry.multiplexer;
                if (mux != null) {
                    Address addr = entry.channel.getLocalAddress();
                    if (addr != null) {
                        try {
                            boolean successfulFlush;
                            if (entry.channel.flushSupported() && !(successfulFlush = entry.channel.startFlush(3000L, false)) && this.log.isWarnEnabled()) {
                                this.log.warn((Object)("Flush failed at " + ch.getLocalAddress() + ch.getId()));
                            }
                            mux.sendServiceDownMessage(ch.getId(), addr, true);
                        }
                        catch (Exception e) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"failed sending SERVICE_DOWN message", (Throwable)e);
                            }
                        }
                        finally {
                            if (entry.channel.flushSupported()) {
                                entry.channel.stopFlush();
                            }
                        }
                    }
                    all_closed = mux.close();
                }
            }
            if (all_closed) {
                this.channels.remove(stack_name);
            }
            if (this.expose_channels && this.server != null) {
                try {
                    this.unregister(this.domain + ":*,cluster=" + stack_name);
                }
                catch (Exception e) {
                    this.log.error((Object)("failed unregistering channel " + stack_name), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(MuxChannel ch) {
        String stack_name = ch.getStackName();
        boolean all_closed = false;
        Map<String, Entry> map = this.channels;
        synchronized (map) {
            Entry entry = this.channels.get(stack_name);
            if (entry != null) {
                Entry entry2 = entry;
                synchronized (entry2) {
                    Multiplexer mux = entry.multiplexer;
                    if (mux != null) {
                        Address addr = entry.channel.getLocalAddress();
                        try {
                            boolean successfulFlush;
                            if (entry.channel.flushSupported() && !(successfulFlush = entry.channel.startFlush(3000L, false)) && this.log.isWarnEnabled()) {
                                this.log.warn((Object)("Flush failed at " + ch.getLocalAddress() + ch.getId()));
                            }
                            mux.sendServiceDownMessage(ch.getId(), addr, true);
                        }
                        catch (Exception e) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"failed sending SERVICE_DOWN message", (Throwable)e);
                            }
                        }
                        finally {
                            if (entry.channel.flushSupported()) {
                                entry.channel.stopFlush();
                            }
                        }
                        all_closed = mux.shutdown();
                    }
                }
                if (all_closed) {
                    this.channels.remove(stack_name);
                }
                if (this.expose_channels && this.server != null) {
                    try {
                        this.unregister(this.domain + ":*,cluster=" + stack_name);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("failed unregistering channel " + stack_name), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(MuxChannel ch) throws ChannelException {
        Entry entry;
        Object object = this.channels;
        synchronized (object) {
            entry = this.channels.get(ch.getStackName());
        }
        if (entry != null) {
            object = entry;
            synchronized (object) {
                if (entry.channel == null) {
                    throw new ChannelException("channel has to be created before it can be opened");
                }
                if (!entry.channel.isOpen()) {
                    entry.channel.open();
                }
            }
            ch.setClosed(false);
            ch.setConnected(false);
        }
    }

    public void create() throws Exception {
        if (this.expose_channels) {
            this.server = Util.getMBeanServer();
            if (this.server == null) {
                throw new Exception("No MBeanServer found; JChannelFactory needs to be run with an MBeanServer present, e.g. inside JBoss or JDK 5, or with ExposeChannel set to false");
            }
            if (this.domain == null) {
                this.domain = "jgroups:name=Multiplexer";
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<String, Entry> map = this.channels;
        synchronized (map) {
            for (Map.Entry<String, Entry> tmp : this.channels.entrySet()) {
                Entry entry = tmp.getValue();
                if (entry.multiplexer != null) {
                    entry.multiplexer.closeAll();
                }
                if (entry.channel == null) continue;
                entry.channel.close();
            }
            if (this.expose_channels && this.server != null) {
                try {
                    this.unregister(this.domain + ":*");
                }
                catch (Throwable e) {
                    this.log.error((Object)("failed unregistering domain " + this.domain), e);
                }
            }
            this.channels.clear();
        }
    }

    public String dumpConfiguration() {
        if (this.stacks != null) {
            return this.stacks.keySet().toString();
        }
        return null;
    }

    public String dumpChannels() {
        if (this.channels == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Entry> entry : this.channels.entrySet()) {
            sb.append((Object)entry.getKey()).append(": ").append(entry.getValue().multiplexer.getServiceIds()).append("\n");
        }
        return sb.toString();
    }

    private void parse(InputStream input) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        Element configElement = document.getDocumentElement();
        this.parse(configElement);
    }

    private void parse(Element root) throws Exception {
        String root_name = root.getNodeName();
        if (!PROTOCOL_STACKS.equals(root_name.trim().toLowerCase())) {
            String error = "XML protocol stack configuration does not start with a '<config>' element; maybe the XML configuration needs to be converted to the new format ?\nuse 'java org.jgroups.conf.XmlConfigurator <old XML file> -new_format' to do so";
            throw new IOException("invalid XML configuration: " + error);
        }
        NodeList tmp_stacks = root.getChildNodes();
        for (int i = 0; i < tmp_stacks.getLength(); ++i) {
            Node node = tmp_stacks.item(i);
            if (node.getNodeType() != 1) continue;
            Element stack = (Element)node;
            String tmp = stack.getNodeName();
            if (!STACK.equals(tmp.trim().toLowerCase())) {
                throw new IOException("invalid configuration: didn't find a \"stack\" element under \"protocol_stacks\"");
            }
            NamedNodeMap attrs = stack.getAttributes();
            Node name = attrs.getNamedItem(NAME);
            String st_name = name.getNodeValue();
            NodeList configs = stack.getChildNodes();
            for (int j = 0; j < configs.getLength(); ++j) {
                Node tmp_config = configs.item(j);
                if (tmp_config.getNodeType() != 1) continue;
                Element cfg = (Element)tmp_config;
                tmp = cfg.getNodeName();
                if (!CONFIG.equals(tmp)) {
                    throw new IOException("invalid configuration: didn't find a \"config\" element under \"stack\"");
                }
                XmlConfigurator conf = XmlConfigurator.getInstance(cfg);
                ConfiguratorFactory.substituteVariables(conf);
                String val = conf.getProtocolStackString();
                this.stacks.put(st_name, val);
            }
        }
    }

    private String getConfig(String stack_name) throws Exception {
        String cfg = this.stacks.get(stack_name);
        if (cfg == null) {
            throw new Exception("stack \"" + stack_name + "\" not found in " + this.stacks.keySet());
        }
        return cfg;
    }

    private static class Entry {
        JChannel channel;
        Multiplexer multiplexer;

        private Entry() {
        }
    }
}

