/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.RspList;

public class RpcDispatcherTest
extends ChannelTestBase {
    RpcDispatcher disp1;
    RpcDispatcher disp2;
    RpcDispatcher disp3;
    Channel c1;
    Channel c2;
    Channel c3;

    protected void setUp() throws Exception {
        super.setUp();
        this.c1 = this.createChannel("A");
        this.disp1 = new RpcDispatcher(this.c1, null, null, new ServerObject(1));
        this.c1.connect("demo");
        this.c2 = this.createChannel("A");
        this.disp2 = new RpcDispatcher(this.c2, null, null, new ServerObject(2));
        this.c2.connect("demo");
        this.c3 = this.createChannel("A");
        this.disp3 = new RpcDispatcher(this.c3, null, null, new ServerObject(3));
        this.c3.connect("demo");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.disp3.stop();
        this.c3.close();
        this.disp2.stop();
        this.c2.close();
        this.disp1.stop();
        this.c1.close();
    }

    public void foo() {
    }

    public void testResponseFilter() {
        RspList rsps = this.disp1.callRemoteMethods(null, "foo", null, null, 2, 10000L, false, new RspFilter(){
            int num = 0;

            public boolean isAcceptable(Object response, Address sender) {
                boolean retval = (Integer)response > 1;
                System.out.println("-- received " + response + " from " + sender + ": " + (retval ? "OK" : "NOTOK"));
                if (retval) {
                    ++this.num;
                }
                return retval;
            }

            public boolean needMoreResponses() {
                return this.num < 2;
            }
        });
        System.out.println("responses are:\n" + rsps);
        RpcDispatcherTest.assertEquals((int)3, (int)rsps.size());
        RpcDispatcherTest.assertEquals((int)2, (int)rsps.numReceived());
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherTest.suite());
    }

    private static class ServerObject {
        int i;

        public ServerObject(int i) {
            this.i = i;
        }

        public int foo() {
            return this.i;
        }
    }
}

