/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDP
extends TP
implements Runnable {
    DatagramSocket sock = null;
    private static volatile BoundedList<Integer> last_ports_used = null;
    int num_last_ports = 100;
    MulticastSocket mcast_sock = null;
    MulticastSocket[] mcast_send_sockets = null;
    int tos = 8;
    IpAddress mcast_addr = null;
    String mcast_addr_name = "228.8.8.8";
    int mcast_port = 7600;
    Thread mcast_receiver = null;
    private static final String MCAST_RECEIVER_THREAD_NAME = "UDP mcast receiver";
    UcastReceiver ucast_receiver = null;
    boolean ip_mcast = true;
    int ip_ttl = 8;
    int mcast_send_buf_size = 32000;
    int mcast_recv_buf_size = 64000;
    int ucast_send_buf_size = 32000;
    int ucast_recv_buf_size = 64000;

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("num_last_ports");
        if (str != null) {
            this.num_last_ports = Integer.parseInt(str);
            props.remove("num_last_ports");
        }
        if ((str = Util.getProperty(new String[]{"jgroups.udp.mcast_addr", "jboss.partition.udpGroup"}, props, "mcast_addr", false, "228.8.8.8")) != null) {
            this.mcast_addr_name = str;
        }
        if ((str = Util.getProperty(new String[]{"jgroups.udp.mcast_port", "jboss.partition.udpPort"}, props, "mcast_port", false, "7600")) != null) {
            this.mcast_port = Integer.parseInt(str);
        }
        if ((str = props.getProperty("ip_mcast")) != null) {
            this.ip_mcast = Boolean.valueOf(str);
            props.remove("ip_mcast");
        }
        if ((str = Util.getProperty(new String[]{"jgroups.udp.ip_ttl"}, props, "ip_ttl", false, "64")) != null) {
            this.ip_ttl = Integer.parseInt(str);
            props.remove("ip_ttl");
        }
        if ((str = props.getProperty("tos")) != null) {
            this.tos = Integer.parseInt(str);
            props.remove("tos");
        }
        if ((str = props.getProperty("mcast_send_buf_size")) != null) {
            this.mcast_send_buf_size = Integer.parseInt(str);
            props.remove("mcast_send_buf_size");
        }
        if ((str = props.getProperty("mcast_recv_buf_size")) != null) {
            this.mcast_recv_buf_size = Integer.parseInt(str);
            props.remove("mcast_recv_buf_size");
        }
        if ((str = props.getProperty("ucast_send_buf_size")) != null) {
            this.ucast_send_buf_size = Integer.parseInt(str);
            props.remove("ucast_send_buf_size");
        }
        if ((str = props.getProperty("ucast_recv_buf_size")) != null) {
            this.ucast_recv_buf_size = Integer.parseInt(str);
            props.remove("ucast_recv_buf_size");
        }
        if ((str = props.getProperty("null_src_addresses")) != null) {
            props.remove("null_src_addresses");
            this.log.error((Object)"null_src_addresses has been deprecated, property will be ignored");
        }
        Util.checkBufferSize("UDP.mcast_send_buf_size", this.mcast_send_buf_size);
        Util.checkBufferSize("UDP.mcast_recv_buf_size", this.mcast_recv_buf_size);
        Util.checkBufferSize("UDP.ucast_send_buf_size", this.ucast_send_buf_size);
        Util.checkBufferSize("UDP.ucast_recv_buf_size", this.ucast_recv_buf_size);
        return props.isEmpty();
    }

    @Override
    public void run() {
        byte[] receive_buf = new byte[65535];
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        while (this.mcast_receiver != null && this.mcast_sock != null) {
            try {
                packet.setData(receive_buf, 0, receive_buf.length);
                this.mcast_sock.receive(packet);
                InetAddress sender_addr = packet.getAddress();
                int sender_port = packet.getPort();
                int offset = packet.getOffset();
                int len = packet.getLength();
                byte[] data = packet.getData();
                IpAddress sender = new IpAddress(sender_addr, sender_port);
                if (len > receive_buf.length && this.log.isErrorEnabled()) {
                    this.log.error((Object)("size of the received packet (" + len + ") is bigger than " + "allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length));
                }
                this.receive(this.mcast_addr, sender, data, offset, len);
            }
            catch (SocketException sock_ex) {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace((Object)("multicast socket is closed, exception=" + sock_ex));
                break;
            }
            catch (InterruptedIOException io_ex) {
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"failure in multicast receive()", ex);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"multicast thread terminated");
        }
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("group_addr=").append(this.mcast_addr_name).append(':').append(this.mcast_port).append("\n");
        return sb.toString();
    }

    @Override
    public void sendToAllMembers(byte[] data, int offset, int length) throws Exception {
        if (this.ip_mcast && this.mcast_addr != null) {
            this._send(this.mcast_addr.getIpAddress(), this.mcast_addr.getPort(), true, data, offset, length);
        } else {
            ArrayList mbrs = new ArrayList(this.members);
            for (Address mbr : mbrs) {
                this._send(((IpAddress)mbr).getIpAddress(), ((IpAddress)mbr).getPort(), false, data, offset, length);
            }
        }
    }

    @Override
    public void sendToSingleMember(Address dest, byte[] data, int offset, int length) throws Exception {
        this._send(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort(), false, data, offset, length);
    }

    @Override
    public void postUnmarshalling(Message msg, Address dest, Address src, boolean multicast) {
        msg.setDest(dest);
    }

    @Override
    public void postUnmarshallingList(Message msg, Address dest, boolean multicast) {
        msg.setDest(dest);
    }

    private void _send(InetAddress dest, int port, boolean mcast, byte[] data, int offset, int length) throws Exception {
        DatagramPacket packet = new DatagramPacket(data, offset, length, dest, port);
        try {
            if (mcast) {
                if (this.mcast_send_sockets != null) {
                    for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                        MulticastSocket s = this.mcast_send_sockets[i];
                        try {
                            s.send(packet);
                            continue;
                        }
                        catch (Exception e) {
                            this.log.error((Object)("failed sending packet on socket " + s));
                        }
                    }
                } else if (this.mcast_sock != null) {
                    this.mcast_sock.send(packet);
                }
            } else if (this.sock != null) {
                this.sock.send(packet);
            }
        }
        catch (Exception ex) {
            throw new Exception("dest=" + dest + ":" + port + " (" + length + " bytes)", ex);
        }
    }

    @Override
    public String getName() {
        return "UDP";
    }

    @Override
    public void start() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"creating sockets and starting threads");
        }
        try {
            this.createSockets();
        }
        catch (Exception ex) {
            String tmp = "problem creating sockets (bind_addr=" + this.bind_addr + ", mcast_addr=" + this.mcast_addr + ")";
            throw new Exception(tmp, ex);
        }
        super.start();
        this.startThreads();
    }

    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"closing sockets and stopping threads");
        }
        this.stopThreads();
        this.closeSockets();
        super.stop();
    }

    private void createSockets() throws Exception {
        block21: {
            if (this.bind_addr == null && !this.use_local_host) {
                this.bind_addr = Util.getFirstNonLoopbackAddress();
            }
            if (this.bind_addr == null) {
                this.bind_addr = InetAddress.getLocalHost();
            }
            if (this.bind_addr != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("sockets will use interface " + this.bind_addr.getHostAddress()));
            }
            this.sock = this.bind_port > 0 ? this.createDatagramSocketWithBindPort() : this.createEphemeralDatagramSocket();
            if (this.tos > 0) {
                try {
                    this.sock.setTrafficClass(this.tos);
                }
                catch (SocketException e) {
                    this.log.warn((Object)("traffic class of " + this.tos + " could not be set, will be ignored"));
                    if (!this.log.isDebugEnabled()) break block21;
                    this.log.debug((Object)"Cause of failure to set traffic class:", (Throwable)e);
                }
            }
        }
        if (this.sock == null) {
            throw new Exception("UDP.createSocket(): sock is null");
        }
        this.local_addr = new IpAddress(this.sock.getLocalAddress(), this.sock.getLocalPort());
        if (this.additional_data != null) {
            ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
        }
        if (this.ip_mcast) {
            List interfaces;
            this.mcast_sock = new MulticastSocket(this.mcast_port);
            this.mcast_sock.setTimeToLive(this.ip_ttl);
            InetAddress tmp_addr = InetAddress.getByName(this.mcast_addr_name);
            this.mcast_addr = new IpAddress(tmp_addr, this.mcast_port);
            if (this.tos > 0) {
                try {
                    this.mcast_sock.setTrafficClass(this.tos);
                }
                catch (SocketException e) {
                    this.log.warn((Object)("traffic class of " + this.tos + " could not be set, will be ignored"), (Throwable)e);
                }
            }
            if (this.receive_on_all_interfaces || this.receive_interfaces != null && !this.receive_interfaces.isEmpty()) {
                interfaces = this.receive_interfaces != null ? this.receive_interfaces : Util.getAllAvailableInterfaces();
                this.bindToInterfaces(interfaces, this.mcast_sock, this.mcast_addr.getIpAddress());
            } else {
                if (this.bind_addr != null) {
                    this.mcast_sock.setInterface(this.bind_addr);
                }
                this.mcast_sock.joinGroup(tmp_addr);
            }
            if (this.send_on_all_interfaces || this.send_interfaces != null && !this.send_interfaces.isEmpty()) {
                interfaces = this.send_interfaces != null ? this.send_interfaces : Util.getAllAvailableInterfaces();
                this.mcast_send_sockets = new MulticastSocket[interfaces.size()];
                int index = 0;
                for (NetworkInterface intf : interfaces) {
                    this.mcast_send_sockets[index] = new MulticastSocket();
                    this.mcast_send_sockets[index].setNetworkInterface(intf);
                    this.mcast_send_sockets[index].setTimeToLive(this.ip_ttl);
                    if (this.tos > 0) {
                        try {
                            this.mcast_send_sockets[index].setTrafficClass(this.tos);
                        }
                        catch (SocketException e) {
                            this.log.warn((Object)("traffic class of " + this.tos + " could not be set, will be ignored"), (Throwable)e);
                        }
                    }
                    ++index;
                }
            }
        }
        this.setBufferSizes();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("socket information:\n" + this.dumpSocketInfo()));
        }
    }

    private void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s, InetAddress mcastAddr) throws IOException {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(mcastAddr, this.mcast_port);
        for (NetworkInterface i : interfaces) {
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            if (!en2.hasMoreElements()) continue;
            InetAddress addr = en2.nextElement();
            s.joinGroup(tmp_mcast_addr, i);
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("joined " + tmp_mcast_addr + " on " + i.getName() + " (" + addr + ")"));
        }
    }

    protected DatagramSocket createEphemeralDatagramSocket() throws SocketException {
        DatagramSocket tmp;
        block7: {
            int localPort = 0;
            while (true) {
                try {
                    tmp = new DatagramSocket(localPort, this.bind_addr);
                }
                catch (SocketException socket_ex) {
                    ++localPort;
                    continue;
                }
                if (this.num_last_ports <= 0) break block7;
                localPort = tmp.getLocalPort();
                if (last_ports_used == null) {
                    last_ports_used = new BoundedList(this.num_last_ports);
                }
                if (!last_ports_used.contains(new Integer(localPort))) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("local port " + localPort + " already seen in this session; will try to get other port"));
                }
                try {
                    tmp.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++localPort;
            }
            last_ports_used.add(new Integer(localPort));
        }
        return tmp;
    }

    protected DatagramSocket createDatagramSocketWithBindPort() throws Exception {
        DatagramSocket tmp = null;
        int rcv_port = this.bind_port;
        int max_port = this.bind_port + this.port_range;
        while (rcv_port <= max_port) {
            try {
                tmp = new DatagramSocket(rcv_port, this.bind_addr);
                break;
            }
            catch (SocketException bind_ex) {
                ++rcv_port;
            }
            catch (SecurityException sec_ex) {
                ++rcv_port;
            }
            if (rcv_port < max_port + 1) continue;
            throw new Exception("cannot create a socket on any port in range " + this.bind_port + '-' + (this.bind_port + this.port_range));
        }
        return tmp;
    }

    private String dumpSocketInfo() throws Exception {
        StringBuilder sb = new StringBuilder(128);
        sb.append("local_addr=").append(this.local_addr);
        sb.append(", mcast_addr=").append(this.mcast_addr);
        sb.append(", bind_addr=").append(this.bind_addr);
        sb.append(", ttl=").append(this.ip_ttl);
        if (this.sock != null) {
            sb.append("\nsock: bound to ");
            sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
            sb.append(", receive buffer size=").append(this.sock.getReceiveBufferSize());
            sb.append(", send buffer size=").append(this.sock.getSendBufferSize());
        }
        if (this.mcast_sock != null) {
            sb.append("\nmcast_sock: bound to ");
            sb.append(this.mcast_sock.getInterface().getHostAddress()).append(':').append(this.mcast_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.mcast_sock.getSendBufferSize());
            sb.append(", receive buffer size=").append(this.mcast_sock.getReceiveBufferSize());
        }
        if (this.mcast_send_sockets != null) {
            sb.append("\n").append(this.mcast_send_sockets.length).append(" mcast send sockets:\n");
            for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                MulticastSocket s = this.mcast_send_sockets[i];
                sb.append(s.getInterface().getHostAddress()).append(':').append(s.getLocalPort());
                sb.append(", send buffer size=").append(s.getSendBufferSize());
                sb.append(", receive buffer size=").append(s.getReceiveBufferSize()).append("\n");
            }
        }
        return sb.toString();
    }

    void setBufferSizes() {
        if (this.sock != null) {
            this.setBufferSize(this.sock, this.ucast_send_buf_size, this.ucast_recv_buf_size);
        }
        if (this.mcast_sock != null) {
            this.setBufferSize(this.mcast_sock, this.mcast_send_buf_size, this.mcast_recv_buf_size);
        }
        if (this.mcast_send_sockets != null) {
            for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                this.setBufferSize(this.mcast_send_sockets[i], this.mcast_send_buf_size, this.mcast_recv_buf_size);
            }
        }
    }

    private void setBufferSize(DatagramSocket sock, int send_buf_size, int recv_buf_size) {
        block5: {
            block4: {
                try {
                    sock.setSendBufferSize(send_buf_size);
                }
                catch (Throwable ex) {
                    if (!this.log.isWarnEnabled()) break block4;
                    this.log.warn((Object)("failed setting send buffer size of " + send_buf_size + " in " + sock + ": " + ex));
                }
            }
            try {
                sock.setReceiveBufferSize(recv_buf_size);
            }
            catch (Throwable ex) {
                if (!this.log.isWarnEnabled()) break block5;
                this.log.warn((Object)("failed setting receive buffer size of " + recv_buf_size + " in " + sock + ": " + ex));
            }
        }
    }

    void closeSockets() {
        this.closeMulticastSocket();
        this.closeSocket();
    }

    void closeMulticastSocket() {
        if (this.mcast_sock != null) {
            try {
                if (this.mcast_addr != null) {
                    this.mcast_sock.leaveGroup(this.mcast_addr.getIpAddress());
                }
                this.mcast_sock.close();
                this.mcast_sock = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"multicast socket closed");
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.mcast_addr = null;
        }
        if (this.mcast_send_sockets != null) {
            for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                MulticastSocket s = this.mcast_send_sockets[i];
                s.close();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("multicast send socket " + s + " closed"));
            }
            this.mcast_send_sockets = null;
        }
    }

    private void closeSocket() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"socket closed");
            }
        }
    }

    void startThreads() throws Exception {
        if (this.ucast_receiver == null) {
            this.ucast_receiver = new UcastReceiver();
            this.ucast_receiver.start();
            if (this.thread_naming_pattern != null) {
                this.thread_naming_pattern.renameThread("UDP ucast receiver", this.ucast_receiver.getThread());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("created unicast receiver thread " + this.ucast_receiver.getThread()));
            }
        }
        if (this.ip_mcast) {
            if (this.mcast_receiver != null) {
                if (this.mcast_receiver.isAlive()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"did not create new multicastreceiver thread as existing multicast receiver thread is still running");
                    }
                } else {
                    this.mcast_receiver = null;
                }
            }
            if (this.mcast_receiver == null) {
                this.mcast_receiver = new Thread(Util.getGlobalThreadGroup(), this, MCAST_RECEIVER_THREAD_NAME);
                this.mcast_receiver.setPriority(10);
                if (this.thread_naming_pattern != null) {
                    this.thread_naming_pattern.renameThread(MCAST_RECEIVER_THREAD_NAME, this.mcast_receiver);
                }
                this.mcast_receiver.start();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("created multicast receiver thread " + this.mcast_receiver));
                }
            }
        }
    }

    void stopThreads() {
        if (this.mcast_receiver != null) {
            if (this.mcast_receiver.isAlive()) {
                Thread tmp = this.mcast_receiver;
                this.mcast_receiver = null;
                this.closeMulticastSocket();
                tmp.interrupt();
                try {
                    tmp.join(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Object var1_1 = null;
            }
            this.mcast_receiver = null;
        }
        if (this.ucast_receiver != null) {
            this.ucast_receiver.stop();
            this.ucast_receiver = null;
        }
    }

    @Override
    protected void setThreadNames() {
        super.setThreadNames();
        if (this.thread_naming_pattern != null) {
            this.thread_naming_pattern.renameThread(MCAST_RECEIVER_THREAD_NAME, this.mcast_receiver);
            if (this.ucast_receiver != null) {
                this.thread_naming_pattern.renameThread("UDP ucast receiver", this.ucast_receiver.getThread());
            }
        }
    }

    @Override
    protected void unsetThreadNames() {
        super.unsetThreadNames();
        if (this.mcast_receiver != null) {
            this.mcast_receiver.setName(MCAST_RECEIVER_THREAD_NAME);
        }
        if (this.ucast_receiver != null && this.ucast_receiver.getThread() != null) {
            this.ucast_receiver.getThread().setName("UDP ucast receiver");
        }
    }

    @Override
    protected void handleConfigEvent(Map<String, Object> map) {
        boolean set_buffers = false;
        super.handleConfigEvent(map);
        if (map == null) {
            return;
        }
        if (map.containsKey("send_buf_size")) {
            this.ucast_send_buf_size = this.mcast_send_buf_size = ((Integer)map.get("send_buf_size")).intValue();
            set_buffers = true;
        }
        if (map.containsKey("recv_buf_size")) {
            this.ucast_recv_buf_size = this.mcast_recv_buf_size = ((Integer)map.get("recv_buf_size")).intValue();
            set_buffers = true;
        }
        if (set_buffers) {
            this.setBufferSizes();
        }
    }

    public class UcastReceiver
    implements Runnable {
        public static final String UCAST_RECEIVER_THREAD_NAME = "UDP ucast receiver";
        boolean running = true;
        Thread thread = null;

        public Thread getThread() {
            return this.thread;
        }

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread(Util.getGlobalThreadGroup(), this, UCAST_RECEIVER_THREAD_NAME);
                this.running = true;
                this.thread.start();
            }
        }

        public void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.running = false;
                Thread tmp = this.thread;
                this.thread = null;
                UDP.this.closeSocket();
                tmp.interrupt();
                try {
                    tmp.join(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Object var1_1 = null;
            }
            this.thread = null;
        }

        public void run() {
            byte[] receive_buf = new byte[65535];
            DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
            while (this.running && this.thread != null && UDP.this.sock != null) {
                try {
                    packet.setData(receive_buf, 0, receive_buf.length);
                    UDP.this.sock.receive(packet);
                    InetAddress sender_addr = packet.getAddress();
                    int sender_port = packet.getPort();
                    int offset = packet.getOffset();
                    int len = packet.getLength();
                    byte[] data = packet.getData();
                    IpAddress sender = new IpAddress(sender_addr, sender_port);
                    if (len > receive_buf.length && UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error((Object)("size of the received packet (" + len + ") is bigger than allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length));
                    }
                    UDP.this.receive(UDP.this.local_addr, sender, data, offset, len);
                }
                catch (SocketException sock_ex) {
                    if (!UDP.this.log.isDebugEnabled()) break;
                    UDP.this.log.debug((Object)("unicast receiver socket is closed, exception=" + sock_ex));
                    break;
                }
                catch (InterruptedIOException io_ex) {
                }
                catch (Throwable ex) {
                    if (!UDP.this.log.isErrorEnabled()) continue;
                    UDP.this.log.error((Object)("[" + UDP.this.local_addr + "] failed receiving unicast packet"), ex);
                }
            }
            if (UDP.this.log.isDebugEnabled()) {
                UDP.this.log.debug((Object)"unicast receiver thread terminated");
            }
        }
    }
}

