/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class ConcurrentStartupTest
extends ChannelTestBase {
    private int mod = 1;

    public void setUp() throws Exception {
        super.setUp();
        this.mod = 1;
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    public boolean useBlocking() {
        return true;
    }

    public void testConcurrentStartupLargeState() {
        this.concurrentStartupHelper(true, false);
    }

    public void testConcurrentStartupSmallState() {
        this.concurrentStartupHelper(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concurrentStartupHelper(boolean largeState, boolean useDispatcher) {
        String[] names = null;
        names = ConcurrentStartupTest.isMuxChannelUsed() ? this.createMuxApplicationNames(1) : new String[]{"A", "B", "C", "D"};
        int count = names.length;
        ChannelTestBase.MemberRetrievable[] channels = new ConcurrentStartupChannel[count];
        try {
            Semaphore semaphore = new Semaphore(count);
            semaphore.acquire(count);
            for (int i = 0; i < count; ++i) {
                channels[i] = largeState ? (ConcurrentStartupTest.isMuxChannelUsed() ? new ConcurrentStartupChannelWithLargeState(names[i], this.muxFactory[i % this.getMuxFactoryCount()], semaphore) : new ConcurrentStartupChannelWithLargeState(semaphore, names[i], useDispatcher)) : (ConcurrentStartupTest.isMuxChannelUsed() ? new ConcurrentStartupChannel(names[i], this.muxFactory[i % this.getMuxFactoryCount()], semaphore) : new ConcurrentStartupChannel(names[i], semaphore, useDispatcher));
                ((ChannelTestBase.ChannelApplication)channels[i]).start();
                semaphore.release(1);
                ConcurrentStartupTest.sleepRandom(1500);
            }
            if (ConcurrentStartupTest.isMuxChannelUsed()) {
                ConcurrentStartupTest.blockUntilViewsReceived(channels, this.getMuxFactoryCount(), 60000L);
            } else {
                ConcurrentStartupTest.blockUntilViewsReceived(channels, 60000L);
            }
            Util.sleep(2000L);
            boolean acquired = semaphore.tryAcquire(count, 20L, TimeUnit.SECONDS);
            if (!acquired) {
                this.log.warn((Object)"Most likely a bug, analyse the stack below:");
                this.log.warn((Object)Util.dumpThreads());
            }
            Util.sleep(3000L);
            List[] lists = new List[count];
            for (int i = 0; i < count; ++i) {
                lists[i] = ((ConcurrentStartupChannel)channels[i]).getList();
            }
            Map[] mods = new Map[count];
            for (int i = 0; i < count; ++i) {
                mods[i] = ((ConcurrentStartupChannel)channels[i]).getModifications();
            }
            this.printLists(lists);
            this.printModifications(mods);
            int len = lists.length;
            for (int i = 0; i < lists.length; ++i) {
                List l = lists[i];
                ConcurrentStartupTest.assertEquals((String)("list #" + i + " should have " + len + " elements"), (int)len, (int)l.size());
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)"Exception encountered during test", (Throwable)ex);
        }
        finally {
            for (ChannelTestBase.MemberRetrievable channel : channels) {
                ((ChannelTestBase.ChannelApplication)channel).cleanup();
                Util.sleep(2000L);
            }
        }
    }

    public void testConcurrentLargeStateTransfer() {
        this.concurrentStateTranferHelper(true, false);
    }

    public void testConcurrentSmallStateTranfer() {
        this.concurrentStateTranferHelper(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concurrentStateTranferHelper(boolean largeState, boolean useDispatcher) {
        String[] names = null;
        names = ConcurrentStartupTest.isMuxChannelUsed() ? this.createMuxApplicationNames(1) : new String[]{"A", "B", "C", "D"};
        int count = names.length;
        ChannelTestBase.MemberRetrievable[] channels = new ConcurrentStateTransfer[count];
        Semaphore semaphore = new Semaphore(count);
        try {
            semaphore.acquire(count);
            for (int i = 0; i < count; ++i) {
                channels[i] = largeState ? (ConcurrentStartupTest.isMuxChannelUsed() ? new ConcurrentLargeStateTransfer(names[i], this.muxFactory[i % this.getMuxFactoryCount()], semaphore) : new ConcurrentLargeStateTransfer(names[i], semaphore, useDispatcher)) : (ConcurrentStartupTest.isMuxChannelUsed() ? new ConcurrentStateTransfer(names[i], this.muxFactory[i % this.getMuxFactoryCount()], semaphore) : new ConcurrentStateTransfer(names[i], semaphore, useDispatcher));
                ((ChannelTestBase.ChannelApplication)channels[i]).start();
                Util.sleep(2000L);
            }
            if (ConcurrentStartupTest.isMuxChannelUsed()) {
                ConcurrentStartupTest.blockUntilViewsReceived(channels, this.getMuxFactoryCount(), 60000L);
            } else {
                ConcurrentStartupTest.blockUntilViewsReceived(channels, 60000L);
            }
            Util.sleep(2000L);
            semaphore.release(count);
            Util.sleep(2000L);
            boolean acquired = semaphore.tryAcquire(count, 20L, TimeUnit.SECONDS);
            if (!acquired) {
                this.log.warn((Object)"Most likely a bug, analyse the stack below:");
                this.log.warn((Object)Util.dumpThreads());
            }
            Util.sleep(6000L);
            List[] lists = new List[count];
            for (int i = 0; i < count; ++i) {
                lists[i] = ((ConcurrentStartupChannel)channels[i]).getList();
            }
            Map[] mods = new Map[count];
            for (int i = 0; i < count; ++i) {
                mods[i] = ((ConcurrentStartupChannel)channels[i]).getModifications();
            }
            this.printLists(lists);
            this.printModifications(mods);
            int len = lists.length;
            for (int i = 0; i < lists.length; ++i) {
                List l = lists[i];
                ConcurrentStartupTest.assertEquals((String)("list #" + i + " should have " + len + " elements"), (int)len, (int)l.size());
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)"Exception encountered during test", (Throwable)ex);
        }
        finally {
            for (ChannelTestBase.MemberRetrievable channel : channels) {
                ((ChannelTestBase.ChannelApplication)channel).cleanup();
                Util.sleep(2000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMod() {
        ConcurrentStartupTest concurrentStartupTest = this;
        synchronized (concurrentStartupTest) {
            int retval = this.mod++;
            return retval;
        }
    }

    protected void printModifications(Map[] modifications) {
        for (int i = 0; i < modifications.length; ++i) {
            Map modification = modifications[i];
            this.log.info((Object)("modifications for #" + i + ": " + modification));
        }
    }

    protected void printLists(List[] lists) {
        for (int i = 0; i < lists.length; ++i) {
            List l = lists[i];
            this.log.info((Object)(i + ": " + l));
        }
    }

    public static Test suite() {
        return new TestSuite(ConcurrentStartupTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConcurrentStartupTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    protected class ConcurrentStartupChannel
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        final List l;
        Channel ch;
        int modCount;
        final Map mods;

        public ConcurrentStartupChannel(String name, JChannelFactory f, Semaphore semaphore) throws Exception {
            super(name, f, semaphore);
            this.l = new LinkedList();
            this.modCount = 1;
            this.mods = new TreeMap();
        }

        public ConcurrentStartupChannel(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
            this.l = new LinkedList();
            this.modCount = 1;
            this.mods = new TreeMap();
        }

        public void useChannel() throws Exception {
            this.channel.connect("test", null, null, 25000L);
            this.channel.send(null, null, this.channel.getLocalAddress());
        }

        List getList() {
            return this.l;
        }

        Map getModifications() {
            return this.mods;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message msg) {
            if (msg.getBuffer() == null) {
                return;
            }
            Object obj = msg.getObject();
            ConcurrentStartupTest.this.log.info((Object)("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: received " + obj));
            ConcurrentStartupChannel concurrentStartupChannel = this;
            synchronized (concurrentStartupChannel) {
                this.l.add(obj);
                Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                this.mods.put(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View new_view) {
            super.viewAccepted(new_view);
            ConcurrentStartupChannel concurrentStartupChannel = this;
            synchronized (concurrentStartupChannel) {
                Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                this.mods.put(key, new_view.getVid());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] state) {
            super.setState(state);
            try {
                List tmp = (List)Util.objectFromByteBuffer(state);
                ConcurrentStartupChannel concurrentStartupChannel = this;
                synchronized (concurrentStartupChannel) {
                    this.l.clear();
                    this.l.addAll(tmp);
                    ConcurrentStartupTest.this.log.info((Object)("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: state is " + this.l));
                    Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                    this.mods.put(key, tmp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState() {
            super.getState();
            LinkedList tmp = null;
            ConcurrentStartupChannel concurrentStartupChannel = this;
            synchronized (concurrentStartupChannel) {
                tmp = new LinkedList(this.l);
                try {
                    return Util.objectToByteBuffer(tmp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(OutputStream ostream) {
            super.getState(ostream);
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                LinkedList tmp = null;
                ConcurrentStartupChannel concurrentStartupChannel = this;
                synchronized (concurrentStartupChannel) {
                    tmp = new LinkedList(this.l);
                }
                oos.writeObject(tmp);
                oos.flush();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Util.close(oos);
                    throw throwable;
                }
                Util.close(oos);
            }
            Util.close(oos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(InputStream istream) {
            super.setState(istream);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(istream);
                List tmp = (List)ois.readObject();
                ConcurrentStartupChannel concurrentStartupChannel = this;
                synchronized (concurrentStartupChannel) {
                    this.l.clear();
                    this.l.addAll(tmp);
                    ConcurrentStartupTest.this.log.info((Object)("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: state is " + this.l));
                    Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                    this.mods.put(key, tmp);
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Util.close(ois);
                    throw throwable;
                }
                Util.close(ois);
            }
            Util.close(ois);
        }
    }

    protected class ConcurrentStartupChannelWithLargeState
    extends ConcurrentStartupChannel {
        public ConcurrentStartupChannelWithLargeState(Semaphore semaphore, String name, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
        }

        public ConcurrentStartupChannelWithLargeState(String name, JChannelFactory f, Semaphore semaphore) throws Exception {
            super(name, f, semaphore);
        }

        public void setState(byte[] state) {
            Util.sleep(5000L);
            super.setState(state);
        }

        public byte[] getState() {
            Util.sleep(5000L);
            return super.getState();
        }

        public void getState(OutputStream ostream) {
            Util.sleep(5000L);
            super.getState(ostream);
        }

        public void setState(InputStream istream) {
            Util.sleep(5000L);
            super.setState(istream);
        }
    }

    protected class ConcurrentLargeStateTransfer
    extends ConcurrentStateTransfer {
        public ConcurrentLargeStateTransfer(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
        }

        public ConcurrentLargeStateTransfer(String name, JChannelFactory factory, Semaphore semaphore) throws Exception {
            super(name, factory, semaphore);
        }

        public void setState(byte[] state) {
            Util.sleep(5000L);
            super.setState(state);
        }

        public byte[] getState() {
            Util.sleep(5000L);
            return super.getState();
        }

        public void getState(OutputStream ostream) {
            Util.sleep(5000L);
            super.getState(ostream);
        }

        public void setState(InputStream istream) {
            Util.sleep(5000L);
            super.setState(istream);
        }
    }

    protected class ConcurrentStateTransfer
    extends ConcurrentStartupChannel {
        public ConcurrentStateTransfer(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
            this.channel.connect("test");
        }

        public ConcurrentStateTransfer(String name, JChannelFactory factory, Semaphore semaphore) throws Exception {
            super(name, factory, semaphore);
            this.channel.connect("test");
        }

        public void useChannel() throws Exception {
            boolean success = this.channel.getState(null, 30000L);
            ConcurrentStartupTest.this.log.info((Object)("channel.getState at " + this.getName() + this.getLocalAddress() + " returned " + success));
            this.channel.send(null, null, this.channel.getLocalAddress());
        }
    }
}

