/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Test class for PojoCache.
 *
 * @version $Revision: 4456 $
 */
@org.jboss.cache.pojo.annotation.Replicable
public class SpecialSerializedAddress implements Serializable
{
   private static final long serialVersionUID = 1L;
   String street = null;
   String city = null;
   int zip = 0;

   List<String> residents = new ArrayList<String>();

   public List<String> getResidents()
   {
      return residents;
   }

   public void setResidents(List<String> residents)
   {
      this.residents = residents;
   }

   public void addResidents(String name)
   {
      residents.add(name);
   }

   public String getStreet()
   {
      return street;
   }

   public void setStreet(String street)
   {
      this.street = street;
   }

   public String getCity()
   {
      return city;
   }

   public void setCity(String city)
   {
      this.city = city;
   }

   public int getZip()
   {
      return zip;
   }

   public void setZip(int zip)
   {
      this.zip = zip;
   }

   public String toString()
   {
      return "street=" + getStreet() + ", city=" + getCity() + ", zip=" + getZip();
   }

//    public Object writeReplace() {
//	return this;
//    }
}
