/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.collection.CollectionInterceptorUtil;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoReference;
import org.jboss.cache.pojo.interceptors.dynamic.BaseInterceptor;
import org.jboss.cache.pojo.util.AopUtil;

class ObjectGraphHandler {
    private PojoCacheImpl cache;
    private InternalHelper internal_;
    private static final Log log = LogFactory.getLog(ObjectGraphHandler.class);

    public ObjectGraphHandler(PojoCacheImpl cache, InternalHelper internal) {
        this.cache = cache;
        this.internal_ = internal;
    }

    Object get(Fqn fqn, Class clazz, PojoInstance pojoInstance) throws CacheException {
        Object obj = this.cache.getObject(fqn);
        if (obj == null) {
            throw new PojoCacheException("ObjectGraphHandler.get(): null object from internal ref node. Internal ref node: " + fqn);
        }
        return obj;
    }

    void put(Fqn fqn, Object obj, String field) throws CacheException {
        CachedType type = this.cache.getCachedType(obj.getClass());
        InstanceAdvisor advisor = null;
        Interceptor interceptor = null;
        if (obj instanceof Advised) {
            advisor = ((Advised)obj)._getInstanceAdvisor();
            if (advisor == null) {
                throw new PojoCacheException("put(): InstanceAdvisor is null for: " + obj);
            }
            interceptor = AopUtil.findCacheInterceptor(advisor);
        } else {
            advisor = ((ClassProxy)obj)._getInstanceAdvisor();
            if (advisor == null) {
                throw new PojoCacheException("put(): InstanceAdvisor is null for: " + obj);
            }
            interceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)obj);
        }
        Fqn originalFqn = null;
        originalFqn = ((BaseInterceptor)interceptor).getFqn();
        this.setupRefCounting(fqn, originalFqn);
        PojoReference pojoReference = new PojoReference();
        pojoReference.setFqn(originalFqn);
        pojoReference.setPojoClass(type.getType());
        this.internal_.putPojoReference(fqn, pojoReference, field);
    }

    boolean isMultipleReferenced(Fqn internalFqn) {
        PojoInstance pojoInstance = null;
        try {
            pojoInstance = this.internal_.getPojoInstance(internalFqn);
        }
        catch (CacheException e) {
            throw new PojoCacheException("Exception in isMultipleReferenced", e);
        }
        return InternalHelper.isMultipleReferenced(pojoInstance);
    }

    void remove(Fqn referencingFqn, Fqn internalFqn, Object pojo) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove(): removing object fqn: " + referencingFqn + " Will just de-reference it."));
        }
        this.removeFromReference(referencingFqn, internalFqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromReference(Fqn referencingFqn, Fqn originalFqn) throws CacheException {
        Fqn fqn = referencingFqn;
        synchronized (fqn) {
            if (this.decrementRefCount(referencingFqn, originalFqn) == -1) {
                this.cache.detach(referencingFqn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupRefCounting(Fqn fqn, Fqn refFqn) throws CacheException {
        Fqn fqn2 = refFqn;
        synchronized (fqn2) {
            this.incrementRefCount(refFqn, fqn);
            if (log.isTraceEnabled()) {
                log.trace((Object)("setupRefCounting(): current fqn: " + fqn + " set to point to: " + refFqn));
            }
        }
    }

    private int incrementRefCount(Fqn originalFqn, Fqn referencingFqn) throws CacheException {
        return this.internal_.incrementRefCount(originalFqn, referencingFqn);
    }

    private int decrementRefCount(Fqn referencingFqn, Fqn originalFqn) throws CacheException {
        int count = 0;
        count = this.internal_.decrementRefCount(originalFqn, referencingFqn);
        if (count == 0) {
            this.internal_.removeIndirectFqn(originalFqn.toString());
        }
        return count;
    }
}

