/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.HashMap;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jgroups.util.Util;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FqnTest {
    private Cache<Object, Object> cache;

    @BeforeTest
    protected void setUp() {
        this.cache = null;
    }

    @AfterTest
    protected void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
    }

    @Test(groups={"functional"})
    public void testNull() {
        Fqn fqn = new Fqn();
        this.log("null fqn is " + fqn);
        assert (0 == fqn.size());
        int hcode = fqn.hashCode();
        assert (hcode != -1);
    }

    @Test(groups={"functional"})
    public void testOne() {
        Fqn fqn = new Fqn((Object[])new Integer[]{22});
        this.log("one fqn is " + fqn);
        assert (1 == fqn.size());
        int hcode = fqn.hashCode();
        assert (hcode != -1);
    }

    @Test(groups={"functional"})
    public void testEmptyFqn() {
        Fqn f1 = new Fqn();
        Fqn f2 = new Fqn();
        assert (f1.equals((Object)f2));
    }

    @Test(groups={"functional"})
    public void testFqn() {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        this.log("fqn is " + fqn);
        assert (3 == fqn.size());
        Fqn fqn2 = new Fqn((Object[])new String[]{"a", "b", "c"});
        this.log("fqn2 is " + fqn2);
        assert (3 == fqn.size());
        assert (fqn.equals((Object)fqn2));
        assert (fqn.hashCode() == fqn2.hashCode());
    }

    @Test(groups={"functional"})
    public void testHereogeneousNames() {
        Fqn fqn = new Fqn(new Object[]{"string", 38, true});
        this.log("fqn is " + fqn);
        assert (3 == fqn.size());
        Fqn fqn2 = new Fqn(new Object[]{"string", 38, true});
        assert (fqn.equals((Object)fqn2));
        assert (fqn.hashCode() == fqn2.hashCode());
    }

    @Test(groups={"functional"})
    public void testHashcode() {
        Fqn fqn1 = new Fqn(new Object[]{"a", "b", "c"});
        Fqn fqn2 = Fqn.fromString((String)"/a/b/c");
        this.log("fqn is " + fqn1);
        assert (fqn1.equals((Object)fqn2));
        HashMap<Fqn, Integer> map = new HashMap<Fqn, Integer>();
        map.put(fqn1, 33);
        map.put(fqn2, 34);
        assert (map.size() == 1);
        assert (((Integer)map.get(fqn1)).equals(34));
    }

    @Test(groups={"functional"})
    public void testHashcode2() {
        Fqn fqn = new Fqn((Object[])new Integer[]{-1});
        this.log("one fqn is " + fqn);
        assert (fqn.size() == 1);
        int hcode = fqn.hashCode();
        assert (hcode == -1);
    }

    @Test(groups={"functional"})
    public void testEquals() {
        Fqn fqn1 = new Fqn((Object[])new String[]{"person/test"});
        Fqn f1 = new Fqn(fqn1, (Object[])new String[]{"0"});
        Fqn f2 = new Fqn(fqn1, (Object[])new String[]{"1"});
        Fqn f3 = new Fqn(fqn1, (Object[])new String[]{"2"});
        HashMap<Fqn, String> map = new HashMap<Fqn, String>();
        map.put(f1, "0");
        map.put(f2, "1");
        map.put(f3, "2");
        assert (map.get(new Fqn(fqn1, (Object[])new String[]{"0"})) != null);
        assert (map.get(new Fqn(fqn1, (Object[])new String[]{"1"})) != null);
        assert (map.get(new Fqn(fqn1, (Object[])new String[]{"2"})) != null);
    }

    @Test(groups={"functional"})
    public void testEquals2() {
        Fqn f1 = Fqn.fromString((String)"/a/b/c");
        Fqn f2 = Fqn.fromString((String)"/a/b/c");
        assert (f1.equals((Object)f2));
        f2 = Fqn.fromString((String)"/a/b");
        assert (!f1.equals((Object)f2));
        f2 = Fqn.fromString((String)"/a/b/c/d");
        assert (!f1.equals((Object)f2));
    }

    @Test(groups={"functional"})
    public void testEquals2WithMarshalling() throws Exception {
        Fqn f1 = Fqn.fromString((String)"/a/b/c");
        Fqn f2 = this.marshalAndUnmarshal(f1);
        assert (f1.equals(f2));
    }

    @Test(groups={"functional"})
    public void testEquals3() {
        Fqn f1 = new Fqn(new Object[]{"a", 322649, Boolean.TRUE});
        Fqn f2 = new Fqn();
        assert (!f1.equals((Object)f2));
        assert (!f2.equals((Object)f1));
        f2 = Fqn.fromString((String)"a/322649/TRUE");
        assert (!f1.equals((Object)f2));
        f2 = new Fqn(new Object[]{"a", 322649, Boolean.FALSE});
        assert (!f1.equals((Object)f2));
        f2 = new Fqn(new Object[]{"a", 322649, Boolean.TRUE});
        assert (f1.equals((Object)f2));
    }

    @Test(groups={"functional"})
    public void testEquals3WithMarshalling() throws Exception {
        Fqn f1 = new Fqn(new Object[]{"a", 322649, Boolean.TRUE});
        Fqn f2 = this.marshalAndUnmarshal(f1);
        assert (f1.equals(f2));
        assert (f2.equals((Object)f1));
        Fqn f3 = Fqn.fromString((String)"a/322649/TRUE");
        f3 = this.marshalAndUnmarshal(f3);
        assert (!f1.equals(f3));
        f2 = new Fqn(new Object[]{"a", 322649, Boolean.FALSE});
        f2 = this.marshalAndUnmarshal(f2);
        assert (!f1.equals(f2));
        f2 = new Fqn(new Object[]{"a", 322649, Boolean.TRUE});
        f2 = this.marshalAndUnmarshal(f2);
        assert (f1.equals(f2));
    }

    @Test(groups={"functional"})
    public void testEquals4() {
        Fqn fqn = Fqn.fromString((String)"X");
        assert (!fqn.equals((Object)"X"));
        assert (!fqn.equals(null));
    }

    @Test(groups={"functional"})
    public void testClone() throws CloneNotSupportedException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = fqn1.clone();
        assert (fqn1.equals((Object)fqn2));
        assert (fqn1.hashCode() == fqn2.hashCode());
    }

    @Test(groups={"functional"})
    public void testNullElements() throws CloneNotSupportedException {
        Fqn fqn0 = new Fqn(new Object[]{null});
        assert (1 == fqn0.size());
        Fqn fqn1 = new Fqn(new Object[]{"NULL", null, 0});
        assert (3 == fqn1.size());
        Fqn fqn2 = new Fqn(new Object[]{"NULL", null, 0});
        assert (fqn1.hashCode() == fqn2.hashCode());
        assert (fqn1.equals((Object)fqn2));
        assert (fqn1.equals((Object)fqn1.clone()));
    }

    @Test(groups={"functional"})
    public void testIteration() {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        assert (3 == fqn.size());
        Fqn tmp_fqn = new Fqn();
        assert (0 == tmp_fqn.size());
        for (int i = 0; i < fqn.size(); ++i) {
            String s = (String)fqn.get(i);
            tmp_fqn = new Fqn(tmp_fqn, new Object[]{s});
            assert (tmp_fqn.size() == i + 1);
        }
        assert (3 == tmp_fqn.size());
        assert (fqn.equals((Object)tmp_fqn));
    }

    @Test(groups={"functional"})
    public void testIsChildOf() {
        Fqn child = Fqn.fromString((String)"/a/b");
        Fqn parent = Fqn.fromString((String)"/a");
        assert (child.isChildOf(parent));
        assert (!parent.isChildOf(child));
        assert (child.isChildOrEquals(child));
        parent = Fqn.fromString((String)"/a/b/c");
        child = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/e/r/e/r/t/tt/");
        assert (child.isChildOf(parent));
    }

    @Test(groups={"functional"})
    public void testIsChildOf2() {
        Fqn child = Fqn.fromString((String)"/a/b/c/d");
        assert ("/b/c/d".equals(child.getSubFqn(1, child.size()).toString()));
    }

    @Test(groups={"functional"})
    public void testParentage() {
        Fqn fqnRoot = new Fqn();
        Fqn parent = fqnRoot.getParent();
        assert (parent.equals((Object)fqnRoot));
        Fqn fqnOne = Fqn.fromString((String)"/one");
        parent = fqnOne.getParent();
        assert (parent.equals((Object)fqnRoot));
        assert (fqnOne.isChildOf(parent));
        Fqn fqnTwo = Fqn.fromString((String)"/one/two");
        parent = fqnTwo.getParent();
        assert (parent.equals((Object)fqnOne));
        assert (fqnTwo.isChildOf(parent));
        Fqn fqnThree = Fqn.fromString((String)"/one/two/three");
        parent = fqnThree.getParent();
        assert (parent.equals((Object)fqnTwo));
        assert (fqnThree.isChildOf(parent));
    }

    @Test(groups={"functional"})
    public void testRoot() {
        Fqn fqn = new Fqn();
        assert (fqn.isRoot());
        fqn = Fqn.fromString((String)"/one/two");
        assert (!fqn.isRoot());
    }

    @Test(groups={"functional"})
    public void testGetName() {
        Fqn integerFqn = new Fqn((Object[])new Integer[]{1});
        assert ("1".equals(integerFqn.getLastElementAsString()));
        Object object = new Object();
        Fqn objectFqn = new Fqn(new Object[]{object});
        assert (object.toString().equals(objectFqn.getLastElementAsString()));
    }

    @Test(groups={"functional"})
    public void testCloningString() throws CloneNotSupportedException {
        Fqn f = Fqn.fromString((String)"/a/b/c");
        assert (f.equals((Object)f.clone()));
    }

    @Test(groups={"functional"})
    public void testCloningOtherTypes() throws CloneNotSupportedException {
        Fqn f = new Fqn(new Object[]{"blah", 10, Boolean.TRUE});
        assert (f.equals((Object)f.clone()));
    }

    @Test(groups={"functional"})
    public void testRemovalNonString() throws Exception {
        Fqn f = new Fqn(new Object[]{"test", 1});
        Configuration c = new Configuration();
        c.setCacheMode("LOCAL");
        this.cache = DefaultCacheFactory.getInstance().createCache(c);
        this.cache.put(f, (Object)"key", (Object)"value");
        assert ("value".equals(this.cache.get(f, (Object)"key")));
        assert (this.cache.getRoot().hasChild(f));
        this.cache.removeNode(f);
        assert (this.cache.get(f, (Object)"key") == null);
        assert (!this.cache.getRoot().hasChild(f));
    }

    <T> Fqn<T> marshalAndUnmarshal(Fqn<T> fqn) throws Exception {
        byte[] buf = Util.objectToByteBuffer(fqn);
        return (Fqn)Util.objectFromByteBuffer((byte[])buf);
    }

    @Test(groups={"functional"})
    public void testGenerics() {
        Fqn f = Fqn.fromString((String)"/blah/blah");
        Fqn f2 = Fqn.fromString((String)"/blah/blah");
        assert (f.equals((Object)f2));
        Fqn f3 = new Fqn((Object[])new Integer[]{1, 2, 3, 5});
        Fqn f4 = new Fqn((Object[])new Integer[]{1, 2, 3});
        assert (f3.getParent().equals((Object)f4));
    }

    @Test(groups={"functional"})
    public void testGenerations() {
        Fqn f = new Fqn((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});
        assert (f.equals((Object)f.getAncestor(f.size())));
        assert (f.getParent().equals((Object)f.getAncestor(f.size() - 1)));
        assert (Fqn.ROOT.equals((Object)f.getAncestor(0)));
        assert (new Fqn((Object[])new Integer[]{1}).equals((Object)f.getAncestor(1)));
        assert (new Fqn((Object[])new Integer[]{1, 2}).equals((Object)f.getAncestor(2)));
        assert (new Fqn((Object[])new Integer[]{1, 2, 3}).equals((Object)f.getAncestor(3)));
        assert (new Fqn((Object[])new Integer[]{1, 2, 3, 4}).equals((Object)f.getAncestor(4)));
        assert (new Fqn((Object[])new Integer[]{1, 2, 3, 4, 5}).equals((Object)f.getAncestor(5)));
        try {
            f.getAncestor(-1);
            assert (false);
        }
        catch (IllegalArgumentException good) {
            // empty catch block
        }
        try {
            f.getAncestor(f.size() + 1);
            assert (false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }
}

