/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.misc.TestingUtil;
import org.jgroups.Address;
import org.testng.AssertJUnit;

public class BuddyAssignmentStateTransferTest
extends BuddyReplicationTestsBase {
    protected int timeout = 10000;

    protected int getSleepTimeout() {
        return this.timeout;
    }

    public void testNonRegionBasedStateTransfer() throws Exception {
        this.caches = new ArrayList();
        this.caches.add(this.createCache(1, "TEST", false, true));
        Fqn main = Fqn.fromString((String)"/a/b/c");
        ((CacheImpl)this.caches.get(0)).put(main, (Object)"name", (Object)"Joe");
        this.caches.add(this.createCache(1, "TEST", false, true));
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheImpl[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        Fqn test = new Fqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(0)).getLocalAddress())});
        test = new Fqn(test, main);
        AssertJUnit.assertEquals((String)"State transferred", (Object)"Joe", (Object)((CacheImpl)this.caches.get(1)).get(test, (Object)"name"));
        this.caches.add(this.createCache(1, "TEST", false, true));
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheImpl[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        AssertJUnit.assertNull((String)"State not transferred", (Object)((CacheImpl)this.caches.get(2)).get(test, (Object)"name"));
        ((CacheImpl)this.caches.get(1)).stop();
        this.caches.set(1, null);
        TestingUtil.sleepThread(this.getSleepTimeout());
        AssertJUnit.assertEquals((String)"State transferred", (Object)"Joe", (Object)((CacheImpl)this.caches.get(2)).get(test, (Object)"name"));
    }

    public void testPersistentStateTransfer() throws Exception {
        this.caches = new ArrayList();
        this.caches.add(this.createCacheWithCacheLoader(false, false, false, true, false));
        ((CacheImpl)this.caches.get(0)).getConfiguration().setFetchInMemoryState(false);
        ((CacheImpl)this.caches.get(0)).start();
        Fqn main = Fqn.fromString((String)"/a/b/c");
        ((CacheImpl)this.caches.get(0)).put(main, (Object)"name", (Object)"Joe");
        this.caches.add(this.createCacheWithCacheLoader(false, false, false, true, false));
        ((CacheImpl)this.caches.get(1)).getConfiguration().setFetchInMemoryState(false);
        ((CacheImpl)this.caches.get(1)).start();
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheImpl[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        Fqn test = BuddyManager.getBackupFqn((Address)((CacheImpl)this.caches.get(0)).getLocalAddress(), (Fqn)main);
        AssertJUnit.assertFalse((String)"/a/b/c shld not be bin memory", (boolean)((CacheImpl)this.caches.get(1)).exists(test));
        AssertJUnit.assertNotNull((String)"/a/b/c shld be in CL", (Object)((CacheImpl)this.caches.get(1)).getCacheLoader().get(test));
        AssertJUnit.assertEquals((String)"/a/b/c shld in cache loader", (Object)"Joe", (Object)((CacheImpl)this.caches.get(1)).get(test, (Object)"name"));
    }
}

