/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocatorConfig;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional", "jgroups"})
public class BuddyManagerTest {
    public void testConstruction1() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled>\n          <buddyLocatorProperties>numBuddies = 3</buddyLocatorProperties>\n          <buddyPoolName>groupOne</buddyPoolName></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        BuddyManager mgr = new BuddyManager(config);
        AssertJUnit.assertTrue((boolean)mgr.isEnabled());
        AssertJUnit.assertEquals((String)"groupOne", (String)mgr.getBuddyPoolName());
        AssertJUnit.assertEquals(NextMemberBuddyLocator.class, mgr.buddyLocator.getClass());
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)mgr.buddyLocator.getConfig();
        AssertJUnit.assertEquals((int)3, (int)blc.getNumBuddies());
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
    }

    public void testConstruction2() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled>\n          <buddyLocatorClass>org.i.dont.exist.PhantomBuddyLocator</buddyLocatorClass>\n          <buddyLocatorProperties>numBuddies = 3</buddyLocatorProperties>\n          <buddyPoolName>groupOne</buddyPoolName></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        BuddyManager mgr = new BuddyManager(config);
        AssertJUnit.assertTrue((boolean)mgr.isEnabled());
        AssertJUnit.assertEquals((String)"groupOne", (String)mgr.getBuddyPoolName());
        AssertJUnit.assertEquals(NextMemberBuddyLocator.class, mgr.buddyLocator.getClass());
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)mgr.buddyLocator.getConfig();
        AssertJUnit.assertEquals((int)1, (int)blc.getNumBuddies());
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
    }

    public void testConstruction3() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>false</buddyReplicationEnabled></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        BuddyManager mgr = new BuddyManager(config);
        AssertJUnit.assertTrue((!mgr.isEnabled() ? 1 : 0) != 0);
    }

    public void testConstruction4() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        BuddyManager mgr = new BuddyManager(config);
        AssertJUnit.assertTrue((boolean)mgr.isEnabled());
        AssertJUnit.assertNull((Object)mgr.getBuddyPoolName());
        AssertJUnit.assertEquals(NextMemberBuddyLocator.class, mgr.buddyLocator.getClass());
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)mgr.buddyLocator.getConfig();
        AssertJUnit.assertEquals((int)1, (int)blc.getNumBuddies());
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
    }

    private BuddyManager createBasicBuddyManager() {
        BuddyManager bm = null;
        try {
            Element element = XmlHelper.stringToElement((String)"<config><buddyReplicationEnabled>true</buddyReplicationEnabled></config>");
            BuddyReplicationConfig cfg = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
            bm = new BuddyManager(cfg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bm;
    }

    public void testFqnManipulation() {
        Fqn fqn1 = Fqn.fromString((String)"/hello/world");
        MethodCall call1 = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{fqn1, "key", "value"});
        MethodCall call2 = MethodCallFactory.create((Method)MethodDeclarations.replicateMethod, (Object[])new Object[]{call1});
        BuddyManager bm = this.createBasicBuddyManager();
        MethodCall newReplicatedCall = bm.transformFqns(call2);
        MethodCall newPutCall = (MethodCall)newReplicatedCall.getArgs()[0];
        String expected = "/_BUDDY_BACKUP_/" + null + "/hello/world";
        AssertJUnit.assertEquals((String)expected, (String)newPutCall.getArgs()[0].toString());
    }

    public void testRootFqnManipulation() {
        Fqn fqn1 = Fqn.ROOT;
        MethodCall call1 = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{fqn1, "key", "value"});
        MethodCall call2 = MethodCallFactory.create((Method)MethodDeclarations.replicateMethod, (Object[])new Object[]{call1});
        BuddyManager bm = this.createBasicBuddyManager();
        MethodCall newReplicatedCall = bm.transformFqns(call2);
        MethodCall newPutCall = (MethodCall)newReplicatedCall.getArgs()[0];
        String expected = "/_BUDDY_BACKUP_/" + null;
        AssertJUnit.assertEquals((String)expected, (String)newPutCall.getArgs()[0].toString());
    }

    public void testMultiFqnManipulation() {
        Fqn fqn1 = Fqn.ROOT;
        Fqn fqn2 = Fqn.fromString((String)"/hello/world");
        Fqn fqn3 = Fqn.fromString((String)"/hello/again");
        Fqn fqn4 = Fqn.fromString((String)"/buddy/replication");
        MethodCall call1 = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{fqn1, "key", "value"});
        MethodCall call2 = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{fqn2, "key", "value"});
        MethodCall call3 = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{fqn3, "key", "value"});
        MethodCall call4 = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{fqn4, "key", "value"});
        ArrayList<MethodCall> list = new ArrayList<MethodCall>();
        list.add(call1);
        list.add(call2);
        list.add(call3);
        list.add(call4);
        MethodCall call5 = MethodCallFactory.create((Method)MethodDeclarations.replicateAllMethod, (Object[])new Object[]{list});
        BuddyManager bm = this.createBasicBuddyManager();
        MethodCall newReplicatedCall = bm.transformFqns(call5);
        List l = (List)newReplicatedCall.getArgs()[0];
        String expected = "/_BUDDY_BACKUP_/null";
        int i = 0;
        AssertJUnit.assertEquals((String)expected, (String)((MethodCall)l.get(i++)).getArgs()[0].toString());
        AssertJUnit.assertEquals((String)(expected + "/hello/world"), (String)((MethodCall)l.get(i++)).getArgs()[0].toString());
        AssertJUnit.assertEquals((String)(expected + "/hello/again"), (String)((MethodCall)l.get(i++)).getArgs()[0].toString());
        AssertJUnit.assertEquals((String)(expected + "/buddy/replication"), (String)((MethodCall)l.get(i)).getArgs()[0].toString());
    }

    public void testGetActualFqn() {
        Fqn x = new Fqn((Object[])new String[]{"x"});
        Fqn backup = BuddyManager.getBackupFqn((String)"y", (Fqn)x);
        AssertJUnit.assertEquals((Object)x, (Object)BuddyManager.getActualFqn((Fqn)backup));
    }
}

