/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Properties;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ConcurrentEvictionTest {
    private Cache<Integer, String> cache_;
    private int wakeupIntervalMillis_ = 0;
    private String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
    private String cacheLoaderDir = "/JBossCacheFileCacheLoader";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis_ = this.cache_.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        if (this.wakeupIntervalMillis_ < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
    }

    void initCaches() throws Exception {
        TestingUtil.recursiveFileRemove(this.tmpDir + this.cacheLoaderDir);
        CacheFactory factory = DefaultCacheFactory.getInstance();
        this.cache_ = factory.createCache("META-INF/local-eviction-cacheloader-service.xml", false);
        this.cache_.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        Properties p = new Properties();
        p.put("location", this.tmpDir + this.cacheLoaderDir);
        this.cache_.getConfiguration().getCacheLoaderConfig().getFirstCacheLoaderConfig().setProperties(p);
        this.cache_.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.recursiveFileRemove(this.tmpDir + this.cacheLoaderDir);
        this.cache_.stop();
        this.cache_ = null;
    }

    public void testConcurrentEviction() throws Exception {
        Fqn base = Fqn.fromString((String)"/org/jboss/test/data/concurrent/eviction");
        for (int i = 0; i < 1000; ++i) {
            this.cache_.put(new Fqn(new Object[]{base, i / 100}), (Object)i, (Object)"value");
        }
        long loopDone = System.currentTimeMillis() + (long)(5 * this.wakeupIntervalMillis_);
        while (System.currentTimeMillis() < loopDone) {
            for (int i = 0; i < 1000; ++i) {
                Fqn fqn = new Fqn(new Object[]{base, i / 100});
                Integer key = i;
                AssertJUnit.assertNotNull((String)("found value under Fqn " + fqn + " and key " + key), (Object)this.cache_.get(fqn, (Object)key));
            }
        }
    }
}

