/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.FIFOConfiguration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class FIFOConfigurationTest {
    public void testXMLParse() throws Exception {
        FIFOConfiguration config = new FIFOConfiguration();
        String xml = "<region name=\"abc\"><attribute name=\"maxNodes\">1000</attribute></region>";
        Element element = XmlHelper.stringToElement((String)xml);
        XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        AssertJUnit.assertEquals((int)1000, (int)config.getMaxNodes());
    }

    public void testXMLParse2() throws Exception {
        FIFOConfiguration config = new FIFOConfiguration();
        String xml = "<region name=\"abc\"></region>";
        Element element = XmlHelper.stringToElement((String)xml);
        try {
            XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        }
        catch (ConfigurationException ce) {
            AssertJUnit.assertTrue((String)"Configure Exception properly thrown", (boolean)true);
            return;
        }
        AssertJUnit.fail((String)"Invalid region FIFO configuration did not cause ConfigureException to be thrown");
    }

    public void testXMLParse3() throws Exception {
        FIFOConfiguration config = new FIFOConfiguration();
        String xml = "<region><attribute name=\"maxNodes\">1000</attribute></region>";
        Element element = XmlHelper.stringToElement((String)xml);
        try {
            XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        }
        catch (ConfigurationException ce) {
            AssertJUnit.assertTrue((String)"Configure Exception properly thrown", (boolean)true);
        }
    }
}

