/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.DummyEvictionPolicy;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.MRUAlgorithm;
import org.jboss.cache.eviction.MRUConfiguration;
import org.jboss.cache.eviction.NodeEventType;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class MRUAlgorithmTest {
    MRUAlgorithm algorithm;
    RegionManager regionManager;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.algorithm = new MRUAlgorithm();
        MRUConfiguration config = new MRUConfiguration();
        config.setMaxNodes(0);
        config.setEvictionPolicyClass(DummyEvictionPolicy.class.getName());
        this.regionManager = new RegionManager();
        this.regionManager.getRegion("/a/b", true).setEvictionPolicy((EvictionPolicyConfig)config);
    }

    public void testMaxNodes() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        MRUConfiguration config = (MRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(1);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        config.setMaxNodes(100);
        for (int i = 0; i < 150; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/c/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT));
        }
        this.algorithm.process(region);
        AssertJUnit.assertEquals((int)100, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMRU() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Fqn fqn4 = Fqn.fromString((String)"/a/b/f");
        Fqn fqn5 = Fqn.fromString((String)"/a/b/g");
        Fqn fqn6 = Fqn.fromString((String)"/a/b/h");
        Fqn fqn7 = Fqn.fromString((String)"/a/b/i");
        Fqn fqn8 = Fqn.fromString((String)"/a/b/j");
        Fqn fqn9 = Fqn.fromString((String)"/a/b/k");
        Fqn fqn10 = Fqn.fromString((String)"/a/b/l");
        Region region = this.regionManager.getRegion("/a/b", true);
        MRUConfiguration config = (MRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(8);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn4, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn5, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn6, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn7, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn8, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((int)8, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        region.putNodeEvent(new EvictedEventNode(fqn9, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn10, NodeEventType.ADD_NODE_EVENT));
        Thread.sleep(5000L);
        AssertJUnit.assertEquals((int)8, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn4, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((int)8, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        AssertJUnit.assertNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn2));
        AssertJUnit.assertNull((String)("No FQN4 " + this.algorithm.getEvictionQueue()), (Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn4));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn1));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn3));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn5));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn6));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn7));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn8));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn9));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn10));
    }
}

