/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.DummyEvictionConfiguration;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.LRUAlgorithm;
import org.jboss.cache.eviction.NodeEventType;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class RegionTest {
    RegionManager regionManager_;
    EvictionAlgorithm algorithm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.algorithm = new LRUAlgorithm();
        this.regionManager_ = new RegionManager();
        this.regionManager_.getRegion("/a/b", true).setEvictionPolicy((EvictionPolicyConfig)new DummyEvictionConfiguration());
    }

    public void testAddedQueue() {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager_.getRegion("/a/b", true);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        AssertJUnit.assertEquals((String)"AddedNode queue size ", (int)3, (int)region.nodeEventQueueSize());
        EvictedEventNode node = region.takeLastEventNode();
        Fqn fqn = node.getFqn();
        AssertJUnit.assertEquals((String)"DataNode retrieved should be FILO ", (Object)fqn, (Object)fqn1);
        AssertJUnit.assertEquals((String)"AddedNode queue size ", (int)2, (int)region.nodeEventQueueSize());
        fqn = region.takeLastEventNode().getFqn();
        fqn = region.takeLastEventNode().getFqn();
        node = region.takeLastEventNode();
        AssertJUnit.assertNull((String)"DataNode should be null", (Object)node);
    }

    public void testEventQueue() {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager_.getRegion("/a/b", true);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.REMOVE_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.VISIT_NODE_EVENT));
        AssertJUnit.assertEquals((String)"RemovedNode queue size ", (int)3, (int)region.nodeEventQueueSize());
        NodeEventType event = region.takeLastEventNode().getEventType();
        AssertJUnit.assertEquals((String)"DataNode retrieved should be: ", (Object)NodeEventType.REMOVE_NODE_EVENT, (Object)event);
        region.takeLastEventNode();
        region.takeLastEventNode();
        EvictedEventNode node = region.takeLastEventNode();
        AssertJUnit.assertNull((String)"DataNode should be null", (Object)node);
    }

    public void testMassivePutOnQueue() {
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Region region = this.regionManager_.getRegion("/a/b", true);
        for (int i = 0; i < 199999; ++i) {
            region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        }
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }
}

