/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.xml.XmlHelper;
import org.jgroups.conf.XmlConfigurator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UnitTestCacheConfigurationFactory {
    public static final String JGROUPS_CHANNEL = System.getProperty("jgroups.stack", "udp");
    public static final String JGROUPS_STACK_TYPE = "jgroups.stack";
    public static final String DEFAULT_CONFIGURATION_FILE = "META-INF/unit-test-cache-service.xml";

    public static Configuration createConfiguration(Configuration.CacheMode mode) throws ConfigurationException {
        return UnitTestCacheConfigurationFactory.createConfiguration(mode, false, false);
    }

    public static Configuration createConfiguration(Configuration.CacheMode mode, boolean useEviction) throws ConfigurationException {
        return UnitTestCacheConfigurationFactory.createConfiguration(mode, useEviction, false);
    }

    public static Configuration createConfiguration(Configuration.CacheMode mode, boolean useEviction, boolean usePassivation) throws ConfigurationException {
        UnitTestXmlConfigurationParser parser = new UnitTestXmlConfigurationParser();
        Configuration c = parser.parseFile(DEFAULT_CONFIGURATION_FILE, mode);
        if (!useEviction) {
            c.setEvictionConfig(null);
        }
        if (!usePassivation) {
            c.setCacheLoaderConfig(null);
        }
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        return c;
    }

    public static CacheLoaderConfig getSingleCacheLoaderConfig(String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared) throws Exception {
        return UnitTestCacheConfigurationFactory.getSingleCacheLoaderConfig(preload, cacheloaderClass, properties, async, fetchPersistentState, shared, false);
    }

    public static CacheLoaderConfig getSingleCacheLoaderConfig(String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared, boolean purgeOnStartup) throws Exception {
        return UnitTestCacheConfigurationFactory.getSingleCacheLoaderConfig(false, preload, cacheloaderClass, properties, async, fetchPersistentState, shared, purgeOnStartup);
    }

    protected static CacheLoaderConfig getSingleCacheLoaderConfig(boolean passivation, String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared, boolean purgeOnStartup) throws Exception {
        String xml = "<config>\n<passivation>" + passivation + "</passivation>\n" + "<preload>" + preload + "</preload>\n" + "<cacheloader>\n" + "<class>" + cacheloaderClass + "</class>\n" + "<properties>" + properties + "</properties>\n" + "<async>" + async + "</async>\n" + "<shared>" + shared + "</shared>\n" + "<fetchPersistentState>" + fetchPersistentState + "</fetchPersistentState>\n" + "<purgeOnStartup>" + purgeOnStartup + "</purgeOnStartup>\n" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    public static String getClusterConfigFromFile(URL url) {
        try {
            XmlConfigurator conf = XmlConfigurator.getInstance((URL)url);
            String tmp = conf.getProtocolStackString();
            tmp = tmp.replace("${jgroups.udp.mcast_addr:228.10.10.10}", "228.10.10.10");
            tmp = tmp.replace("${jgroups.udp.mcast_port:45588}", "45588");
            tmp = tmp.replace("${jgroups.udp.ip_ttl:2}", "2");
            System.out.println("config string: " + tmp);
            return tmp;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems with url " + url, e);
        }
    }

    public static String injectDelay(String jgroupsConfigString, int incomingDelay, int outgoingDelay) {
        String delay = ":DELAY(in_delay=" + incomingDelay + ";out_delay=" + outgoingDelay + ")";
        return jgroupsConfigString.substring(0, jgroupsConfigString.indexOf(":")) + delay + jgroupsConfigString.substring(jgroupsConfigString.indexOf(":"));
    }

    private static class UnitTestXmlConfigurationParser
    extends XmlConfigurationParser {
        private UnitTestXmlConfigurationParser() {
        }

        public Configuration parseFile(String filename, Configuration.CacheMode mode) {
            return this.parseStream(this.getAsInputStreamFromClassLoader(filename == null ? UnitTestCacheConfigurationFactory.DEFAULT_CONFIGURATION_FILE : filename), mode);
        }

        public Configuration parseStream(InputStream stream, Configuration.CacheMode mode) {
            if (stream == null) {
                throw new ConfigurationException("Input stream for configuration xml is null!");
            }
            Element root = XmlHelper.getDocumentRoot((InputStream)stream);
            Element mbeanElement = this.getMBeanElement(root);
            XmlConfigurationParser.ParsedAttributes attributes = UnitTestXmlConfigurationParser.extractAttributes((Element)mbeanElement);
            String keepStats = (String)attributes.stringAttribs.remove("UseMbean");
            if (keepStats != null && attributes.stringAttribs.get("ExposeManagementStatistics") == null) {
                attributes.stringAttribs.put("ExposeManagementStatistics", keepStats);
            }
            Configuration c = new Configuration();
            UnitTestXmlConfigurationParser.setValues((Object)c, (Map)attributes.stringAttribs, (boolean)false);
            this.setXmlValues(c, attributes.xmlAttribs);
            Element list = (Element)root.getElementsByTagName("protocol_stacks").item(0);
            NodeList stacks = list.getElementsByTagName("stack");
            for (int i = 0; i < stacks.getLength(); ++i) {
                Element stack = (Element)stacks.item(i);
                String stackName = stack.getAttribute("name");
                if (!stackName.startsWith(JGROUPS_CHANNEL)) continue;
                Element jgroupsStack = (Element)stack.getElementsByTagName("config").item(0);
                if (mode == Configuration.CacheMode.REPL_ASYNC && !stackName.contains("-")) {
                    c.setClusterConfig(jgroupsStack);
                    c.setCacheMode(Configuration.CacheMode.REPL_ASYNC);
                    break;
                }
                if (mode != Configuration.CacheMode.REPL_SYNC || !stackName.contains("-")) continue;
                c.setClusterConfig(jgroupsStack);
                c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
                break;
            }
            c.setCacheMode(mode);
            return c;
        }
    }
}

