/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invocationcontext;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class TransactionTest {
    private CacheSPI<Object, Object> cache;
    private TransactionManager tm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cache = (CacheSPI)DefaultCacheFactory.getInstance().createCache("META-INF/local-tx-service.xml");
        this.tm = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
    }

    public void testTxExistenceAfterWrite() throws Exception {
        this.tm.begin();
        AssertJUnit.assertNull((String)"Tx should not have been set up yet", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNull((String)"Gtx should not have been set up yet", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        this.cache.getRoot().put((Object)"k", (Object)"v");
        Map data = this.cache.getRoot().getData();
        AssertJUnit.assertEquals((String)"Data map should not empty", (int)1, (int)data.size());
        AssertJUnit.assertNotNull((String)"Tx should have been set up by now", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertEquals((String)"The same current transaction should be associated with this invocation ctx.", (Object)this.tm.getTransaction(), (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNotNull((String)"Gtx should have been set up by now", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        this.tm.commit();
    }

    public void testTxExistenceAfterRead() throws Exception {
        this.tm.begin();
        AssertJUnit.assertNull((String)"Tx should not have been set up yet", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNull((String)"Gtx should not have been set up yet", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        Object value = this.cache.get(Fqn.ROOT, (Object)"k");
        AssertJUnit.assertNull((String)"Value should be null", (Object)value);
        AssertJUnit.assertNotNull((String)"Tx should have been set up by now", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertEquals((String)"The same current transaction should be associated with this invocation ctx.", (Object)this.tm.getTransaction(), (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNotNull((String)"Gtx should have been set up by now", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        this.tm.commit();
    }

    public void testScrubbingAfterCommit() throws Exception {
        this.doScrubbingTest(true);
    }

    public void testScrubbingAfterRollback() throws Exception {
        this.doScrubbingTest(false);
    }

    private void doScrubbingTest(boolean commit) throws Exception {
        this.tm.begin();
        this.cache.getRoot().put((Object)"key", (Object)"value");
        AssertJUnit.assertNotNull((String)"Tx should have been set up by now", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertEquals((String)"The same current transaction should be associated with this invocation ctx.", (Object)this.tm.getTransaction(), (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNotNull((String)"Gtx should have been set up by now", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        if (commit) {
            this.tm.commit();
        } else {
            this.tm.rollback();
        }
        AssertJUnit.assertNull((String)"Tx should have been scrubbed", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNull((String)"Gtx should have been scrubbed", (Object)this.cache.getInvocationContext().getGlobalTransaction());
    }
}

