/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.Environment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.bdbje.BdbjeCacheLoaderConfig;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class BdbjeTest {
    private static final int STREAM_HEADER_LENGTH = 4;
    private static final String envHome = ".";
    private static final Fqn<String> FQN = new Fqn((Object[])new String[]{"key"});
    private CacheImpl cache;
    private CacheLoader loader;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        File dir = new File(envHome);
        class MyFilter
        implements FileFilter {
            MyFilter() {
            }

            public boolean accept(File file) {
                return file.getName().endsWith(".jdb");
            }
        }
        File[] files = dir.listFiles(new MyFilter());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isFile() || file.delete()) continue;
                System.err.println("Unable to delete: " + file);
            }
        }
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.loader != null) {
            try {
                this.loader.stop();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.loader = null;
        }
        if (this.cache != null) {
            try {
                this.cache.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cache = null;
        }
    }

    private void startLoader(boolean transactional, String dbName) throws Exception {
        String configStr;
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache.getConfiguration().setClusterName("myCluster");
        if (transactional) {
            this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        }
        this.cache.start();
        if (dbName != null) {
            configStr = ".#" + dbName;
        } else {
            configStr = envHome;
            dbName = "myCluster";
        }
        this.instantiateLoader();
        this.loader.setCache((CacheSPI)this.cache);
        BdbjeCacheLoaderConfig config = new BdbjeCacheLoaderConfig();
        config.setLocation(configStr);
        this.loader.setConfig((CacheLoaderConfig.IndividualCacheLoaderConfig)config);
        this.loader.create();
        this.loader.start();
        Environment env = new Environment(new File(envHome), null);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(transactional);
        Database db = env.openDatabase(null, dbName, dbConfig);
        db.close();
        env.close();
    }

    private void instantiateLoader() throws Exception {
        Class<?> cls = Class.forName("org.jboss.cache.loader.bdbje.BdbjeCacheLoader");
        this.loader = (CacheLoader)cls.newInstance();
    }

    private void stopLoader() throws Exception {
        this.loader.stop();
        this.loader.destroy();
    }

    public void testBasicOperations() throws Exception {
        this.doTestBasicOperations(false);
    }

    public void testBasicOperationsTransactional() throws Exception {
        this.doTestBasicOperations(true);
    }

    private void doTestBasicOperations(boolean transactional) throws Exception {
        this.startLoader(transactional, null);
        this.doPutTests((Fqn<String>)new Fqn((Object[])new String[]{"key"}));
        this.doRemoveTests((Fqn<String>)new Fqn((Object[])new String[]{"key"}));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        os.close();
        this.doPutTests((Fqn<String>)new Fqn((Object[])new String[]{"key1"}));
        this.doPutTests((Fqn<String>)new Fqn((Object[])new String[]{"key3"}));
        this.doPutTests((Fqn<String>)new Fqn((Object[])new String[]{"key2"}));
        AssertJUnit.assertEquals((int)4, (int)this.loader.get(new Fqn((Object[])new String[]{"key1"})).size());
        AssertJUnit.assertEquals((int)4, (int)this.loader.get(new Fqn((Object[])new String[]{"key2"})).size());
        AssertJUnit.assertEquals((int)4, (int)this.loader.get(new Fqn((Object[])new String[]{"key3"})).size());
        this.doRemoveTests((Fqn<String>)new Fqn((Object[])new String[]{"key2"}));
        this.doRemoveTests((Fqn<String>)new Fqn((Object[])new String[]{"key3"}));
        this.doRemoveTests((Fqn<String>)new Fqn((Object[])new String[]{"key1"}));
        AssertJUnit.assertEquals(null, (Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertEquals(null, (Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertEquals(null, (Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        baos = new ByteArrayOutputStream(1024);
        os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        os.close();
        this.stopLoader();
    }

    private void doPutTests(Fqn<String> fqn) throws Exception {
        AssertJUnit.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
        Object oldVal = this.loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertNull((Object)oldVal);
        oldVal = this.loader.put(fqn, (Object)"three", (Object)"four");
        AssertJUnit.assertNull((Object)oldVal);
        AssertJUnit.assertEquals((Object)"two", this.loader.get(fqn).get("one"));
        AssertJUnit.assertEquals((Object)"four", this.loader.get(fqn).get("three"));
        oldVal = this.loader.put(fqn, (Object)"one", (Object)"xxx");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        oldVal = this.loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertEquals((Object)"xxx", (Object)oldVal);
        Map map = this.loader.get(fqn);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"two", map.get("one"));
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        map.put("five", "six");
        map.put("seven", "eight");
        this.loader.put(fqn, map);
        AssertJUnit.assertEquals((Object)"six", this.loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"eight", this.loader.get(fqn).get("seven"));
        AssertJUnit.assertEquals((Object)map, (Object)this.loader.get(fqn));
        AssertJUnit.assertEquals((int)4, (int)map.size());
        AssertJUnit.assertTrue((boolean)this.loader.exists(fqn));
    }

    private void doRemoveTests(Fqn<String> fqn) throws Exception {
        Object oldVal = this.loader.remove(fqn, (Object)"one");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        oldVal = this.loader.remove(fqn, (Object)"five");
        AssertJUnit.assertEquals((Object)"six", (Object)oldVal);
        AssertJUnit.assertEquals(null, this.loader.get(fqn).get("one"));
        AssertJUnit.assertEquals(null, this.loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"four", this.loader.get(fqn).get("three"));
        AssertJUnit.assertEquals((Object)"eight", this.loader.get(fqn).get("seven"));
        Map map = this.loader.get(fqn);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        AssertJUnit.assertEquals((Object)"eight", map.get("seven"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(fqn));
        this.loader.remove(fqn);
        AssertJUnit.assertNull((String)"Null expected", (Object)this.loader.get(fqn));
        AssertJUnit.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
    }

    public void testMultiLevelTree() throws Exception {
        this.startLoader(false, null);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key0"})) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString((String)"/key0/level1/level2"), null);
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key0"})));
        this.loader.put(Fqn.fromString((String)"/key0/x/y"), null);
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/x")));
        this.loader.remove(Fqn.fromString((String)"/key0/x/y"));
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/x/y")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/x")));
        this.loader.remove(new Fqn((Object[])new String[]{"key0"}));
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key0"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/x")) ? 1 : 0) != 0);
        this.loader.put(new Fqn((Object[])new String[]{"key1"}), null);
        this.loader.put(new Fqn((Object[])new String[]{"key2"}), null);
        this.loader.put(new Fqn((Object[])new String[]{"key3"}), null);
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString((String)"/key3/level1/level2"), null);
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(Fqn.fromString((String)"/key3/level1"));
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key1"}));
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key1"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key3"}));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key3"})) ? 1 : 0) != 0);
        this.loader.remove(new Fqn((Object[])new String[]{"key2"}));
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key0"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key1"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key2"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key3"})) ? 1 : 0) != 0);
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        this.loader.put(Fqn.fromString((String)"/key0/level1/level2"), (Object)"a", (Object)"b");
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(Fqn.fromString((String)"/key0/level1")).size());
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(new Fqn((Object[])new String[]{"key0"})).size());
        this.loader.put(Fqn.fromString((String)"/key0/x/y"), (Object)"a", (Object)"b");
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(Fqn.fromString((String)"/key0/x")).size());
        this.loader.remove(Fqn.fromString((String)"/key0/x/y"));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(Fqn.fromString((String)"/key0/x")).size());
        this.loader.remove(new Fqn((Object[])new String[]{"key0"}));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x")));
        this.loader.put(new Fqn((Object[])new String[]{"key1"}), (Object)"a", (Object)"b");
        this.loader.put(new Fqn((Object[])new String[]{"key2"}), (Object)"a", (Object)"b");
        this.loader.put(new Fqn((Object[])new String[]{"key3"}), (Object)"a", (Object)"b");
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        this.loader.put(Fqn.fromString((String)"/key3/level1/level2"), (Object)"a", (Object)"b");
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(Fqn.fromString((String)"/key3/level1")).size());
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(Fqn.fromString((String)"/key3/level1"));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key1"}));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key3"}));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key2"}));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.stopLoader();
    }

    public void testGetChildrenNames() throws Exception {
        this.startLoader(false, null);
        this.checkChildren((Fqn<String>)new Fqn(), null);
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key0"), null);
        this.loader.put(Fqn.fromString((String)"/key0"), null);
        this.checkChildren((Fqn<String>)new Fqn(), new String[]{"key0"});
        this.loader.put(Fqn.fromString((String)"/key1/x"), null);
        this.checkChildren((Fqn<String>)new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key1"), new String[]{"x"});
        this.loader.remove(Fqn.fromString((String)"/key1/x"));
        this.checkChildren((Fqn<String>)new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key0"), null);
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key1"), null);
        this.loader.put(Fqn.fromString((String)"/key0/a"), null);
        this.loader.put(Fqn.fromString((String)"/key0/ab"), null);
        this.loader.put(Fqn.fromString((String)"/key0/abc"), null);
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc"});
        this.loader.put(Fqn.fromString((String)"/key0/xxx"), null);
        this.loader.put(Fqn.fromString((String)"/key0/xx"), null);
        this.loader.put(Fqn.fromString((String)"/key0/x"), null);
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
        this.loader.put(Fqn.fromString((String)"/key0/a/1"), null);
        this.loader.put(Fqn.fromString((String)"/key0/a/2"), null);
        this.loader.put(Fqn.fromString((String)"/key0/a/2/1"), null);
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key0/a/2"), new String[]{"1"});
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key0/a"), new String[]{"1", "2"});
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
        this.loader.put(Fqn.fromString((String)"/key0/\u0000"), null);
        this.loader.put(Fqn.fromString((String)"/key0/\u0001"), null);
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx", "\u0000", "\u0001"});
        this.loader.put(Fqn.fromString((String)"/\u0001"), null);
        this.checkChildren((Fqn<String>)new Fqn(), new String[]{"key0", "key1", "\u0001"});
        this.loader.put(Fqn.fromString((String)"/\u0001/\u0001"), null);
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/\u0001"), new String[]{"\u0001"});
        this.loader.put(Fqn.fromString((String)"/\u0001/\uffff"), null);
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/\u0001"), new String[]{"\u0001", "\uffff"});
        this.loader.put(Fqn.fromString((String)"/\u0001/\uffff/\u0001"), null);
        this.checkChildren((Fqn<String>)Fqn.fromString((String)"/\u0001/\uffff"), new String[]{"\u0001"});
        this.stopLoader();
    }

    private void checkChildren(Fqn<String> fqn, String[] names) throws Exception {
        Set set = this.loader.getChildrenNames(fqn);
        if (names != null) {
            AssertJUnit.assertEquals((int)names.length, (int)set.size());
            for (int i = 0; i < names.length; ++i) {
                AssertJUnit.assertTrue((boolean)set.contains(names[i]));
            }
        } else {
            AssertJUnit.assertNull((Object)set);
        }
    }

    public void testModifications() throws Exception {
        this.doTestModifications(false);
    }

    public void testModificationsTransactional() throws Exception {
        this.doTestModifications(true);
    }

    private void doTestModifications(boolean transactional) throws Exception {
        this.startLoader(transactional, null);
        List<Modification> list = this.createUpdates();
        this.loader.put(list);
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        list.add(mod);
        this.loader.put(list);
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_NODE);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.checkModifications(list);
        AssertJUnit.assertEquals(null, (Object)this.loader.get(FQN));
        this.loader.put(FQN, (Object)"one", (Object)"two");
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_DATA);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.checkModifications(list);
        AssertJUnit.assertNotNull((Object)this.loader.get(FQN));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(FQN).size());
        this.stopLoader();
    }

    public void testOnePhaseTransaction() throws Exception {
        this.startLoader(true, null);
        List<Modification> mods = this.createUpdates();
        this.loader.prepare(null, mods, true);
        this.checkModifications(mods);
        this.stopLoader();
    }

    public void testTwoPhaseTransaction() throws Exception {
        this.startLoader(true, null);
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        try {
            this.checkModifications(mods);
            AssertJUnit.fail((String)"Expected lock timeout");
        }
        catch (DeadlockException deadlockException) {
            // empty catch block
        }
        this.loader.commit(txnKey);
        this.checkModifications(mods);
        this.stopLoader();
    }

    public void testTransactionRollback() throws Exception {
        this.startLoader(true, null);
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        this.loader.rollback(txnKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        os.close();
        this.stopLoader();
    }

    private List<Modification> createUpdates() {
        ArrayList<Modification> list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        mod.setValue((Object)"two");
        list.add(mod);
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"three");
        mod.setValue((Object)"four");
        list.add(mod);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("five", "six");
        map.put("seven", "eight");
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_DATA);
        mod.setFqn(FQN);
        mod.setData(map);
        list.add(mod);
        return list;
    }

    private void checkModifications(List<Modification> list) throws Exception {
        block7: for (int i = 0; i < list.size(); ++i) {
            Modification mod = list.get(i);
            Fqn fqn = mod.getFqn();
            switch (mod.getType()) {
                case PUT_KEY_VALUE: {
                    AssertJUnit.assertEquals((Object)mod.getValue(), this.loader.get(fqn).get(mod.getKey()));
                    continue block7;
                }
                case PUT_DATA: {
                    Map map = mod.getData();
                    for (Object key : map.keySet()) {
                        AssertJUnit.assertEquals(map.get(key), this.loader.get(fqn).get(key));
                    }
                    continue block7;
                }
                case REMOVE_KEY_VALUE: {
                    AssertJUnit.assertEquals(null, this.loader.get(fqn).get(mod.getKey()));
                    continue block7;
                }
                case REMOVE_DATA: {
                    AssertJUnit.assertTrue((boolean)this.loader.exists(fqn));
                    AssertJUnit.assertNotNull((Object)this.loader.get(fqn));
                    AssertJUnit.assertEquals((int)0, (int)this.loader.get(fqn).size());
                    continue block7;
                }
                case REMOVE_NODE: {
                    AssertJUnit.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
                    AssertJUnit.assertEquals(null, (Object)this.loader.get(fqn));
                    continue block7;
                }
                default: {
                    AssertJUnit.fail((String)("unknown type: " + mod));
                }
            }
        }
    }

    public void testTransactionExceptions() throws Exception {
        List<Modification> mods = this.createUpdates();
        this.startLoader(false, null);
        try {
            this.loader.prepare(new Object(), mods, false);
            AssertJUnit.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        this.stopLoader();
        this.startLoader(true, null);
        try {
            this.loader.commit(new Object());
            AssertJUnit.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.loader.rollback(new Object());
            AssertJUnit.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        this.loader.storeEntireState((ObjectInputStream)is);
        is.close();
        Object txnKey = new Object();
        this.loader.prepare(txnKey, mods, false);
        this.loader.commit(txnKey);
        try {
            this.loader.commit(txnKey);
            AssertJUnit.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.loader.rollback(txnKey);
            AssertJUnit.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        bais = new ByteArrayInputStream(baos.toByteArray());
        is = new MarshalledValueInputStream((InputStream)bais);
        this.loader.storeEntireState((ObjectInputStream)is);
        is.close();
        txnKey = new Object();
        this.loader.prepare(txnKey, mods, false);
        this.loader.rollback(txnKey);
        try {
            this.loader.rollback(txnKey);
            AssertJUnit.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.loader.rollback(txnKey);
            AssertJUnit.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.stopLoader();
    }

    public void testNullKeysAndValues() throws Exception {
        this.startLoader(false, null);
        this.loader.put(FQN, null, (Object)"x");
        AssertJUnit.assertEquals((Object)"x", this.loader.get(FQN).get(null));
        HashMap<String, String> map = this.loader.get(FQN);
        AssertJUnit.assertEquals((int)1, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        this.loader.put(FQN, (Object)"y", null);
        AssertJUnit.assertEquals(null, this.loader.get(FQN).get("y"));
        map = this.loader.get(FQN);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        AssertJUnit.assertEquals(null, map.get("y"));
        this.loader.remove(FQN, null);
        AssertJUnit.assertEquals(null, this.loader.get(FQN).get(null));
        AssertJUnit.assertEquals((int)1, (int)this.loader.get(FQN).size());
        this.loader.remove(FQN, (Object)"y");
        AssertJUnit.assertNotNull((Object)this.loader.get(FQN));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(FQN).size());
        map = new HashMap<String, String>();
        map.put(null, null);
        this.loader.put(FQN, map);
        AssertJUnit.assertEquals(map, (Object)this.loader.get(FQN));
        this.loader.remove(FQN);
        AssertJUnit.assertNull((String)"Should be null", (Object)this.loader.get(FQN));
        map = new HashMap();
        map.put("xyz", null);
        map.put(null, "abc");
        this.loader.put(FQN, map);
        AssertJUnit.assertEquals(map, (Object)this.loader.get(FQN));
        this.loader.remove(FQN);
        AssertJUnit.assertEquals(null, (Object)this.loader.get(FQN));
        this.stopLoader();
    }

    public void testDatabaseName() throws Exception {
        this.startLoader(false, "nonDefaultDbName");
        this.loader.put(FQN, (Object)"one", (Object)"two");
        AssertJUnit.assertEquals((Object)"two", this.loader.get(FQN).get("one"));
        this.stopLoader();
    }

    public void testLoadAndStore() throws Exception {
        this.startLoader(false, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        this.loader.storeEntireState((ObjectInputStream)is);
        is.close();
        baos = new ByteArrayOutputStream(1024);
        os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        bais = new ByteArrayInputStream(baos.toByteArray());
        is = new MarshalledValueInputStream((InputStream)bais);
        this.loader.storeEntireState((ObjectInputStream)is);
        is.close();
        baos = new ByteArrayOutputStream(1024);
        os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertEquals(null, (Object)this.loader.get(FQN));
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        this.loader.put(FQN, (Object)1, (Object)c1);
        this.loader.put(FQN, (Object)2, (Object)c2);
        AssertJUnit.assertEquals((Object)c1, this.loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(FQN).size());
        baos = new ByteArrayOutputStream(1024);
        os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        AssertJUnit.assertTrue((baos.size() > 4 ? 1 : 0) != 0);
        os.close();
        byte[] savedState = baos.toByteArray();
        baos = new ByteArrayOutputStream(1024);
        os = new MarshalledValueOutputStream((OutputStream)baos);
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        bais = new ByteArrayInputStream(baos.toByteArray());
        is = new MarshalledValueInputStream((InputStream)bais);
        this.loader.storeEntireState((ObjectInputStream)is);
        is.close();
        AssertJUnit.assertEquals(null, (Object)this.loader.get(FQN));
        bais = new ByteArrayInputStream(savedState);
        is = new MarshalledValueInputStream((InputStream)bais);
        this.loader.storeEntireState((ObjectInputStream)is);
        is.close();
        AssertJUnit.assertEquals((Object)c1, this.loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(FQN).size());
        this.stopLoader();
    }

    private static class Complex
    implements Serializable {
        private static final long serialVersionUID = -1259096627833244770L;
        Complex nested;

        Complex() {
            this(null);
        }

        Complex(Complex nested) {
            this.nested = nested;
        }

        public boolean equals(Object o) {
            try {
                Complex x = (Complex)o;
                return this.nested != null ? this.nested.equals(x.nested) : x.nested == null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

