/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.lock.TimeoutException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ClusteredCacheLoaderTest
extends AbstractCacheLoaderTestBase {
    private static Log log = LogFactory.getLog(ClusteredCacheLoaderTest.class);
    private CacheImpl<Object, Object> cache1;
    private CacheImpl<Object, Object> cache2;
    private CacheLoader loader1;
    private CacheLoader loader2;
    private Fqn<String> fqn = Fqn.fromString((String)"/a");
    private String key = "key";
    protected boolean useRegionBasedMarshalling = false;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache1 != null || this.cache2 != null) {
            this.tearDown();
        }
        this.cache1 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache2 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache1.getConfiguration().setClusterName("CCL-Test");
        this.cache1.getConfiguration().setStateRetrievalTimeout(2000L);
        this.cache2.getConfiguration().setClusterName("CCL-Test");
        this.cache2.getConfiguration().setStateRetrievalTimeout(2000L);
        this.cache1.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache2.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache1.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.ClusteredCacheLoader", "timeout=500", false, false, false));
        this.cache2.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.ClusteredCacheLoader", "timeout=500", false, false, false));
        this.cache1.getConfiguration().setUseRegionBasedMarshalling(this.useRegionBasedMarshalling);
        this.cache2.getConfiguration().setUseRegionBasedMarshalling(this.useRegionBasedMarshalling);
        if (this.useRegionBasedMarshalling) {
            this.cache1.getRegionManager().getRegion(this.fqn, Region.Type.MARSHALLING, true).registerContextClassLoader(this.getClass().getClassLoader());
            this.cache2.getRegionManager().getRegion(this.fqn, Region.Type.MARSHALLING, true).registerContextClassLoader(this.getClass().getClassLoader());
        }
        this.cache1.start();
        this.cache2.start();
        this.loader1 = this.cache1.getCacheLoaderManager().getCacheLoader();
        this.loader2 = this.cache2.getCacheLoaderManager().getCacheLoader();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        System.out.println("***** TEARING DOWN ***** ");
        if (this.cache1 != null) {
            this.cache1.stop();
            this.cache1 = null;
            this.loader1 = null;
        }
        if (this.cache2 != null) {
            this.cache2.stop();
            this.cache2 = null;
            this.loader2 = null;
        }
    }

    public void testGetKeyValue() throws Exception {
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        log.info((Object)"Finished put");
        Assert.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        Assert.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
        this.cache1.evict(this.fqn);
        Assert.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        Assert.assertNull((String)"Expecting null", (Object)this.loader2.get(this.fqn));
        Assert.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
    }

    public void testGet() throws Exception {
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        Map map = this.loader1.get(this.fqn);
        Assert.assertTrue((String)"Should contain key", (boolean)map.containsKey(this.key));
        Assert.assertEquals((Object)"value", map.get(this.key));
        Assert.assertEquals((int)1, (int)map.size());
        map = this.loader2.get(this.fqn);
        Assert.assertTrue((String)"Should contain key", (boolean)map.containsKey(this.key));
        Assert.assertEquals((Object)"value", map.get(this.key));
        Assert.assertEquals((int)1, (int)map.size());
        this.cache1.evict(this.fqn);
        map = this.loader1.get(this.fqn);
        Assert.assertTrue((boolean)map.containsKey(this.key));
        Assert.assertEquals((Object)"value", map.get(this.key));
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertNull((String)"Expecting null", (Object)this.loader2.get(this.fqn));
        map = this.loader2.get(this.fqn);
        Assert.assertNull((String)"Should be null", (Object)map);
        Assert.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        map = this.loader2.get(this.fqn);
        Assert.assertTrue((boolean)map.containsKey(this.key));
        Assert.assertEquals((Object)"value", map.get(this.key));
        Assert.assertEquals((int)1, (int)map.size());
    }

    public void testGetChildrenNames() throws Exception {
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        Fqn child1 = new Fqn(this.fqn, (Object[])new String[]{"child1"});
        Fqn child2 = new Fqn(this.fqn, (Object[])new String[]{"child2"});
        Fqn child3 = new Fqn(this.fqn, (Object[])new String[]{"child3"});
        this.cache1.put(child1, (Object)this.key, (Object)"value");
        this.cache1.put(child2, (Object)this.key, (Object)"value");
        this.cache1.put(child3, (Object)this.key, (Object)"value");
        Set childNames = this.loader1.getChildrenNames(this.fqn);
        Assert.assertEquals((int)3, (int)childNames.size());
        childNames = this.loader2.getChildrenNames(this.fqn);
        Assert.assertEquals((int)3, (int)childNames.size());
        this.cache1.evict(child1);
        this.cache1.evict(child2);
        this.cache1.evict(child3);
        this.cache1.evict(this.fqn);
        childNames = this.loader1.getChildrenNames(this.fqn);
        Assert.assertEquals((int)3, (int)childNames.size());
        childNames = this.loader2.getChildrenNames(this.fqn);
        Assert.assertNull((String)"should be null", (Object)childNames);
        Assert.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        Assert.assertEquals((Object)"value", (Object)this.cache1.get(child1, (Object)this.key));
        Assert.assertEquals((Object)"value", (Object)this.cache1.get(child2, (Object)this.key));
        Assert.assertEquals((Object)"value", (Object)this.cache1.get(child3, (Object)this.key));
        childNames = this.loader2.getChildrenNames(this.fqn);
        Assert.assertEquals((int)3, (int)childNames.size());
    }

    public void testExists() throws Exception {
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        Assert.assertTrue((String)"should exist", (boolean)this.loader1.exists(this.fqn));
        Assert.assertTrue((String)"should exist", (boolean)this.loader2.exists(this.fqn));
        this.cache1.evict(this.fqn);
        Assert.assertTrue((String)"should exist", (boolean)this.loader1.exists(this.fqn));
        Assert.assertTrue((String)"should not exist", (!this.loader2.exists(this.fqn) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        Assert.assertTrue((String)"should exist", (boolean)this.loader2.exists(this.fqn));
    }

    public void testCacheLoaderThreadSafety() throws Exception {
        this.threadSafetyTest(true);
    }

    public void testCacheLoaderThreadSafetyMultipleFqns() throws Exception {
        this.threadSafetyTest(false);
    }

    protected void threadSafetyTest(final boolean singleFqn) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final Fqn fqn = Fqn.fromString((String)"/a/b/c");
        final ArrayList<Fqn> fqns = new ArrayList<Fqn>(30);
        final Random r = new Random();
        if (!singleFqn) {
            for (int i = 0; i < 30; ++i) {
                Fqn f = Fqn.fromString((String)("/a/b/c/" + i));
                fqns.add(f);
                this.cache2.put(f, (Object)"k", (Object)"v");
                this.cache1.evict(f);
            }
        } else {
            this.cache2.put(fqn, (Object)"k", (Object)"v");
            this.cache1.evict(fqn);
        }
        int loops = 10000;
        final CopyOnWriteArraySet exceptions = new CopyOnWriteArraySet();
        Thread evictor = new Thread("Evictor"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 10000; ++i) {
                        Fqn f = singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size()));
                        ClusteredCacheLoaderTest.this.cache1.evict(f);
                    }
                }
                catch (TimeoutException te) {
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        evictor.start();
        Thread writer = new Thread("Writer"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 10000; ++i) {
                        Fqn f = singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size()));
                        ClusteredCacheLoaderTest.this.cache2.put(f, (Object)"k", (Object)"v");
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        writer.start();
        Thread reader1 = new Thread("Reader-1"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 10000; ++i) {
                        ClusteredCacheLoaderTest.this.loader1.get(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())));
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        reader1.start();
        Thread reader2 = new Thread("Reader-2"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 10000; ++i) {
                        ClusteredCacheLoaderTest.this.loader1.getChildrenNames(singleFqn ? fqn.getParent() : ((Fqn)fqns.get(r.nextInt(fqns.size()))).getParent());
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        reader2.start();
        Thread reader3 = new Thread("Reader-3"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 10000; ++i) {
                        ClusteredCacheLoaderTest.this.loader1.getChildrenNames(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())));
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        reader3.start();
        latch.countDown();
        reader1.join();
        reader2.join();
        reader3.join();
        evictor.join();
        writer.join();
        Iterator i$ = exceptions.iterator();
        if (i$.hasNext()) {
            Exception e = (Exception)i$.next();
            throw e;
        }
    }
}

