/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.Set;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class LockReleaseTest {
    CacheImpl<Object, Object> cache = null;
    UserTransaction tx = null;
    Log log;
    final Fqn<String> NODE1 = Fqn.fromString((String)"/test");
    final Fqn<String> NODE2 = Fqn.fromString((String)"/my/test");
    final String KEY = "key";
    final String VAL1 = "val1";
    final String VAL2 = "val2";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.tx = TransactionSetup.getUserTransaction();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
        }
        TransactionSetup.cleanup();
        if (this.tx != null) {
            try {
                this.tx.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tx = null;
        }
    }

    CacheImpl<Object, Object> createCache(IsolationLevel level) throws Exception {
        CacheImpl c = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        c.getConfiguration().setClusterName("test");
        c.getConfiguration().setStateRetrievalTimeout(10000L);
        c.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.GenericTransactionManagerLookup");
        c.getConfiguration().setLockAcquisitionTimeout(500L);
        c.getConfiguration().setIsolationLevel(level);
        c.create();
        c.start();
        return c;
    }

    public void testReadWithReadUncommitted() throws Exception {
        this.testReadLockRelease(IsolationLevel.READ_UNCOMMITTED);
    }

    public void testWriteWithReadUncommitted() throws Exception {
        this.testWriteLockRelease(IsolationLevel.READ_UNCOMMITTED);
    }

    public void testReadWithReadCommitted() throws Exception {
        this.testReadLockRelease(IsolationLevel.READ_COMMITTED);
    }

    public void testWriteWithReadCommitted() throws Exception {
        this.testWriteLockRelease(IsolationLevel.READ_COMMITTED);
    }

    public void testReadWithRepeatableRead() throws Exception {
        this.testReadLockRelease(IsolationLevel.REPEATABLE_READ);
    }

    public void testWriteWithRepeatableRead() throws Exception {
        this.testWriteLockRelease(IsolationLevel.REPEATABLE_READ);
    }

    public void testReadWithSerialzable() throws Exception {
        this.testReadLockRelease(IsolationLevel.SERIALIZABLE);
    }

    public void testWriteWithSerializable() throws Exception {
        this.testWriteLockRelease(IsolationLevel.SERIALIZABLE);
    }

    public void testGetKeys() throws Exception {
        this.cache = this.createCache(IsolationLevel.REPEATABLE_READ);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        Set keys = this.cache.getKeys(this.NODE1);
        System.out.println("keys of " + this.NODE1 + " are " + keys);
        AssertJUnit.assertEquals((String)"getKeys() called outside the TX should have released all locks", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        keys = this.cache.getKeys(this.NODE1);
        AssertJUnit.assertEquals((String)"we should hold 1 read locks now: ", (int)2, (int)this.cache.getNumberOfLocksHeld());
        keys = this.cache.getKeys(this.NODE2);
        AssertJUnit.assertEquals((String)"we should hold 3 read locks now: ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 read locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testGetChildrenNames() throws Exception {
        this.cache = this.createCache(IsolationLevel.REPEATABLE_READ);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        Set keys = this.cache.getChildrenNames(this.NODE2);
        System.out.println("keys of " + this.NODE2 + " are " + keys);
        AssertJUnit.assertEquals((String)"getChildrenNames() called outside the TX should have released all locks", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        keys = this.cache.getChildrenNames(this.NODE1);
        AssertJUnit.assertEquals((String)"we should hold 1 read locks now: ", (int)2, (int)this.cache.getNumberOfLocksHeld());
        keys = this.cache.getChildrenNames(this.NODE2);
        AssertJUnit.assertEquals((String)"we should hold 3 read locks now: ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 read locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testPrint() throws Exception {
        this.cache = this.createCache(IsolationLevel.REPEATABLE_READ);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.cache.print(this.NODE1);
        AssertJUnit.assertEquals((String)"print() called outside the TX should have released all locks", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        this.cache.print(this.NODE1);
        AssertJUnit.assertEquals((String)"we should hold 1 read locks now (for print()): ", (int)2, (int)this.cache.getNumberOfLocksHeld());
        this.cache.print(this.NODE2);
        AssertJUnit.assertEquals((String)"we should hold 3 read locks now (for print()): ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 read locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    private void testReadLockRelease(IsolationLevel level) throws Exception {
        this.cache = this.createCache(level);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        AssertJUnit.assertEquals((Object)"val1", (Object)this.cache.get(this.NODE1, (Object)"key"));
        AssertJUnit.assertEquals((Object)"val1", (Object)this.cache.get(this.NODE2, (Object)"key"));
        AssertJUnit.assertEquals((String)"we should hold 3 read locks now: ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 read locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    private void testWriteLockRelease(IsolationLevel level) throws Exception {
        this.cache = this.createCache(level);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we should hold 3 write locks now: ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 write locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }
}

