/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock.pessimistic;

import java.util.ArrayList;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false)
public class ConcurrentPutRemoveTest {
    private TransactionManager tm;
    private Cache cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = DefaultCacheFactory.getInstance().createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.READ_COMMITTED);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setLockAcquisitionTimeout(10000L);
        this.cache.start();
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.destroy();
    }

    public void testLock() throws Exception {
        ArrayList<SeparateThread> threads = new ArrayList<SeparateThread>();
        for (int x = 0; x < 2; ++x) {
            SeparateThread t = new SeparateThread(x);
            threads.add(t);
            t.start();
        }
        for (SeparateThread separateThread : threads) {
            separateThread.join();
            if (separateThread.getException() == null) continue;
            throw separateThread.getException();
        }
    }

    private class SeparateThread
    extends Thread {
        Exception e = null;
        private int num = 0;

        public SeparateThread(int num) {
            this.num = num;
        }

        public Exception getException() {
            return this.e;
        }

        public void run() {
            Thread.currentThread().setName("Thread:" + this.num);
            try {
                for (int x = 0; x < 1000; ++x) {
                    ConcurrentPutRemoveTest.this.tm.begin();
                    System.out.println("R" + Thread.currentThread().getName());
                    ConcurrentPutRemoveTest.this.cache.removeNode(Fqn.fromString((String)"/a"));
                    System.out.println("AR" + Thread.currentThread().getName());
                    ConcurrentPutRemoveTest.this.tm.commit();
                    System.out.println("P" + Thread.currentThread().getName());
                    ConcurrentPutRemoveTest.this.cache.put(Fqn.fromString((String)"/a/b/c/d"), (Object)("text" + x), (Object)"b");
                    System.out.println("AP" + Thread.currentThread().getName());
                }
            }
            catch (Exception e) {
                this.e = e;
            }
        }
    }
}

