/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.MyList;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.SelectedClassnameClassLoader;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class ReturnValueMarshallingTest {
    private CacheImpl<Object, Object> cache1;
    private CacheImpl<Object, Object> cache2;
    private Fqn fqn = Fqn.fromString((String)"/a");
    private ClassLoader classLoader;
    private Object key = "key";
    private Object value;
    private String className = "org.jboss.cache.marshall.MyList";
    private Class listClass;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache1.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache1.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache1.getConfiguration().setSyncReplTimeout(60000L);
        this.cache1.start();
        this.cache2 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache2.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache2.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache2.getConfiguration().setSyncReplTimeout(60000L);
        this.cache2.start();
        this.classLoader = this.getClassLoader();
        Region r1 = this.cache1.getRegion(this.fqn, true);
        r1.setActive(true);
        r1.registerContextClassLoader(this.classLoader);
        Region r2 = this.cache2.getRegion(this.fqn, true);
        r2.setActive(true);
        r2.registerContextClassLoader(this.classLoader);
        this.listClass = this.classLoader.loadClass(this.className);
        this.value = this.listClass.newInstance();
        this.cache1.put(this.fqn, this.key, this.value);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cache1.stop();
        this.cache2.stop();
    }

    private ClassLoader getClassLoader() throws Exception {
        String[] includesClasses = new String[]{this.className};
        String[] excludesClasses = new String[]{};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new SelectedClassnameClassLoader(includesClasses, excludesClasses, cl);
    }

    public void testClusteredGet() throws Exception {
        AssertJUnit.assertNotNull((Object)this.cache1.get(this.fqn, this.key));
        AssertJUnit.assertNotSame(MyList.class, this.cache1.get(this.fqn, this.key).getClass());
        AssertJUnit.assertSame((Object)this.listClass, this.cache1.get(this.fqn, this.key).getClass());
        AssertJUnit.assertNotNull((Object)this.cache2.get(this.fqn, this.key));
        AssertJUnit.assertNotSame(MyList.class, this.cache2.get(this.fqn, this.key).getClass());
        AssertJUnit.assertSame((Object)this.listClass, this.cache2.get(this.fqn, this.key).getClass());
        MethodCall call = MethodCallFactory.create((Method)MethodDeclarations.replicateMethod, (Object[])new Object[]{MethodCallFactory.create((Method)MethodDeclarations.clusteredGetMethod, (Object[])new Object[]{MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{this.fqn, this.key, false}), false})});
        List responses = this.cache1.getRPCManager().callRemoteMethods(null, call, true, true, 15000);
        List response1 = (List)responses.get(0);
        Boolean found = (Boolean)response1.get(0);
        AssertJUnit.assertTrue((String)"Should have found remote data", (boolean)found);
        Object data = response1.get(1);
        AssertJUnit.assertNotNull(data);
        AssertJUnit.assertNotSame(MyList.class, data.getClass());
        AssertJUnit.assertSame((Object)this.listClass, data.getClass());
    }

    public void testDataGravitation() throws Exception {
        AssertJUnit.assertNotNull((Object)this.cache1.get(this.fqn, this.key));
        AssertJUnit.assertNotSame(MyList.class, this.cache1.get(this.fqn, this.key).getClass());
        AssertJUnit.assertSame((Object)this.listClass, this.cache1.get(this.fqn, this.key).getClass());
        AssertJUnit.assertNotNull((Object)this.cache2.get(this.fqn, this.key));
        AssertJUnit.assertNotSame(MyList.class, this.cache2.get(this.fqn, this.key).getClass());
        AssertJUnit.assertSame((Object)this.listClass, this.cache2.get(this.fqn, this.key).getClass());
        MethodCall call = MethodCallFactory.create((Method)MethodDeclarations.replicateMethod, (Object[])new Object[]{MethodCallFactory.create((Method)MethodDeclarations.dataGravitationMethod, (Object[])new Object[]{this.fqn, false})});
        List responses = this.cache1.getRPCManager().callRemoteMethods(null, call, true, true, 15000);
        GravitateResult data = (GravitateResult)responses.get(0);
        AssertJUnit.assertTrue((String)"Should have found remote data", (boolean)data.isDataFound());
        AssertJUnit.assertNotNull((Object)data.getNodeData());
        Object value = ((NodeData)data.getNodeData().get(0)).getAttributes().get(this.key);
        AssertJUnit.assertNotNull(value);
        AssertJUnit.assertNotSame(MyList.class, value.getClass());
        AssertJUnit.assertSame((Object)this.listClass, value.getClass());
    }
}

