/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall.data;

import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class Debug {
    public static void displayClassInfo(Class clazz, StringBuffer results) {
        Debug.displayClassInfo(clazz, results, true);
    }

    public static void displayClassInfo(Class clazz, StringBuffer results, boolean showParentClassLoaders) {
        CodeSource clazzCS;
        ClassLoader cl = clazz.getClassLoader();
        results.append("\n" + clazz.getName() + "(" + Integer.toHexString(clazz.hashCode()) + ").ClassLoader=" + cl);
        for (ClassLoader parent = cl; parent != null; parent = parent.getParent()) {
            results.append("\n.." + parent);
            URL[] urls = Debug.getClassLoaderURLs(parent);
            int length = urls != null ? urls.length : 0;
            for (int u = 0; u < length; ++u) {
                results.append("\n...." + urls[u]);
            }
            if (!showParentClassLoaders) break;
        }
        if ((clazzCS = clazz.getProtectionDomain().getCodeSource()) != null) {
            results.append("\n++++CodeSource: " + clazzCS);
        } else {
            results.append("\n++++Null CodeSource");
        }
        results.append("\nImplemented Interfaces:");
        Class<?>[] ifaces = clazz.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            Class<?> iface = ifaces[i];
            results.append("\n++" + iface + "(" + Integer.toHexString(iface.hashCode()) + ")");
            ClassLoader loader = ifaces[i].getClassLoader();
            results.append("\n++++ClassLoader: " + loader);
            ProtectionDomain pd = ifaces[i].getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                results.append("\n++++CodeSource: " + cs);
                continue;
            }
            results.append("\n++++Null CodeSource");
        }
    }

    public static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                Object[] args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }
}

