/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.misc;

import java.io.File;
import java.util.List;
import java.util.Random;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.util.CachePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestingUtil {
    private static Random random = new Random();

    public static <T extends Interceptor> T findInterceptor(CacheSPI<?, ?> cache, Class<T> interceptorToFind) {
        for (Interceptor i : cache.getInterceptorChain()) {
            if (!interceptorToFind.isInstance(i)) continue;
            return (T)((Interceptor)interceptorToFind.cast(i));
        }
        return null;
    }

    public static void injectInterceptor(CacheSPI<?, ?> cache, Interceptor interceptorToInject, Class<? extends Interceptor> interceptorAfterWhichToInject) {
        System.out.println("Old interceptor chain: " + CachePrinter.printCacheInterceptors(cache));
        interceptorToInject.setCache(cache);
        int index = -1;
        for (Interceptor i : cache.getInterceptorChain()) {
            ++index;
            if (!interceptorAfterWhichToInject.isInstance(i)) continue;
            break;
        }
        cache.addInterceptor(interceptorToInject, index + 1);
        System.out.println("New interceptor chain: " + CachePrinter.printCacheInterceptors(cache));
    }

    public static void blockUntilViewsReceived(Cache[] caches, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static void blockUntilViewsReceived(long timeout, Cache ... caches) {
        TestingUtil.blockUntilViewsReceived(caches, timeout);
    }

    public static void blockUntilViewsReceived(CacheImpl[] caches, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static void blockUntilViewsReceived(long timeout, boolean barfIfTooManyMembers, Cache ... caches) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches, barfIfTooManyMembers)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static void blockUntilViewReceived(CacheSPI cache, int groupSize, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.isCacheViewComplete((Cache)cache, groupSize)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static void blockUntilViewReceived(CacheImpl cache, int groupSize, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.isCacheViewComplete(cache, groupSize)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static boolean areCacheViewsComplete(Cache[] caches) {
        return TestingUtil.areCacheViewsComplete(caches, true);
    }

    public static boolean areCacheViewsComplete(Cache[] caches, boolean barfIfTooManyMembers) {
        int memberCount = caches.length;
        for (int i = 0; i < memberCount; ++i) {
            if (TestingUtil.isCacheViewComplete(caches[i], memberCount, barfIfTooManyMembers)) continue;
            return false;
        }
        return true;
    }

    public static boolean areCacheViewsComplete(CacheImpl[] caches) {
        if (caches == null) {
            throw new NullPointerException("Cache impl array is null");
        }
        Cache[] c = new Cache[caches.length];
        for (int i = 0; i < caches.length; ++i) {
            c[i] = caches[i];
        }
        return TestingUtil.areCacheViewsComplete(c);
    }

    public static boolean isCacheViewComplete(CacheImpl cache, int memberCount) {
        List members = cache.getMembers();
        if (members == null || memberCount > members.size()) {
            return false;
        }
        if (memberCount < members.size()) {
            StringBuffer sb = new StringBuffer("Cache at address ");
            sb.append(cache.getLocalAddress());
            sb.append(" had ");
            sb.append(members.size());
            sb.append(" members; expecting ");
            sb.append(memberCount);
            sb.append(". Members were (");
            for (int j = 0; j < members.size(); ++j) {
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append(members.get(j));
            }
            sb.append(')');
            throw new IllegalStateException(sb.toString());
        }
        return true;
    }

    public static boolean isCacheViewComplete(Cache c, int memberCount) {
        return TestingUtil.isCacheViewComplete(c, memberCount, true);
    }

    public static boolean isCacheViewComplete(Cache c, int memberCount, boolean barfIfTooManyMembers) {
        CacheSPI cache = (CacheSPI)c;
        List members = cache.getMembers();
        if (members == null || memberCount > members.size()) {
            return false;
        }
        if (memberCount < members.size()) {
            if (barfIfTooManyMembers) {
                StringBuffer sb = new StringBuffer("Cache at address ");
                sb.append(cache.getLocalAddress());
                sb.append(" had ");
                sb.append(members.size());
                sb.append(" members; expecting ");
                sb.append(memberCount);
                sb.append(". Members were (");
                for (int j = 0; j < members.size(); ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    sb.append(members.get(j));
                }
                sb.append(')');
                throw new IllegalStateException(sb.toString());
            }
            return false;
        }
        return true;
    }

    public static void sleepThread(long sleeptime) {
        try {
            Thread.sleep(sleeptime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleepRandom(int maxTime) {
        TestingUtil.sleepThread(random.nextInt(maxTime));
    }

    public static void recursiveFileRemove(String directoryName) {
        File file = new File(directoryName);
        if (file.exists()) {
            System.out.println("Deleting file " + file);
            TestingUtil.recursivedelete(file);
        }
    }

    private static void recursivedelete(File f) {
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                TestingUtil.recursivedelete(file);
            }
        }
        f.delete();
    }

    public static void killCaches(Cache ... caches) {
        for (Cache c : caches) {
            if (c == null || c.getCacheStatus() != CacheStatus.STARTED) continue;
            CacheImpl ci = (CacheImpl)c;
            if (ci.getTransactionManager() != null) {
                try {
                    ci.getTransactionManager().rollback();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (ci.getCacheLoader() != null) {
                try {
                    ci.getCacheLoader().remove(Fqn.ROOT);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ci.stop();
            ci.destroy();
        }
    }
}

