/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.InputStream;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.statetransfer.StateTransferTestBase;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class FailedStateTransferTest
extends StateTransferTestBase {
    public void testFailedStateTransfer() throws Exception {
        SecretiveStateCache cache = new SecretiveStateCache();
        cache.setConfiguration(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC));
        cache.getConfiguration().setClusterName("VersionedTestBase");
        cache.getConfiguration().setReplVersionString(this.getReplicationVersion());
        cache.getConfiguration().setStateRetrievalTimeout(60000L);
        this.caches.put("secretive", cache);
        cache.create();
        cache.start();
        SecretiveStateCache recipient = new SecretiveStateCache();
        recipient.setConfiguration(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC));
        recipient.getConfiguration().setClusterName("VersionedTestBase");
        recipient.getConfiguration().setReplVersionString(this.getReplicationVersion());
        recipient.getConfiguration().setStateRetrievalTimeout(60000L);
        this.caches.put("secretive2", recipient);
        try {
            recipient.create();
            recipient.start();
            AssertJUnit.fail((String)"start() should throw an exception");
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    protected String getReplicationVersion() {
        return "2.1.0.CR1";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SecretiveStateCache
    extends CacheImpl<Object, Object> {
        SecretiveStateCache() throws Exception {
            this.setMessageListener(new Adaptor());
        }

        class Adaptor
        extends CacheImpl.MessageListenerAdaptor {
            Adaptor() {
                super((CacheImpl)SecretiveStateCache.this);
            }

            public void setState(byte[] new_state) {
                this.setStateException = new TimeoutException("Planned Timeout");
            }

            public void setState(InputStream istream) {
                this.setStateException = new TimeoutException("Planned Timeout");
            }

            public void setState(String state_id, byte[] state) {
                this.setStateException = new TimeoutException("Planned Timeout");
            }

            public void setState(String state_id, InputStream istream) {
                this.setStateException = new TimeoutException("Planned Timeout");
            }
        }
    }
}

