/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "transaction"})
public class InvocationContextCleanupTest {
    private CacheImpl[] caches;

    private CacheImpl<Object, Object> createCache(boolean optimistic) throws Exception {
        CacheImpl cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        if (optimistic) {
            cache.getConfiguration().setNodeLockingScheme("OPTIMISTIC");
        }
        cache.getConfiguration().setClusterName("InvocationContextCleanupTest");
        cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        cache.getConfiguration().setLockAcquisitionTimeout(2000L);
        cache.start();
        return cache;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.caches != null) {
            for (int i = 0; i < this.caches.length; ++i) {
                if (this.caches[i] == null) continue;
                this.caches[i].stop();
                this.caches[i] = null;
            }
            this.caches = null;
        }
    }

    public void testInvocationContextCleanupPessimistic() throws Exception {
        this.test2CachesSync(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test2CachesSync(boolean optimistic) throws Exception {
        this.caches = new CacheImpl[2];
        CacheImpl<Object, Object> cache0 = this.createCache(optimistic);
        CacheImpl<Object, Object> cache1 = this.createCache(optimistic);
        this.caches[0] = cache0;
        this.caches[1] = cache1;
        TestingUtil.blockUntilViewsReceived(this.caches, 2000L);
        TransactionManager mgr = this.caches[0].getTransactionManager();
        mgr.begin();
        OrderedSynchronizationHandler orderedHandler = OrderedSynchronizationHandler.getInstance((Transaction)mgr.getTransaction());
        orderedHandler.registerAtTail((Synchronization)new DummySynchronization(cache0, mgr));
        cache0.put("/test", (Object)"x", (Object)"y");
        mgr.commit();
        System.out.println(this.caches[0].printLockInfo());
        System.out.println(this.caches[1].printLockInfo());
        AssertJUnit.assertEquals((Object)"y", (Object)cache0.get("/test", (Object)"x"));
        AssertJUnit.assertEquals((Object)"y", (Object)cache0.get("/test", (Object)"x"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummySynchronization
    implements Synchronization {
        private CacheImpl<Object, Object> cache;
        private TransactionManager mgr;

        public DummySynchronization(CacheImpl<Object, Object> cache, TransactionManager mgr) {
            this.cache = cache;
            this.mgr = mgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeCompletion() {
            Transaction tx = null;
            try {
                tx = this.mgr.suspend();
            }
            catch (SystemException e) {
                throw new RuntimeException("Unable to sustend transaction! " + e.getMessage());
            }
            try {
                this.cache.put("/test", (Object)"blah", (Object)"blahblah");
                AssertJUnit.assertTrue((String)"Should fail with a lock exception!", (boolean)false);
            }
            catch (Exception e) {
                AssertJUnit.assertTrue((String)"Should fail!", (boolean)true);
            }
            finally {
                if (tx != null) {
                    try {
                        this.mgr.resume(tx);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public void afterCompletion(int i) {
        }
    }
}

