/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.util.MapCopy;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class MapCopyTest {
    public void testSerializable() throws Exception {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put(null, null);
        hm.put("y", "z");
        MapCopy mc = new MapCopy(hm);
        AssertJUnit.assertEquals(hm, (Object)mc);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(mc);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(is);
        Object o = ois.readObject();
        AssertJUnit.assertEquals(hm, (Object)o);
    }

    public void testSerializableWithMarshalledValueStream() throws Exception {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put(null, null);
        hm.put("y", "z");
        MapCopy mc = new MapCopy(hm);
        AssertJUnit.assertEquals(hm, (Object)mc);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        MarshalledValueOutputStream oos = new MarshalledValueOutputStream((OutputStream)os);
        oos.writeObject(mc);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        MarshalledValueInputStream ois = new MarshalledValueInputStream((InputStream)is);
        Object o = ois.readObject();
        AssertJUnit.assertEquals(hm, (Object)o);
    }

    public void testNull() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put(null, null);
        MapCopy mc = new MapCopy(hm);
        AssertJUnit.assertEquals(hm, (Object)mc);
        AssertJUnit.assertEquals((String)hm.toString(), (String)mc.toString());
        hm.put(null, "x");
        hm.put("y", null);
        mc = new MapCopy(hm);
        mc.toString();
        AssertJUnit.assertEquals((boolean)true, (boolean)mc.containsKey((Object)"y"));
    }

    public void testAll() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("a", "b");
        hm.put("b", "c");
        MapCopy mc = new MapCopy(hm);
        AssertJUnit.assertEquals(hm, (Object)mc);
        AssertJUnit.assertEquals((int)hm.size(), (int)mc.size());
        try {
            mc.clear();
            AssertJUnit.fail((String)"read only");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        HashMap bhm = new HashMap(hm);
        hm.put("b", "d");
        AssertJUnit.assertEquals(bhm, (Object)mc);
        Map.Entry me = (Map.Entry)mc.entrySet().iterator().next();
        try {
            me.setValue("arg");
            AssertJUnit.fail((String)"read only");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    public void testModifications() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("a", "b");
        MapCopy mc = new MapCopy(hm);
        try {
            mc.put("x", "y");
            AssertJUnit.fail((String)"should fail");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            mc.remove("a");
            AssertJUnit.fail((String)"should fail");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            mc.keySet().iterator().remove();
            AssertJUnit.fail((String)"should fail");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            mc.entrySet().iterator().remove();
            AssertJUnit.fail((String)"should fail");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            mc.values().iterator().remove();
            AssertJUnit.fail((String)"should fail");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

