/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.standalone;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javassist.bytecode.ClassFile;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Deployment;
import org.jboss.aop.instrument.TransformationException;
import org.jboss.aop.standalone.XmlReport;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

public class Compiler {
    private static final Logger logger = AOPLogger.getLogger(Compiler.class);
    private FileFilter classFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".class");
        }
    };
    private FileFilter directoryFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    public boolean verbose = false;
    public boolean suppress = true;
    public boolean optimized = true;
    public static URLClassLoader loader;
    private HashMap classesToCompile = new HashMap();

    public boolean isJarFile(File src) {
        return src.isFile() && (src.getName().toLowerCase().endsWith(".jar") || src.getName().toLowerCase().endsWith(".zip"));
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        Compiler c = new Compiler();
        try {
            c.compile(args);
        }
        catch (Exception e) {
            if (c.verbose) {
                throw e;
            }
            if (e instanceof TransformationException) {
                System.exit(1);
            }
            throw e;
        }
        System.out.println("Build Successful: " + (System.currentTimeMillis() - start) + " ms");
    }

    public void usage() {
        System.err.println("Usage: aopc [-cp <classpath>] [-classpath <classpath>] [-report] [-noopt] [-verbose] [-aoppath <xml files>] <dir>+");
    }

    public void compile(String[] args) throws Exception {
        File f;
        if (args.length == 0) {
            this.usage();
            System.exit(1);
            return;
        }
        ArrayList<URL> paths = new ArrayList<URL>();
        ArrayList<File> files = new ArrayList<File>();
        boolean report = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (args[i].equals("-suppress")) {
                this.suppress = true;
                continue;
            }
            if (args[i].equals("-noopt")) {
                this.optimized = false;
                continue;
            }
            if (args[i].equals("-report")) {
                report = true;
                continue;
            }
            if (args[i].equals("-cp") || args[i].equals("-classpath")) {
                if (i + 1 > args.length - 1) {
                    this.usage();
                    System.exit(1);
                    return;
                }
                StringTokenizer tokenizer = new StringTokenizer(args[++i], File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String cpath = tokenizer.nextToken();
                    File f2 = new File(cpath);
                    paths.add(f2.toURL());
                }
                continue;
            }
            if (args[i].equals("-aoppath")) {
                System.setProperty("jboss.aop.path", args[++i]);
                continue;
            }
            if (args[i].equals("-aopclasspath")) {
                System.setProperty("jboss.aop.class.path", args[++i]);
                continue;
            }
            if (args[i].equals("--SOURCEPATH")) {
                this.addFilesFromSourcePathFile(files, args[++i]);
                continue;
            }
            File f3 = new File(args[i]).getCanonicalFile();
            files.add(f3);
        }
        URL[] urls = paths.toArray(new URL[paths.size()]);
        loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        Deployment.searchClasspath = true;
        AspectManager.verbose = this.verbose;
        AspectManager.suppressReferenceErrors = this.suppress;
        AspectManager.optimize = this.optimized;
        AspectManager.instance();
        if (report) {
            for (int i = 0; i < files.size(); ++i) {
                f = (File)files.get(i);
                this.loadFile(f);
            }
            FileOutputStream reportFile = new FileOutputStream("aop-report.xml");
            reportFile.write(XmlReport.toXml().getBytes());
            reportFile.close();
        } else {
            for (int i = 0; i < files.size(); ++i) {
                f = (File)files.get(i);
                if (f.isDirectory()) {
                    this.addDirectory(f);
                    continue;
                }
                if (this.classFileFilter.accept(f)) {
                    this.addFile(f);
                    continue;
                }
                if (!this.verbose) continue;
                System.out.println("[aopc] " + f + " is neither a java class or a directory");
            }
            for (String className : this.classesToCompile.keySet()) {
                CompilerClassInfo info = (CompilerClassInfo)this.classesToCompile.get(className);
                this.compileFile(info);
            }
        }
    }

    private void addDirectory(File dir) throws Exception {
        int i;
        File[] directories = dir.listFiles(this.directoryFilter);
        File[] classFiles = dir.listFiles(this.classFileFilter);
        for (i = 0; i < classFiles.length; ++i) {
            this.addFile(classFiles[i]);
        }
        for (i = 0; i < directories.length; ++i) {
            this.addDirectory(directories[i]);
        }
    }

    private void addFile(File file) throws Exception {
        ClassFile cf = this.createClassFile(file);
        String className = cf.getName();
        String superClassName = cf.getSuperclass();
        CompilerClassInfo info = new CompilerClassInfo(file, className, superClassName);
        this.classesToCompile.put(className, info);
    }

    private ClassFile createClassFile(File file) throws Exception {
        DataInputStream is = new DataInputStream(new FileInputStream(file));
        ClassFile cf = new ClassFile(is);
        is.close();
        return cf;
    }

    private void addFilesFromSourcePathFile(ArrayList files, String sourcePathFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(new File(sourcePathFile).getCanonicalFile()));
            String fileName = reader.readLine();
            while (fileName != null) {
                files.add(new File(fileName).getCanonicalFile());
                fileName = reader.readLine();
            }
        }
        catch (Exception e) {
            try {
                reader.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    public void loadFile(File file) throws Exception {
        DataInputStream is = new DataInputStream(new FileInputStream(file));
        ClassFile cf = new ClassFile(is);
        is.close();
        Class<?> clazz = loader.loadClass(cf.getName());
        if (Advised.class.isAssignableFrom(clazz)) {
            Field f = clazz.getDeclaredField("aop$classAdvisor$aop");
            f.setAccessible(true);
            f.get(null);
        }
    }

    public void compileFile(CompilerClassInfo info) throws Exception {
        File infoFile;
        URL classUrl;
        CompilerClassInfo superInfo;
        if (info.isCompiled()) {
            return;
        }
        if (info.getSuperClassName() != null && (superInfo = (CompilerClassInfo)this.classesToCompile.get(info.getSuperClassName())) != null) {
            this.compileFile(superInfo);
        }
        if ((classUrl = loader.getResource(info.getClassName().replace('.', '/') + ".class")) == null) {
            System.out.println("[warning] Unable to find " + info.getFile() + " within classpath.  Make sure all transforming classes are within classpath.");
            return;
        }
        File classUrlFile = new File(URLDecoder.decode(classUrl.getFile(), "UTF-8"));
        if (!classUrlFile.equals(infoFile = new File(URLDecoder.decode(info.getFile().toString(), "UTF-8")))) {
            System.out.println("[warning] Trying to compile " + info.getFile() + " and found it also within " + classUrl.getFile() + " will not proceed. ");
            return;
        }
        byte[] bytes = AspectManager.instance().transform(loader, info.getClassName(), null, null, null);
        if (bytes == null) {
            if (this.verbose) {
                System.out.println("[no comp needed] " + info.getFile());
            }
            return;
        }
        FileOutputStream os = new FileOutputStream(infoFile);
        os.write(bytes);
        os.close();
        info.setCompiled(true);
        if (this.verbose) {
            System.out.println("[compiled] " + info.getFile());
        }
    }

    private class CompilerClassInfo {
        File file;
        String className;
        String superClassName;
        boolean compiled;

        CompilerClassInfo(File file, String className, String superClassName) {
            this.file = file;
            this.className = className;
            this.superClassName = superClassName;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isCompiled() {
            return this.compiled;
        }

        public void setCompiled(boolean compiled) {
            this.compiled = compiled;
        }

        public String getClassName() {
            return this.className;
        }

        public String getSuperClassName() {
            return this.superClassName;
        }
    }
}

