/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Exchanger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.ExitEvent;
import org.jgroups.ExtendedReceiver;
import org.jgroups.GetStateEvent;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.SetStateEvent;
import org.jgroups.StateTransferException;
import org.jgroups.StreamingGetStateEvent;
import org.jgroups.StreamingSetStateEvent;
import org.jgroups.SuspectEvent;
import org.jgroups.TimeoutException;
import org.jgroups.UnblockEvent;
import org.jgroups.View;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Promise;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JChannel
extends Channel {
    public static final String DEFAULT_PROTOCOL_STACK = "udp.xml";
    static final String FORCE_PROPS = "force.properties";
    private String props = null;
    private Address local_addr = null;
    private String cluster_name = null;
    private View my_view = null;
    private final Queue mq = new Queue();
    private ProtocolStack prot_stack = null;
    protected CloserThread closer = null;
    private final Promise<Address> local_addr_promise = new Promise();
    private final Promise<Boolean> state_promise = new Promise();
    private final Exchanger<StateTransferInfo> applstate_exchanger = new Exchanger();
    private final Promise<Boolean> flush_unblock_promise = new Promise();
    private long LOCAL_ADDR_TIMEOUT = 30000L;
    private static final long GET_STATE_DEFAULT_TIMEOUT = 5000L;
    private static final long FLUSH_UNBLOCK_TIMEOUT = 10000L;
    private boolean receive_blocks = false;
    private boolean receive_local_msgs = true;
    private boolean auto_reconnect = false;
    private boolean auto_getstate = false;
    protected volatile boolean connected = false;
    protected volatile boolean closed = false;
    private boolean state_transfer_supported = false;
    private volatile boolean flush_supported = false;
    protected final Map<String, Object> additional_data = new HashMap<String, Object>();
    protected final ConcurrentMap<String, Object> info = new ConcurrentHashMap<String, Object>();
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean stats = true;
    protected long sent_msgs = 0L;
    protected long received_msgs = 0L;
    protected long sent_bytes = 0L;
    protected long received_bytes = 0L;

    protected JChannel(boolean no_op) {
    }

    public JChannel() throws ChannelException {
        this(DEFAULT_PROTOCOL_STACK);
    }

    public JChannel(File properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(Element properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(URL properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(String properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    protected JChannel(ProtocolStackConfigurator configurator) throws ChannelException {
        this.init(configurator);
    }

    public JChannel(Object properties) throws ChannelException {
        if (properties == null) {
            properties = DEFAULT_PROTOCOL_STACK;
        }
        ProtocolStackConfigurator c = null;
        try {
            c = ConfiguratorFactory.getStackConfigurator(properties);
        }
        catch (Exception x) {
            throw new ChannelException("unable to load protocol stack", x);
        }
        this.init(c);
    }

    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    public String getProperties() {
        return this.props;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean stats) {
        this.stats = stats;
    }

    public void resetStats() {
        this.received_bytes = 0L;
        this.sent_bytes = 0L;
        this.received_msgs = 0L;
        this.sent_msgs = 0L;
    }

    public long getSentMessages() {
        return this.sent_msgs;
    }

    public long getSentBytes() {
        return this.sent_bytes;
    }

    public long getReceivedMessages() {
        return this.received_msgs;
    }

    public long getReceivedBytes() {
        return this.received_bytes;
    }

    public int getNumberOfTasksInTimer() {
        return this.prot_stack != null ? this.prot_stack.timer.size() : -1;
    }

    public int getTimerThreads() {
        return this.prot_stack != null ? this.prot_stack.getTimerThreads() : -1;
    }

    public String dumpTimerQueue() {
        return this.prot_stack != null ? this.prot_stack.dumpTimerQueue() : "<n/a";
    }

    public String printProtocolSpec(boolean include_properties) {
        return this.prot_stack != null ? this.prot_stack.printProtocolSpec(include_properties) : null;
    }

    @Override
    public synchronized void connect(String cluster_name) throws ChannelException {
        block6: {
            this.startStack(cluster_name);
            if (cluster_name != null) {
                boolean shouldWaitForUnblock;
                Event connect_event;
                Object res;
                if (this.flush_supported) {
                    this.flush_unblock_promise.reset();
                }
                if ((res = this.downcall(connect_event = new Event(2, cluster_name))) != null && res instanceof Exception) {
                    throw new ChannelException("connect() failed", (Throwable)res);
                }
                boolean singletonMember = this.my_view != null && this.my_view.size() == 1;
                boolean bl = shouldWaitForUnblock = this.flush_supported && this.receive_blocks && !singletonMember && !this.flush_unblock_promise.hasResult();
                if (shouldWaitForUnblock) {
                    try {
                        this.flush_unblock_promise.getResultWithTimeout(10000L);
                    }
                    catch (TimeoutException timeout) {
                        if (!this.log.isWarnEnabled()) break block6;
                        this.log.warn((Object)(this.local_addr + " waiting on UNBLOCK after connect() timed out"));
                    }
                }
            }
        }
        this.connected = true;
        this.notifyChannelConnected(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connect(String cluster_name, Address target, String state_id, long timeout) throws ChannelException {
        block9: {
            this.startStack(cluster_name);
            boolean stateTransferOk = false;
            boolean joinSuccessful = false;
            boolean canFetchState = false;
            if (cluster_name != null) {
                try {
                    Event connect_event = new Event(80, cluster_name);
                    Object res = this.downcall(connect_event);
                    boolean bl = joinSuccessful = res == null || !(res instanceof Exception);
                    if (!joinSuccessful) {
                        throw new ChannelException("connect() failed", (Throwable)res);
                    }
                    this.connected = true;
                    this.notifyChannelConnected(this);
                    boolean bl2 = canFetchState = this.getView() != null && this.getView().size() > 1;
                    if (!canFetchState) break block9;
                    try {
                        stateTransferOk = this.getState(target, state_id, timeout, false);
                        if (!stateTransferOk) {
                            throw new StateTransferException(this.getLocalAddress() + " could not fetch state " + state_id + " from " + target);
                        }
                    }
                    catch (Exception e) {
                        throw new StateTransferException(this.getLocalAddress() + " could not fetch state " + state_id + " from " + target, e);
                    }
                }
                finally {
                    if (this.flush_supported && canFetchState) {
                        this.stopFlush();
                    }
                }
            }
        }
    }

    @Override
    public synchronized void disconnect() {
        if (this.closed) {
            return;
        }
        if (this.connected) {
            block5: {
                if (this.cluster_name != null) {
                    Event disconnect_event = new Event(4, this.local_addr);
                    this.down(disconnect_event);
                }
                this.connected = false;
                try {
                    this.prot_stack.stopStack();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error((Object)("exception: " + e));
                }
            }
            this.notifyChannelDisconnected(this);
            this.init();
        }
    }

    @Override
    public synchronized void close() {
        this._close(true, true);
    }

    @Override
    public synchronized void shutdown() {
        this.down(new Event(79));
        this._close(false, true);
    }

    @Override
    public synchronized void open() throws ChannelException {
        if (!this.closed) {
            throw new ChannelException("channel is already open");
        }
        try {
            this.mq.reset();
            this.prot_stack = new ProtocolStack(this, this.props);
            this.prot_stack.setup();
            this.closed = false;
        }
        catch (Exception e) {
            throw new ChannelException("failed to open channel", e);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public int getNumMessages() {
        return this.mq != null ? this.mq.size() : -1;
    }

    @Override
    public String dumpQueue() {
        return Util.dumpQueue(this.mq);
    }

    @Override
    public Map dumpStats() {
        Map tmp;
        Map<String, Object> retval = this.prot_stack.dumpStats();
        if (retval != null && (tmp = this.dumpChannelStats()) != null) {
            retval.put("channel", tmp);
        }
        return retval;
    }

    private Map dumpChannelStats() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("sent_msgs", new Long(this.sent_msgs));
        retval.put("sent_bytes", new Long(this.sent_bytes));
        retval.put("received_msgs", new Long(this.received_msgs));
        retval.put("received_bytes", new Long(this.received_bytes));
        return retval;
    }

    @Override
    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosedOrNotConnected();
        if (this.stats) {
            ++this.sent_msgs;
            this.sent_bytes += (long)msg.getLength();
        }
        if (msg == null) {
            throw new NullPointerException("msg is null");
        }
        this.down(new Event(1, msg));
    }

    @Override
    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    @Override
    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        this.checkClosedOrNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.remove() : (Event)this.mq.remove(timeout);
            Object retval = JChannel.getEvent(evt);
            evt = null;
            if (this.stats && retval != null && retval instanceof Message) {
                ++this.received_msgs;
                this.received_bytes += (long)((Message)retval).getLength();
            }
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            throw new ChannelClosedException();
        }
        catch (TimeoutException t) {
            throw t;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + e));
            }
            return null;
        }
    }

    @Override
    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        this.checkClosedOrNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.peek() : (Event)this.mq.peek(timeout);
            Object retval = JChannel.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + queue_closed));
            }
            return null;
        }
        catch (TimeoutException t) {
            return null;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + e));
            }
            return null;
        }
    }

    @Override
    public View getView() {
        return this.closed || !this.connected ? null : this.my_view;
    }

    @Override
    public Address getLocalAddress() {
        return this.closed ? null : this.local_addr;
    }

    @Override
    public String getChannelName() {
        return this.closed ? null : (!this.connected ? null : this.cluster_name);
    }

    @Override
    public String getClusterName() {
        return this.cluster_name;
    }

    @Override
    public void setOpt(int option, Object value) {
        if (this.closed) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"channel is closed; option not set !");
            }
            return;
        }
        switch (option) {
            case 1: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)"option VIEW has been deprecated (it is always true now); this option is ignored");
                break;
            }
            case 2: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)"option SUSPECT has been deprecated (it is always true now); this option is ignored");
                break;
            }
            case 0: {
                if (value instanceof Boolean) {
                    this.receive_blocks = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 4: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)"option GET_STATE_EVENTS has been deprecated (it is always true now); this option is ignored");
                break;
            }
            case 3: {
                if (value instanceof Boolean) {
                    this.receive_local_msgs = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 5: {
                if (value instanceof Boolean) {
                    this.auto_reconnect = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 6: {
                if (value instanceof Boolean) {
                    this.auto_getstate = (Boolean)value;
                    if (!this.auto_getstate) break;
                    this.auto_reconnect = true;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            default: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " not known"));
            }
        }
    }

    @Override
    public Object getOpt(int option) {
        switch (option) {
            case 1: {
                return Boolean.TRUE;
            }
            case 0: {
                return this.receive_blocks ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return Boolean.TRUE;
            }
            case 5: {
                return this.auto_reconnect ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return this.auto_getstate ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return Boolean.TRUE;
            }
            case 3: {
                return this.receive_local_msgs ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)("option " + Channel.option2String(option) + " not known"));
        }
        return null;
    }

    @Override
    public void blockOk() {
    }

    @Override
    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.getState(target, null, timeout);
    }

    @Override
    public boolean getState(Address target, String state_id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.getState(target, state_id, timeout, true);
    }

    public boolean getState(Address target, String state_id, long timeout, boolean useFlushIfPresent) throws ChannelNotConnectedException, ChannelClosedException {
        boolean state_transfer_successfull;
        boolean initiateFlush;
        this.checkClosedOrNotConnected();
        if (!this.state_transfer_supported) {
            throw new IllegalStateException("fetching state will fail as state transfer is not supported. Add one of the STATE_TRANSFER protocols to your protocol configuration");
        }
        if (target == null) {
            target = this.determineCoordinator();
        }
        if (target != null && this.local_addr != null && target.equals(this.local_addr)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("cannot get state from myself (" + target + "): probably the first member"));
            }
            return false;
        }
        StateTransferInfo state_info = new StateTransferInfo(target, state_id, timeout);
        boolean bl = initiateFlush = this.flush_supported && useFlushIfPresent;
        if (initiateFlush) {
            this.startFlush(false);
        }
        this.state_promise.reset();
        this.down(new Event(19, state_info));
        Boolean b = this.state_promise.getResult(state_info.timeout);
        if (initiateFlush) {
            this.stopFlush();
        }
        boolean bl2 = state_transfer_successfull = b != null && b != false;
        if (!state_transfer_successfull) {
            this.down(new Event(66));
        }
        return state_transfer_successfull;
    }

    @Override
    public boolean getAllStates(Vector targets, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        throw new UnsupportedOperationException("use getState() instead");
    }

    @Override
    public void returnState(byte[] state) {
        try {
            StateTransferInfo state_info = new StateTransferInfo(null, null, 0L, state);
            this.applstate_exchanger.exchange(state_info);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void returnState(byte[] state, String state_id) {
        try {
            StateTransferInfo state_info = new StateTransferInfo(null, state_id, 0L, state);
            this.applstate_exchanger.exchange(state_info);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object up(Event evt) {
        block63: {
            type = evt.getType();
            switch (type) {
                case 1: {
                    msg = (Message)evt.getArg();
                    if (this.receive_local_msgs || this.local_addr == null || msg.getSrc() == null || !this.local_addr.equals(msg.getSrc())) break;
                    return null;
                }
                case 6: {
                    tmp = (View)evt.getArg();
                    if (tmp instanceof MergeView) {
                        this.my_view = new View(tmp.getVid(), tmp.getMembers());
                        break;
                    }
                    this.my_view = tmp;
                    break;
                }
                case 56: {
                    config = (Map)evt.getArg();
                    if (config == null) break;
                    if (config.containsKey("state_transfer")) {
                        this.state_transfer_supported = (Boolean)config.get("state_transfer");
                    }
                    if (!config.containsKey("flush_supported")) break;
                    this.flush_supported = (Boolean)config.get("flush_supported");
                    break;
                }
                case 84: {
                    m = (Map)evt.getArg();
                    this.info.putAll(m);
                    break;
                }
                case 20: {
                    state_info = (StateTransferInfo)evt.getArg();
                    state = state_info.state;
                    this.state_promise.setResult(state != null ? Boolean.TRUE : Boolean.FALSE);
                    if (this.up_handler != null) {
                        return this.up_handler.up(evt);
                    }
                    if (state == null) break;
                    state_id = state_info.state_id;
                    if (this.receiver != null) {
                        try {
                            if (this.receiver instanceof ExtendedReceiver && state_id != null) {
                                ((ExtendedReceiver)this.receiver).setState(state_id, state);
                                break;
                            }
                            this.receiver.setState(state);
                        }
                        catch (Throwable t) {
                            if (!this.log.isWarnEnabled()) break;
                            this.log.warn((Object)"failed calling setState() in receiver", t);
                        }
                        break;
                    }
                    try {
                        this.mq.add(new Event(21, state_info));
                    }
                    catch (Exception e) {}
                    break;
                }
                case 71: {
                    sti = (StateTransferInfo)evt.getArg();
                    is = sti.inputStream;
                    if (this.up_handler != null) {
                        return this.up_handler.up(evt);
                    }
                    if (is == null) break;
                    if (this.receiver instanceof ExtendedReceiver) {
                        try {
                            if (sti.state_id == null) {
                                ((ExtendedReceiver)this.receiver).setState(is);
                                break;
                            }
                            ((ExtendedReceiver)this.receiver).setState(sti.state_id, is);
                        }
                        catch (Throwable t) {
                            if (!this.log.isWarnEnabled()) break;
                            this.log.warn((Object)"failed calling setState() in receiver", t);
                        }
                        break;
                    }
                    if (this.receiver instanceof Receiver) {
                        if (!this.log.isWarnEnabled()) break;
                        this.log.warn((Object)"Channel has STREAMING_STATE_TRANSFER, however, application does not implement ExtendedMessageListener. State is not transfered");
                        Util.close(is);
                        break;
                    }
                    try {
                        this.mq.add(new Event(71, sti));
                    }
                    catch (Exception e) {}
                    break;
                }
                case 8: {
                    this.local_addr_promise.setResult((Address)evt.getArg());
                    break;
                }
                case 46: {
                    this.handleExit(evt);
                    return null;
                }
            }
            if (this.up_handler != null) {
                ret = this.up_handler.up(evt);
                if (type == 75) {
                    this.flush_unblock_promise.setResult(Boolean.TRUE);
                }
                return ret;
            }
            switch (type) {
                case 1: {
                    if (this.receiver == null) break;
                    try {
                        this.receiver.receive((Message)evt.getArg());
                    }
                    catch (Throwable t) {
                        if (!this.log.isWarnEnabled()) ** GOTO lbl97
                        this.log.warn((Object)"failed calling receive() in receiver", t);
                    }
lbl97:
                    // 3 sources

                    return null;
                }
                case 6: {
                    if (this.receiver == null) break;
                    try {
                        this.receiver.viewAccepted((View)evt.getArg());
                    }
                    catch (Throwable t) {
                        if (!this.log.isWarnEnabled()) ** GOTO lbl106
                        this.log.warn((Object)"failed calling viewAccepted() in receiver", t);
                    }
lbl106:
                    // 3 sources

                    return null;
                }
                case 9: {
                    if (this.receiver == null) break;
                    try {
                        this.receiver.suspect((Address)evt.getArg());
                    }
                    catch (Throwable t) {
                        if (!this.log.isWarnEnabled()) ** GOTO lbl115
                        this.log.warn((Object)"failed calling suspect() in receiver", t);
                    }
lbl115:
                    // 3 sources

                    return null;
                }
                case 17: {
                    if (this.receiver == null) break;
                    state_info = (StateTransferInfo)evt.getArg();
                    tmp_state = null;
                    state_id = state_info.state_id;
                    try {
                        tmp_state = this.receiver instanceof ExtendedReceiver && state_id != null ? ((ExtendedReceiver)this.receiver).getState(state_id) : this.receiver.getState();
                    }
                    catch (Throwable t) {
                        if (!this.log.isWarnEnabled()) ** GOTO lbl127
                        this.log.warn((Object)"failed calling getState() in receiver", t);
                    }
lbl127:
                    // 3 sources

                    return new StateTransferInfo(null, state_id, 0L, tmp_state);
                }
                case 72: {
                    sti = (StateTransferInfo)evt.getArg();
                    os = sti.outputStream;
                    if (!(this.receiver instanceof ExtendedReceiver)) ** GOTO lbl143
                    if (os == null) break;
                    try {
                        if (sti.state_id == null) {
                            ((ExtendedReceiver)this.receiver).getState(os);
                        } else {
                            ((ExtendedReceiver)this.receiver).getState(sti.state_id, os);
                        }
                    }
                    catch (Throwable t) {
                        if (!this.log.isWarnEnabled()) ** GOTO lbl142
                        this.log.warn((Object)"failed calling getState() in receiver", t);
                    }
lbl142:
                    // 4 sources

                    return new StateTransferInfo(null, os, sti.state_id);
lbl143:
                    // 1 sources

                    if (!(this.receiver instanceof Receiver) || !this.log.isWarnEnabled()) break;
                    this.log.warn((Object)"Channel has STREAMING_STATE_TRANSFER, however, application does not implement ExtendedMessageListener. State is not transfered");
                    Util.close(os);
                    break;
                }
                case 10: {
                    if (!this.receive_blocks) {
                        return Boolean.TRUE;
                    }
                    if (this.receiver == null) break;
                    try {
                        this.receiver.block();
                    }
                    catch (Throwable t) {
                        if (!this.log.isErrorEnabled()) ** GOTO lbl157
                        this.log.error((Object)"failed calling block() in receiver", t);
                    }
lbl157:
                    // 3 sources

                    return Boolean.TRUE;
                }
                case 75: {
                    if (!this.receive_blocks) {
                        return null;
                    }
                    if (!(this.receiver instanceof ExtendedReceiver)) ** GOTO lbl168
                    try {
                        ((ExtendedReceiver)this.receiver).unblock();
                    }
                    catch (Throwable t) {
                        if (!this.log.isErrorEnabled()) ** GOTO lbl168
                        this.log.error((Object)"failed calling unblock() in receiver", t);
                    }
lbl168:
                    // 4 sources

                    this.flush_unblock_promise.setResult(Boolean.TRUE);
                    break;
                }
            }
            if (type == 1 || type == 6 || type == 9 || type == 17 || type == 72 || type == 10 || type == 75) {
                try {
                    this.mq.add(evt);
                }
                catch (QueueClosedException queue_closed) {
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) break block63;
                    this.log.warn((Object)("exception adding event " + evt + " to message queue"), (Throwable)e);
                }
            }
        }
        if (type == 17) {
            try {
                return this.applstate_exchanger.exchange(null);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return null;
    }

    @Override
    public void down(Event evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getType()) {
            case 56: {
                try {
                    Map m = (Map)evt.getArg();
                    if (m == null) break;
                    this.additional_data.putAll(m);
                    if (!m.containsKey("additional_data")) break;
                    byte[] tmp = (byte[])m.get("additional_data");
                    if (!(this.local_addr instanceof IpAddress)) break;
                    ((IpAddress)this.local_addr).setAdditionalData(tmp);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break;
                    this.log.error((Object)("CONFIG event did not contain a hashmap: " + t));
                }
                break;
            }
            case 73: {
                this.state_promise.setResult(Boolean.TRUE);
            }
        }
        this.prot_stack.down(evt);
    }

    @Override
    public Object downcall(Event evt) {
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 56: {
                try {
                    Map m = (Map)evt.getArg();
                    if (m == null) break;
                    this.additional_data.putAll(m);
                    if (!m.containsKey("additional_data")) break;
                    byte[] tmp = (byte[])m.get("additional_data");
                    if (!(this.local_addr instanceof IpAddress)) break;
                    ((IpAddress)this.local_addr).setAdditionalData(tmp);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break;
                    this.log.error((Object)("CONFIG event did not contain a hashmap: " + t));
                }
                break;
            }
            case 73: {
                this.state_promise.setResult(Boolean.TRUE);
            }
        }
        return this.prot_stack.down(evt);
    }

    public String toString(boolean details) {
        StringBuilder sb = new StringBuilder();
        sb.append("local_addr=").append(this.local_addr).append('\n');
        sb.append("cluster_name=").append(this.cluster_name).append('\n');
        sb.append("my_view=").append(this.my_view).append('\n');
        sb.append("connected=").append(this.connected).append('\n');
        sb.append("closed=").append(this.closed).append('\n');
        if (this.mq != null) {
            sb.append("incoming queue size=").append(this.mq.size()).append('\n');
        }
        if (details) {
            sb.append("receive_blocks=").append(this.receive_blocks).append('\n');
            sb.append("receive_local_msgs=").append(this.receive_local_msgs).append('\n');
            sb.append("auto_reconnect=").append(this.auto_reconnect).append('\n');
            sb.append("auto_getstate=").append(this.auto_getstate).append('\n');
            sb.append("state_transfer_supported=").append(this.state_transfer_supported).append('\n');
            sb.append("props=").append(this.props).append('\n');
        }
        return sb.toString();
    }

    protected final void init(ProtocolStackConfigurator configurator) throws ChannelException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"JGroups version: 2.6.0 cr-1");
        }
        ConfiguratorFactory.substituteVariables(configurator);
        this.props = configurator.getProtocolStackString();
        this.prot_stack = new ProtocolStack(this, this.props);
        try {
            this.prot_stack.setup();
        }
        catch (Throwable e) {
            throw new ChannelException("unable to setup the protocol stack", e);
        }
    }

    private void init() {
        this.local_addr = null;
        this.cluster_name = null;
        this.my_view = null;
        this.connected = false;
    }

    private void startStack(String cluster_name) throws ChannelException {
        this.checkClosed();
        if (this.connected) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("already connected to " + cluster_name));
            }
            return;
        }
        if (cluster_name == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"cluster_name is null, assuming unicast channel");
            }
        } else {
            this.cluster_name = cluster_name;
        }
        try {
            this.prot_stack.startStack();
        }
        catch (Throwable e) {
            throw new ChannelException("failed to start protocol stack", e);
        }
        String tmp = Util.getProperty(new String[]{"jgroups.channel.local_addr_timeout", "local_addr.timeout"}, null, null, false, "30000");
        this.LOCAL_ADDR_TIMEOUT = Long.parseLong(tmp);
        this.local_addr = this.local_addr_promise.getResult(this.LOCAL_ADDR_TIMEOUT);
        if (this.local_addr == null) {
            this.log.fatal((Object)"local_addr is null; cannot connect");
            throw new ChannelException("local_addr is null");
        }
        Vector<Address> t = new Vector<Address>(1);
        t.addElement(this.local_addr);
        this.my_view = new View(this.local_addr, 0L, t);
    }

    protected void checkClosed() throws ChannelClosedException {
        if (this.closed) {
            throw new ChannelClosedException();
        }
    }

    protected void checkClosedOrNotConnected() throws ChannelNotConnectedException, ChannelClosedException {
        if (this.closed) {
            throw new ChannelClosedException();
        }
        if (!this.connected) {
            throw new ChannelNotConnectedException();
        }
    }

    static Object getEvent(Event evt) {
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 1: {
                return evt.getArg();
            }
            case 6: {
                return evt.getArg();
            }
            case 9: {
                return new SuspectEvent(evt.getArg());
            }
            case 10: {
                return new BlockEvent();
            }
            case 75: {
                return new UnblockEvent();
            }
            case 17: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new GetStateEvent(info.target, info.state_id);
            }
            case 21: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new SetStateEvent(info.state, info.state_id);
            }
            case 72: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new StreamingGetStateEvent(info.outputStream, info.state_id);
            }
            case 71: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new StreamingSetStateEvent(info.inputStream, info.state_id);
            }
            case 46: {
                return new ExitEvent();
            }
        }
        return evt;
    }

    protected void _close(boolean disconnect, boolean close_mq) {
        block10: {
            block9: {
                if (this.closed) {
                    return;
                }
                if (disconnect) {
                    this.disconnect();
                }
                if (close_mq) {
                    try {
                        if (this.mq != null) {
                            this.mq.close(false);
                        }
                    }
                    catch (Exception e) {
                        if (!this.log.isErrorEnabled()) break block9;
                        this.log.error((Object)("exception: " + e));
                    }
                }
            }
            if (this.prot_stack != null) {
                try {
                    this.prot_stack.stopStack();
                    this.prot_stack.destroy();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error((Object)"failed destroying the protocol stack", (Throwable)e);
                }
            }
        }
        this.closed = true;
        this.connected = false;
        this.notifyChannelClosed(this);
        this.init();
    }

    public final void closeMessageQueue(boolean flush_entries) {
        if (this.mq != null) {
            this.mq.close(flush_entries);
        }
    }

    private void handleExit(Event evt) {
        this.notifyChannelShunned();
        if (this.closer != null && !this.closer.isAlive()) {
            this.closer = null;
        }
        if (this.closer == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"received an EXIT event, will leave the channel");
            }
            this.closer = new CloserThread(evt);
            this.closer.start();
        }
    }

    @Override
    public boolean flushSupported() {
        return this.flush_supported;
    }

    @Override
    public boolean startFlush(boolean automatic_resume) {
        if (!this.flush_supported) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        boolean successfulFlush = (Boolean)this.downcall(new Event(68));
        if (automatic_resume) {
            this.stopFlush();
        }
        return successfulFlush;
    }

    @Override
    public boolean startFlush(long timeout, boolean automatic_resume) {
        return this.startFlush(automatic_resume);
    }

    @Override
    public void stopFlush() {
        if (!this.flush_supported) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.flush_unblock_promise.reset();
        this.down(new Event(70));
        boolean shouldWaitForUnblock = this.receive_blocks;
        if (shouldWaitForUnblock) {
            try {
                this.flush_unblock_promise.getResultWithTimeout(10000L);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    @Override
    public Map<String, Object> getInfo() {
        return new HashMap<String, Object>(this.info);
    }

    Address determineCoordinator() {
        Vector<Address> mbrs;
        Vector<Address> vector = mbrs = this.my_view != null ? this.my_view.getMembers() : null;
        if (mbrs == null) {
            return null;
        }
        if (!mbrs.isEmpty()) {
            return mbrs.firstElement();
        }
        return null;
    }

    class CloserThread
    extends Thread {
        final Event evt;
        final Thread t;

        CloserThread(Event evt) {
            super(Util.getGlobalThreadGroup(), "CloserThread");
            this.t = null;
            this.evt = evt;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String old_cluster_name;
                block31: {
                    old_cluster_name = JChannel.this.cluster_name;
                    if (JChannel.this.log.isDebugEnabled()) {
                        JChannel.this.log.debug((Object)"closing the channel");
                    }
                    JChannel.this._close(false, false);
                    if (JChannel.this.up_handler != null) {
                        JChannel.this.up_handler.up(this.evt);
                    } else {
                        try {
                            if (JChannel.this.receiver == null) {
                                JChannel.this.mq.add(this.evt);
                            }
                        }
                        catch (Exception ex) {
                            if (!JChannel.this.log.isErrorEnabled()) break block31;
                            JChannel.this.log.error((Object)("exception: " + ex));
                        }
                    }
                }
                if (JChannel.this.mq != null) {
                    Util.sleep(500L);
                    try {
                        JChannel.this.mq.close(false);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (JChannel.this.auto_reconnect) {
                    try {
                        if (JChannel.this.log.isDebugEnabled()) {
                            JChannel.this.log.debug((Object)("reconnecting to group " + old_cluster_name));
                        }
                        JChannel.this.open();
                        if (JChannel.this.additional_data != null) {
                            HashMap<String, Object> m = new HashMap<String, Object>(JChannel.this.additional_data);
                            JChannel.this.down(new Event(56, m));
                        }
                    }
                    catch (Exception ex) {
                        if (JChannel.this.log.isErrorEnabled()) {
                            JChannel.this.log.error((Object)("failure reopening channel: " + ex));
                        }
                        JChannel.this.closer = null;
                        return;
                    }
                    while (!JChannel.this.connected) {
                        try {
                            JChannel.this.connect(old_cluster_name);
                            JChannel.this.notifyChannelReconnected(JChannel.this.local_addr);
                        }
                        catch (Exception ex) {
                            if (JChannel.this.log.isErrorEnabled()) {
                                JChannel.this.log.error((Object)"failure reconnecting to channel, retrying", (Throwable)ex);
                            }
                            Util.sleep(1000L);
                        }
                    }
                }
                if (JChannel.this.auto_getstate) {
                    if (JChannel.this.log.isDebugEnabled()) {
                        JChannel.this.log.debug((Object)"fetching the state (auto_getstate=true)");
                    }
                    boolean rc = JChannel.this.getState(null, 5000L);
                    if (JChannel.this.log.isDebugEnabled()) {
                        if (rc) {
                            JChannel.this.log.debug((Object)"state was retrieved successfully");
                        } else {
                            JChannel.this.log.debug((Object)"state transfer failed");
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (JChannel.this.log.isErrorEnabled()) {
                    JChannel.this.log.error((Object)("exception: " + ex));
                }
            }
            finally {
                JChannel.this.closer = null;
            }
        }
    }
}

