/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Properties;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class JGroupsLatencyTest {
    JChannel ch;

    private void start(boolean sender, boolean local, String props) throws Exception {
        if (local) {
            JChannel ch1 = new JChannel(props);
            ch1.connect("x");
            JChannel ch2 = new JChannel(props);
            ch2.setReceiver(new MyReceiver());
            ch2.connect("x");
            for (int i = 0; i < 10; ++i) {
                ch1.send(new Message(null, null, Long.valueOf(System.currentTimeMillis())));
                Util.sleep(1000L);
            }
            ch2.close();
            ch1.close();
            return;
        }
        if (sender) {
            this.ch = new JChannel(props);
            JGroupsLatencyTest.disableBundling(this.ch);
            this.ch.connect("x");
            for (int i = 0; i < 10; ++i) {
                this.ch.send(new Message(null, null, Long.valueOf(System.currentTimeMillis())));
                Util.sleep(1000L);
            }
        } else {
            this.ch = new JChannel(props);
            JGroupsLatencyTest.disableBundling(this.ch);
            this.ch.setReceiver(new MyReceiver());
            this.ch.connect("x");
            System.out.println("receiver ready");
            while (true) {
                Util.sleep(10000L);
            }
        }
        this.ch.close();
    }

    private static void disableBundling(JChannel ch) {
        System.out.println("Disabling message bundling (as this would increase latency)");
        ProtocolStack stack = ch.getProtocolStack();
        Protocol transport = stack.getTransport();
        Properties props = new Properties();
        props.setProperty("enable_bundling", "false");
        transport.setProperties(props);
    }

    public static void main(String[] args) throws Exception {
        boolean sender = false;
        boolean local = false;
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-sender")) {
                sender = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-local")) {
                local = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-props")) {
                props = args[++i];
                continue;
            }
            JGroupsLatencyTest.help();
            return;
        }
        new JGroupsLatencyTest().start(sender, local, props);
    }

    private static void help() {
        System.out.println("JGroupsLatencyTest [-sender] [-local] [-props <properties>]");
    }

    static class MyReceiver
    extends ReceiverAdapter {
        MyReceiver() {
        }

        public void receive(Message msg) {
            Long timestamp = (Long)msg.getObject();
            System.out.println("time for message: " + (System.currentTimeMillis() - timestamp) + " ms");
        }
    }
}

