/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Map;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnversionedNode;
import org.jboss.cache.VersionedNode;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.optimistic.WorkspaceNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFactory<K, V> {
    private CacheSPI<K, V> cache;
    private boolean optimistic;

    public NodeFactory(CacheSPI<K, V> cache) {
        this.cache = cache;
        this.init();
    }

    public void init() {
        this.optimistic = this.cache.getConfiguration().isNodeLockingOptimistic();
    }

    public NodeSPI<K, V> createDataNode(Object childName, Fqn fqn, NodeSPI<K, V> parent, Map<K, V> data, boolean mapSafe) {
        UnversionedNode n = this.optimistic ? new VersionedNode<K, V>(fqn, parent, data, this.cache) : new UnversionedNode<K, V>(childName, fqn, data, mapSafe, this.cache);
        n.setDataLoaded(false);
        return n;
    }

    public Node<K, V> createNode(Object childName, Node<K, V> parent, Map<K, V> data) {
        return this.createNodeOfType(parent, childName, parent, data);
    }

    public Node<K, V> createNodeOfType(Node<K, V> template, Object childName, Node<K, V> parent, Map<K, V> data) {
        if (template instanceof WorkspaceNode) {
            NodeSPI dataNodeParent = ((WorkspaceNode)parent).getNode();
            TransactionWorkspace workspace = ((WorkspaceNode)template).getTransactionWorkspace();
            return this.createWorkspaceNode(dataNodeParent, workspace);
        }
        return this.createDataNode(childName, new Fqn<Object>(parent.getFqn(), childName), (NodeSPI)parent, data, false);
    }

    public WorkspaceNode<K, V> createWorkspaceNode(NodeSPI<K, V> dataNode, TransactionWorkspace workspace) {
        return new WorkspaceNodeImpl<K, V>(dataNode, workspace);
    }

    public NodeSPI<K, V> createRootDataNode() {
        return this.createDataNode(null, Fqn.ROOT, null, null, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        UNVERSIONED_NODE,
        VERSIONED_NODE,
        WORKSPACE_NODE;

    }
}

