/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.registry;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheConfigsXmlParser {
    public static final String DOCUMENT_ROOT = "cache-configs";
    public static final String CONFIG_ROOT = "cache-config";
    public static final String CONFIG_NAME = "name";
    private static final Log log = LogFactory.getLog(CacheConfigsXmlParser.class);
    private final XmlConfigurationParser parser = new XmlConfigurationParser();

    public Map<String, Configuration> parseConfigs(String fileName) throws CloneNotSupportedException {
        InputStream is = this.getAsInputStreamFromClassLoader(fileName);
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to find configuration file " + fileName + " in classpath; searching for this file on the filesystem instead."));
            }
            try {
                is = new FileInputStream(fileName);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("Unable to find config file " + fileName + " either in classpath or on the filesystem!", e);
            }
        }
        return this.parseConfigs(is);
    }

    public Map<String, Configuration> parseConfigs(InputStream stream) throws CloneNotSupportedException {
        Element root = XmlHelper.getDocumentRoot(stream);
        NodeList list = root.getElementsByTagName(CONFIG_ROOT);
        if (list == null || list.getLength() == 0) {
            throw new ConfigurationException("Can't find cache-config tag");
        }
        HashMap<String, Configuration> result = new HashMap<String, Configuration>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String name = element.getAttribute(CONFIG_NAME);
            if (name == null || name.trim().length() == 0) {
                throw new ConfigurationException("Element " + element + " has no name attribute");
            }
            Configuration c = this.parser.parseConfiguration(element);
            c = c.clone();
            result.put(name.trim(), c);
        }
        return result;
    }

    protected InputStream getAsInputStreamFromClassLoader(String filename) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(filename);
        }
        return is;
    }
}

