/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.interceptors;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.util.AopUtil;

/**
 * Interceptor (done via aop advice) to check the validity of the id specified by the user.
 *
 * @version $Id: CheckNonSerializableInterceptor.java 3892 2007-05-23 10:28:59Z msurtani $
 */
public class CheckNonSerializableInterceptor extends AbstractInterceptor
{
   private boolean marshallNonSerializable_ = false;

   public Object invoke(Invocation in) throws Throwable
   {
      if (!(in instanceof MethodInvocation))
      {
         throw new IllegalArgumentException("CheckIdInterceptor.invoke(): invocation not MethodInvocation");
      }

      MethodInvocation invocation = (MethodInvocation) in;
      Fqn id = (Fqn) invocation.getArguments()[0];
      Object obj = invocation.getArguments()[1];
      if (!marshallNonSerializable_)
      {
         AopUtil.checkObjectType(obj);
      }
      else
      {
         log.debug("invoke(): marshallNonSerializable is set to true. We will skip object type checking for id:"
                   + id.toString());
      }

      try
      {
         return invocation.invokeNext(); // proceed to next advice or actual call
      }
      finally
      {
      }
   }

   public void setMarshallNonSerializable(boolean isTrue)
   {
      marshallNonSerializable_ = isTrue;
   }
}
