/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.interceptors;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.SimpleMetaData;

/**
 * The first interceptor that deals initialization.
 *
 * @author Ben Wang
 * @version $Id: PojoBeginInterceptor.java 4163 2007-07-18 03:01:49Z jgreene $
 */
public class PojoBeginInterceptor extends AbstractInterceptor
{
   public Object invoke(Invocation in) throws Throwable
   {
      if (!(in instanceof MethodInvocation))
      {
         throw new IllegalArgumentException("BeginInterceptor.invoke(): invocation not MethodInvocation");
      }
      MethodInvocation invocation = (MethodInvocation) in;
      // Let's initialize the metadata
      SimpleMetaData simple = new SimpleMetaData();
      invocation.setMetaData(simple);

      try
      {
         log.debug("**** Entering method: **** " + invocation.getMethod());
         return invocation.invokeNext(); // proceed to next advice or actual call
      }
      finally
      {
//         reset(); // reset
         log.debug("Leaving method: " + invocation.getMethod());
      }
   }
}
