/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import javax.transaction.NotSupportedException;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.event.Event;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackTest {
    CacheImpl<Object, Object> cache = null;
    CacheImpl<Object, Object> cache2;
    final Fqn<String> FQN_A = Fqn.fromString((String)"/a");
    final Fqn<String> FQN_B = Fqn.fromString((String)"/b");
    static final String KEY = "key";
    static final String VALUE = "value";

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
    }

    @Test(groups={"functional"})
    public void testLocalPutCallbackWithoutTransaction() throws Exception, NotSupportedException {
        this.cache = this.createCache(Configuration.CacheMode.LOCAL, IsolationLevel.SERIALIZABLE);
        this.cache.addCacheListener((Object)new PutListener(this.cache));
        this.cache.put(this.FQN_A, null);
        AssertJUnit.assertTrue((boolean)this.cache.exists(this.FQN_A));
        AssertJUnit.assertTrue((boolean)this.cache.exists(this.FQN_B));
        AssertJUnit.assertEquals((int)this.cache.getLockTable().size(), (int)0);
        System.out.println("cache locks:\n" + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    @Test(groups={"functional"})
    public void testLocalGetCallbackSameFqnWithoutTransaction() throws Exception, NotSupportedException {
        this.cache = this.createCache(Configuration.CacheMode.LOCAL, IsolationLevel.SERIALIZABLE);
        this.cache.getNotifier().addCacheListener((Object)new GetListener(this.cache, this.FQN_A));
        this.cache.put(this.FQN_A, null);
        AssertJUnit.assertTrue((boolean)this.cache.exists(this.FQN_A));
        AssertJUnit.assertEquals((int)this.cache.getLockTable().size(), (int)0);
        System.out.println("cache locks:\n" + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    @Test(groups={"functional"})
    public void testLocalGetCallbackDifferentFqnWithoutTransaction() throws Exception, NotSupportedException {
        this.cache = this.createCache(Configuration.CacheMode.LOCAL, IsolationLevel.SERIALIZABLE);
        this.cache.put(this.FQN_B, null);
        this.cache.getNotifier().addCacheListener((Object)new GetListener(this.cache, this.FQN_B));
        this.cache.put("/a", null);
        AssertJUnit.assertTrue((boolean)this.cache.exists(this.FQN_A));
        AssertJUnit.assertTrue((boolean)this.cache.exists(this.FQN_B));
        AssertJUnit.assertEquals((int)this.cache.getLockTable().size(), (int)0);
        System.out.println("cache locks:\n" + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    @Test(groups={"functional"})
    public void testLocalCallbackWithTransaction() throws Exception, NotSupportedException {
        this.cache = this.createCache(Configuration.CacheMode.LOCAL, IsolationLevel.SERIALIZABLE);
        this.cache.getNotifier().addCacheListener((Object)new PutListener(this.cache));
        TransactionManager tm = this.startTransaction();
        this.cache.put(this.FQN_A, null);
        tm.commit();
        AssertJUnit.assertTrue((boolean)this.cache.exists(this.FQN_A));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    @Test(groups={"functional"})
    public void testLocalCallbackWithException() throws Exception, NotSupportedException {
        this.cache = this.createCache(Configuration.CacheMode.LOCAL, IsolationLevel.SERIALIZABLE);
        this.cache.getNotifier().addCacheListener((Object)new ExceptionListener());
        TransactionManager tm = this.startTransaction();
        try {
            this.cache.put(this.FQN_A, null);
            tm.rollback();
        }
        catch (RuntimeException ex) {
            tm.rollback();
        }
        AssertJUnit.assertFalse((boolean)this.cache.exists(this.FQN_A));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    private CacheImpl<Object, Object> createCache(Configuration.CacheMode mode, IsolationLevel level) throws Exception {
        Configuration c = new Configuration();
        c.setCacheMode(mode);
        c.setIsolationLevel(level);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        return (CacheImpl)DefaultCacheFactory.getInstance().createCache(c);
    }

    private TransactionManager startTransaction() {
        TransactionManager mgr = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        try {
            mgr.begin();
            return mgr;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @CacheListener
    public class PutListener {
        CacheImpl<Object, Object> c;

        public PutListener(CacheImpl<Object, Object> c) {
            this.c = c;
        }

        @NodeCreated
        public void nodeCreated(Event e) {
            if (!e.isPre()) {
                try {
                    if (!this.c.exists(CallbackTest.this.FQN_B)) {
                        System.out.println("PutListener: creating node " + CallbackTest.this.FQN_B);
                        this.c.put(CallbackTest.this.FQN_B, (Object)CallbackTest.KEY, (Object)CallbackTest.VALUE);
                        System.out.println("PutListener: created node " + CallbackTest.this.FQN_B);
                    }
                }
                catch (CacheException ex) {
                    AssertJUnit.fail((String)("listener was unable to update cache during callback: " + (Object)((Object)ex)));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @CacheListener
    public class GetListener {
        CacheImpl<Object, Object> c;
        Fqn<?> my_fqn;

        public GetListener(CacheImpl<Object, Object> c, Fqn<?> my_fqn) {
            this.c = c;
            this.my_fqn = my_fqn;
        }

        @NodeCreated
        public void nodeCreated(Event e) {
            if (!e.isPre()) {
                try {
                    Node n = this.c.get(this.my_fqn);
                    AssertJUnit.assertNotNull((Object)n);
                }
                catch (CacheException ex) {
                    AssertJUnit.fail((String)("listener was unable to do a get(" + this.my_fqn + ") during callback: " + (Object)((Object)ex)));
                }
            }
        }
    }

    @CacheListener
    public class ExceptionListener {
        @NodeCreated
        public void nodeCreated(Event e) {
            if (e.isPre()) {
                throw new RuntimeException("this will cause the TX to rollback");
            }
        }
    }
}

