/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.transaction.GenericTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheAPITest {
    private Cache<String, String> cache;
    protected boolean optimistic;
    final List<String> events = new ArrayList<String>();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheFactory cf = DefaultCacheFactory.getInstance();
        this.cache = cf.createCache("META-INF/local-tx-service.xml", false);
        this.cache.getConfiguration().setNodeLockingScheme(this.optimistic ? Configuration.NodeLockingScheme.OPTIMISTIC : Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.start();
        this.events.clear();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
        }
    }

    public void testConfiguration() {
        Configuration c = this.cache.getConfiguration();
        AssertJUnit.assertEquals((Object)Configuration.CacheMode.LOCAL, (Object)c.getCacheMode());
        AssertJUnit.assertEquals((String)GenericTransactionManagerLookup.class.getName(), (String)c.getTransactionManagerLookupClass());
        try {
            c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
            AssertJUnit.fail((String)"Should have thrown an Exception");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        c.setLockAcquisitionTimeout(100L);
    }

    public void testCacheListeners() {
        AssertJUnit.assertEquals((int)0, (int)this.cache.getCacheListeners().size());
        Listener dummy = new Listener();
        this.cache.addCacheListener((Object)dummy);
        AssertJUnit.assertEquals((int)1, (int)this.cache.getCacheListeners().size());
        this.cache.getRoot().addChild(Fqn.fromString((String)"/blah"));
        AssertJUnit.assertEquals((int)1, (int)this.events.size());
        this.cache.removeCacheListener((Object)dummy);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getCacheListeners().size());
    }

    public void testFqnBasedCacheListeners() {
        try {
            this.cache.getCacheListeners(Fqn.ROOT);
            AssertJUnit.fail((String)"Fqn-based cache listener operation should throw an exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.cache.addCacheListener(Fqn.ROOT, (Object)new Listener());
            AssertJUnit.fail((String)"Fqn-based cache listener operation should throw an exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.cache.removeCacheListener(Fqn.ROOT, (Object)new Listener());
            AssertJUnit.fail((String)"Fqn-based cache listener operation should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConvenienceMethods() {
        Fqn fqn = Fqn.fromString((String)"/test/fqn");
        String key = "key";
        String value = "value";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)key));
        this.cache.put(fqn, (Object)key, (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.get(fqn, (Object)key)));
        this.cache.remove(fqn, (Object)key);
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)key));
        this.cache.put(fqn, data);
        System.out.println(((CacheImpl)this.cache).printDetails());
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.get(fqn, (Object)key)));
    }

    public void testNodeConvenienceNodeRemoval() {
        Fqn fqn = Fqn.fromString((String)"/test/fqn");
        this.cache.getRoot().addChild(fqn);
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache.removeNode(fqn));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)false, (boolean)this.cache.removeNode(fqn));
        Fqn child = Fqn.fromString((String)"/test/fqn/child");
        this.cache.getRoot().addChild(child);
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(child));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache.removeNode(fqn));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)false, (boolean)this.cache.removeNode(fqn));
    }

    public void testEvict() {
        Fqn one = Fqn.fromString((String)"/one");
        Fqn two = Fqn.fromString((String)"/one/two");
        String key = "key";
        String value = "value";
        this.cache.getRoot().addChild(one).put((Object)key, (Object)value);
        this.cache.getRoot().addChild(two).put((Object)key, (Object)value);
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(one));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().getChild(one).getData().isEmpty());
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(two));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().getChild(two).getData().isEmpty());
        this.cache.evict(two, false);
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(one));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().getChild(one).getKeys().contains(key));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(two));
        this.cache.getRoot().addChild(two).put((Object)key, (Object)value);
        this.cache.evict(one, false);
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(one));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().getChild(one).getKeys().contains(key));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(two));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().getChild(two).getKeys().contains(key));
    }

    public void testEvictRecursive() {
        Fqn one = Fqn.fromString((String)"/one");
        Fqn two = Fqn.fromString((String)"/one/two");
        String key = "key";
        String value = "value";
        this.cache.getRoot().addChild(one).put((Object)key, (Object)value);
        this.cache.getRoot().addChild(two).put((Object)key, (Object)value);
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(one));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().getChild(one).getData().isEmpty());
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(two));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().getChild(two).getData().isEmpty());
        this.cache.evict(two, true);
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(one));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().getChild(one).getData().isEmpty());
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(two));
        this.cache.getRoot().addChild(two).put((Object)key, (Object)value);
        this.cache.evict(one, true);
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(one));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(two));
    }

    public void testRegion() {
        Region rootRegion = this.cache.getRegion(Fqn.ROOT, true);
        AssertJUnit.assertNotNull((Object)rootRegion);
        AssertJUnit.assertSame((Object)rootRegion, (Object)this.cache.getRegion(Fqn.ROOT, true));
        Region otherRegion = this.cache.getRegion(Fqn.fromString((String)"/other/region"), true);
        AssertJUnit.assertNotNull((Object)otherRegion);
        AssertJUnit.assertSame((Object)otherRegion, (Object)this.cache.getRegion(Fqn.fromString((String)"/other/region"), true));
    }

    public void testParentRegion1() {
        Region rootRegion = this.cache.getRegion(Fqn.ROOT, true);
        AssertJUnit.assertNotNull((Object)rootRegion);
        AssertJUnit.assertSame((Object)rootRegion, (Object)this.cache.getRegion(Fqn.ROOT, false));
        Region otherRegion = this.cache.getRegion(Fqn.fromString((String)"/other/region"), false);
        AssertJUnit.assertSame((Object)otherRegion, (Object)rootRegion);
    }

    public void testParentRegion2() {
        Region rootRegion = this.cache.getRegion(Fqn.ROOT, true);
        Region parentRegion = this.cache.getRegion(Fqn.fromString((String)"/parent"), true);
        AssertJUnit.assertNotSame((String)"parentRegion should be a new region in its own right", (Object)rootRegion, (Object)parentRegion);
        Region childRegion = this.cache.getRegion(Fqn.fromString((String)"/parent/region"), false);
        AssertJUnit.assertSame((String)"Expecting the same region as parentRegion", (Object)childRegion, (Object)parentRegion);
    }

    public void testNullRegion() {
        Region myRegion = this.cache.getRegion(Fqn.fromString((String)"/myregion"), true);
        AssertJUnit.assertNotNull((Object)myRegion);
        AssertJUnit.assertSame((Object)myRegion, (Object)this.cache.getRegion(Fqn.fromString((String)"/myregion"), false));
        Region otherRegion = this.cache.getRegion(Fqn.fromString((String)"/other/region"), false);
        AssertJUnit.assertNotNull((Object)otherRegion);
        AssertJUnit.assertEquals((Object)Fqn.ROOT, (Object)otherRegion.getFqn());
    }

    public void testStopClearsData() throws Exception {
        Fqn a = Fqn.fromString((String)"/a");
        Fqn b = Fqn.fromString((String)"/a/b");
        String key = "key";
        String value = "value";
        this.cache.getRoot().addChild(a).put((Object)key, (Object)value);
        this.cache.getRoot().addChild(b).put((Object)key, (Object)value);
        this.cache.getRoot().put((Object)key, (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.getRoot().get((Object)key)));
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.getRoot().getChild(a).get((Object)key)));
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.getRoot().getChild(b).get((Object)key)));
        this.cache.stop();
        this.cache.start();
        AssertJUnit.assertNull((Object)this.cache.getRoot().get((Object)key));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().getData().isEmpty());
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().getChildren().isEmpty());
    }

    @CacheListener
    public class Listener {
        @NodeCreated
        public void nodeCreated(Event e) {
            if (e.isPre()) {
                CacheAPITest.this.events.add("Created");
            }
        }
    }
}

