/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import javax.transaction.TransactionManager;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.testng.AssertJUnit;

public class BuddyReplicationWithTransactionsTest
extends BuddyReplicationTestsBase {
    private Fqn fqn = Fqn.fromString((String)"test");
    private String key = "key";
    private String value = "value";

    public void testTransactionsCommit() throws Exception {
        this.caches = this.createCaches(3, false, true, false);
        ((CacheImpl)this.caches.get(0)).put(this.fqn, (Object)this.key, (Object)this.value);
        Fqn oldBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(0)).getLocalAddress()) + "/test"));
        Fqn newBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(2)).getLocalAddress()) + "/test"));
        this.dumpCacheContents(this.caches);
        TransactionManager txman = ((CacheImpl)this.caches.get(2)).getTransactionManager();
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.begin();
        this.dumpCacheContents(this.caches);
        ((CacheImpl)this.caches.get(2)).get(this.fqn, (Object)this.key);
        this.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(2)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.commit();
        this.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(2)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(0)).exists(newBackupFqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        this.dumpCacheContents(this.caches);
        this.assertNoLocks(this.caches);
    }

    public void testTransactionsRollback() throws Exception {
        this.caches = this.createCaches(3, false, true, false);
        ((CacheImpl)this.caches.get(0)).put(this.fqn, (Object)this.key, (Object)this.value);
        Fqn oldBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(0)).getLocalAddress()) + "/test"));
        Fqn newBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(2)).getLocalAddress()) + "/test"));
        this.dumpCacheContents(this.caches);
        TransactionManager txman = ((CacheImpl)this.caches.get(2)).getTransactionManager();
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.begin();
        this.dumpCacheContents(this.caches);
        ((CacheImpl)this.caches.get(2)).get(this.fqn, (Object)this.key);
        this.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(2)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.rollback();
        this.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheImpl)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheImpl)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        this.assertNoLocks(this.caches);
    }
}

