/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import java.util.LinkedList;
import java.util.List;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.cache.jmx.CacheJmxWrapperTestBase;
import org.testng.AssertJUnit;

public class LifecycleNotificationTest
extends CacheJmxWrapperTestBase {
    public void testGetStateAndStateNotification() throws Exception {
        CacheJmxWrapper<String, String> wrapper = this.createWrapper(this.createConfiguration());
        StateNotificationListener listener = new StateNotificationListener();
        wrapper.addNotificationListener((NotificationListener)listener, null, null);
        AssertJUnit.assertEquals((String)"Correct state after instanitation", (int)7, (int)wrapper.getState());
        this.registerWrapper((CacheJmxWrapperMBean<String, String>)wrapper);
        AssertJUnit.assertEquals((String)"Correct state after registration", (int)8, (int)wrapper.getState());
        wrapper.create();
        AssertJUnit.assertEquals((String)"Correct state after create", (int)6, (int)wrapper.getState());
        wrapper.start();
        AssertJUnit.assertEquals((String)"Correct state after start", (int)3, (int)wrapper.getState());
        wrapper.stop();
        AssertJUnit.assertEquals((String)"Correct state after stop", (int)0, (int)wrapper.getState());
        wrapper.destroy();
        AssertJUnit.assertEquals((String)"Correct state after destroy", (int)5, (int)wrapper.getState());
        this.unregisterWrapper();
        AssertJUnit.assertEquals((String)"Correct state after unregistration", (int)7, (int)wrapper.getState());
        System.out.println(listener.notifications);
        AssertJUnit.assertEquals((String)"Correct number of notifications received", (int)4, (int)listener.notifications.size());
        AssertJUnit.assertEquals((String)"Correct first notification", (Object)new Integer(2), listener.notifications.get(0));
        AssertJUnit.assertEquals((String)"Correct second notification", (Object)new Integer(3), listener.notifications.get(1));
        AssertJUnit.assertEquals((String)"Correct third notification", (Object)new Integer(1), listener.notifications.get(2));
        AssertJUnit.assertEquals((String)"Correct fourth notification", (Object)new Integer(0), listener.notifications.get(3));
    }

    private static class StateNotificationListener
    implements NotificationListener {
        private List<Integer> notifications = new LinkedList<Integer>();

        private StateNotificationListener() {
        }

        public void handleNotification(Notification msg, Object handback) {
            if (msg instanceof AttributeChangeNotification) {
                AttributeChangeNotification change = (AttributeChangeNotification)msg;
                String attrName = change.getAttributeName();
                Object newValue = change.getNewValue();
                if ("State".equals(attrName) && newValue != null && newValue instanceof Integer) {
                    this.notifications.add((Integer)newValue);
                    return;
                }
            }
        }
    }
}

