/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.List;
import java.util.Properties;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.AsyncCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.loader.ChainingCacheLoader;
import org.jboss.cache.loader.FileCacheLoader;
import org.jboss.cache.loader.JDBCCacheLoader;
import org.jboss.cache.loader.SingletonStoreCacheLoader;
import org.jboss.cache.loader.SingletonStoreDefaultConfig;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.w3c.dom.Element;

public class CacheLoaderManagerTest
extends AbstractCacheLoaderTestBase {
    private CacheLoaderConfig createCacheLoaderCfg(boolean passivation) {
        CacheLoaderConfig cfg = new CacheLoaderConfig();
        cfg.setPassivation(passivation);
        return cfg;
    }

    private CacheLoaderConfig.IndividualCacheLoaderConfig createIndividualCacheLoaderConfig(CacheLoaderConfig parent, boolean async, String classname) throws Exception {
        CacheLoaderConfig.IndividualCacheLoaderConfig cfg = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        cfg.setAsync(async);
        cfg.setClassName(classname);
        cfg.setFetchPersistentState(false);
        Properties p = new Properties();
        p.setProperty("location", this.getTempDir());
        p.setProperty("cache.jdbc.driver", "com.mysql.jdbc.Driver");
        p.setProperty("cache.jdbc.url", "jdbc:mysql://localhost/test");
        p.setProperty("cache.jdbc.user", "user");
        p.setProperty("cache.jdbc.password", "pwd");
        cfg.setProperties(p);
        return cfg;
    }

    private String getTempDir() {
        return System.getProperty("java.io.tempdir", "/tmp");
    }

    private static Element strToElement(String s) throws Exception {
        return XmlHelper.stringToElement((String)s);
    }

    public void testSingleCacheLoader() throws Exception {
        CacheLoaderManager mgr = new CacheLoaderManager();
        CacheLoaderConfig cfg = this.createCacheLoaderCfg(false);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.FileCacheLoader"));
        mgr.setConfig(cfg, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(FileCacheLoader.class, cl.getClass());
        cfg = this.createCacheLoaderCfg(false);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader"));
        mgr.setConfig(cfg, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(AsyncCacheLoader.class, cl.getClass());
    }

    public void testSingleCacheLoaderPassivation() throws Exception {
        CacheLoaderConfig cfg = this.createCacheLoaderCfg(true);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.FileCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.bdbje.BdbjeCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.JDBCCacheLoader"));
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(cfg, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(FileCacheLoader.class, cl.getClass());
        cfg = this.createCacheLoaderCfg(true);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.bdbje.BdbjeCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.JDBCCacheLoader"));
        mgr.setConfig(cfg, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(AsyncCacheLoader.class, cl.getClass());
    }

    public void testSingleCacheLoaderFromXml() throws Exception {
        CacheLoaderConfig clc = this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.FileCacheLoader", "location=" + this.getTempDir(), false, false, false);
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(FileCacheLoader.class, cl.getClass());
        clc = this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.FileCacheLoader", "location=" + this.getTempDir(), true, false, false);
        mgr.setConfig(clc, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(AsyncCacheLoader.class, cl.getClass());
    }

    public void testSingleCacheLoaderPassivationFromXml() throws Exception {
        String conf = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><config><passivation>true</passivation><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>false</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "</cacheloader>" + "<cacheloader>" + "    <class>org.jboss.cache.loader.bdbje.BdbjeCacheLoader</class>" + "    <async>false</async>" + "    <fetchPersistentState>false</fetchPersistentState>" + "    <ignoreModifications>false</ignoreModifications>" + "    <properties>" + "        location=" + this.getTempDir() + "    </properties>" + "</cacheloader>" + "<cacheloader>" + "    <class>org.jboss.cache.loader.JDBCCacheLoader</class>" + "    <async>false</async>" + "    <fetchPersistentState>false</fetchPersistentState>" + "    <ignoreModifications>false</ignoreModifications>" + "    <properties>" + "        location=" + this.getTempDir() + "    </properties>" + "</cacheloader></config>";
        CacheLoaderConfig clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(FileCacheLoader.class, cl.getClass());
        conf = "<config><passivation>true</passivation><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>true</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>false</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "</cacheloader>" + "<cacheloader>" + "    <class>org.jboss.cache.loader.bdbje.BdbjeCacheLoader</class>" + "    <async>true</async>" + "    <fetchPersistentState>false</fetchPersistentState>" + "    <ignoreModifications>false</ignoreModifications>" + "    <properties>" + "        location=" + this.getTempDir() + "    </properties>" + "</cacheloader>" + "<cacheloader>" + "    <class>org.jboss.cache.loader.JDBCCacheLoader</class>" + "    <async>true</async>" + "    <fetchPersistentState>false</fetchPersistentState>" + "    <ignoreModifications>false</ignoreModifications>" + "    <properties>" + "        location=" + this.getTempDir() + "    </properties>" + "</cacheloader></config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr.setConfig(clc, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(AsyncCacheLoader.class, cl.getClass());
    }

    public void testChainingCacheLoader() throws Exception {
        CacheLoaderConfig cfg = this.createCacheLoaderCfg(false);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.FileCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.JDBCCacheLoader"));
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(cfg, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(ChainingCacheLoader.class, cl.getClass());
        AssertJUnit.assertEquals((int)2, (int)((ChainingCacheLoader)cl).getSize());
        List loaders = ((ChainingCacheLoader)cl).getCacheLoaders();
        AssertJUnit.assertEquals(FileCacheLoader.class, loaders.get(0).getClass());
        AssertJUnit.assertEquals(JDBCCacheLoader.class, loaders.get(1).getClass());
        cfg = this.createCacheLoaderCfg(false);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.FileCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.JDBCCacheLoader"));
        mgr.setConfig(cfg, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(ChainingCacheLoader.class, cl.getClass());
        AssertJUnit.assertEquals((int)2, (int)((ChainingCacheLoader)cl).getSize());
        loaders = ((ChainingCacheLoader)cl).getCacheLoaders();
        AssertJUnit.assertEquals(FileCacheLoader.class, loaders.get(0).getClass());
        AssertJUnit.assertEquals(AsyncCacheLoader.class, loaders.get(1).getClass());
    }

    public void testChainingCacheLoaderFromXml() throws Exception {
        String conf = "<config><passivation>false</passivation><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>false</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "</cacheloader>" + "<cacheloader>" + "    <class>org.jboss.cache.loader.JDBCCacheLoader</class>" + "    <async>false</async>" + "    <fetchPersistentState>false</fetchPersistentState>" + "    <ignoreModifications>false</ignoreModifications>" + "    <properties>" + "cache.jdbc.driver=com.mysql.jdbc.Driver\ncache.jdbc.url=jdbc:mysql://localhost/test\ncache.jdbc.user=user\ncache.jdbc.password=pwd" + "    </properties>" + "</cacheloader></config>";
        CacheLoaderConfig clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(ChainingCacheLoader.class, cl.getClass());
        AssertJUnit.assertEquals((int)2, (int)((ChainingCacheLoader)cl).getSize());
        List loaders = ((ChainingCacheLoader)cl).getCacheLoaders();
        AssertJUnit.assertEquals(FileCacheLoader.class, loaders.get(0).getClass());
        AssertJUnit.assertEquals(JDBCCacheLoader.class, loaders.get(1).getClass());
        conf = "<config><passivation>false</passivation><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>false</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "</cacheloader>" + "<cacheloader>" + "    <class>org.jboss.cache.loader.JDBCCacheLoader</class>" + "    <async>true</async>" + "    <fetchPersistentState>false</fetchPersistentState>" + "    <ignoreModifications>false</ignoreModifications>" + "    <properties>" + "cache.jdbc.driver=com.mysql.jdbc.Driver\ncache.jdbc.url=jdbc:mysql://localhost/test\ncache.jdbc.user=user\ncache.jdbc.password=pwd" + "    </properties>" + "</cacheloader></config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr.setConfig(clc, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(ChainingCacheLoader.class, cl.getClass());
        AssertJUnit.assertEquals((int)2, (int)((ChainingCacheLoader)cl).getSize());
        loaders = ((ChainingCacheLoader)cl).getCacheLoaders();
        AssertJUnit.assertEquals(FileCacheLoader.class, loaders.get(0).getClass());
        AssertJUnit.assertEquals(AsyncCacheLoader.class, loaders.get(1).getClass());
    }

    public void testMoreThanOneFetchPersistentState() throws Exception {
        CacheLoaderManager mgr = new CacheLoaderManager();
        CacheLoaderConfig cfg = this.createCacheLoaderCfg(false);
        CacheLoaderConfig.IndividualCacheLoaderConfig i = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i.setFetchPersistentState(true);
        CacheLoaderConfig.IndividualCacheLoaderConfig i2 = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i2.setFetchPersistentState(true);
        cfg.addIndividualCacheLoaderConfig(i);
        cfg.addIndividualCacheLoaderConfig(i2);
        AssertJUnit.assertEquals((int)2, (int)cfg.getIndividualCacheLoaderConfigs().size());
        try {
            mgr.setConfig(cfg, null);
            AssertJUnit.assertTrue((String)"Should throw exception since we have > 1 cache loader with fetchPersistentState as true", (boolean)false);
        }
        catch (Exception e) {
            AssertJUnit.assertTrue((boolean)true);
        }
        mgr = new CacheLoaderManager();
        cfg = this.createCacheLoaderCfg(false);
        i = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i.setFetchPersistentState(true);
        cfg.addIndividualCacheLoaderConfig(i);
        AssertJUnit.assertEquals((int)1, (int)cfg.getIndividualCacheLoaderConfigs().size());
        mgr.setConfig(cfg, null);
        mgr = new CacheLoaderManager();
        cfg = this.createCacheLoaderCfg(false);
        i = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i.setFetchPersistentState(true);
        i2 = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i2.setFetchPersistentState(false);
        cfg.addIndividualCacheLoaderConfig(i);
        cfg.addIndividualCacheLoaderConfig(i2);
        AssertJUnit.assertEquals((int)2, (int)cfg.getIndividualCacheLoaderConfigs().size());
        mgr.setConfig(cfg, null);
        mgr = new CacheLoaderManager();
        cfg = this.createCacheLoaderCfg(false);
        i = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i.setFetchPersistentState(false);
        i2 = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i2.setFetchPersistentState(false);
        cfg.addIndividualCacheLoaderConfig(i);
        cfg.addIndividualCacheLoaderConfig(i2);
        AssertJUnit.assertEquals((int)2, (int)cfg.getIndividualCacheLoaderConfigs().size());
        mgr.setConfig(cfg, null);
    }

    public void testConfigurationParsing() throws Exception {
        String conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "</cacheloader>" + "<cacheloader>" + "    <class>org.jboss.cache.loader.JDBCCacheLoader</class>" + "    <async>true</async>" + "    <fetchPersistentState>true</fetchPersistentState>" + "    <ignoreModifications>false</ignoreModifications>" + "    <properties>" + "cache.jdbc.driver=com.mysql.jdbc.Driver\ncache.jdbc.url=jdbc:mysql://localhost/test\ncache.jdbc.user=user\ncache.jdbc.password=pwd" + "    </properties>" + "</cacheloader></config>";
        CacheLoaderConfig clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null);
        AssertJUnit.assertEquals(ChainingCacheLoader.class, mgr.getCacheLoader().getClass());
        AssertJUnit.assertTrue((String)"Should be true", (boolean)mgr.isFetchPersistentState());
        AssertJUnit.assertTrue((String)"Passivation shuld be false", (!mgr.isPassivation() ? 1 : 0) != 0);
        CacheLoaderConfig c = mgr.getCacheLoaderConfig();
        AssertJUnit.assertTrue((String)"Should be using a chaining cache loader", (boolean)c.useChainingCacheLoader());
        AssertJUnit.assertEquals((String)"/, /blah, /blah2", (String)c.getPreload());
        AssertJUnit.assertEquals((int)2, (int)c.getIndividualCacheLoaderConfigs().size());
        CacheLoaderConfig.IndividualCacheLoaderConfig icfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)c.getIndividualCacheLoaderConfigs().get(0);
        AssertJUnit.assertEquals((String)"org.jboss.cache.loader.FileCacheLoader", (String)icfg.getClassName());
        AssertJUnit.assertTrue((String)"Async shld be false", (!icfg.isAsync() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"fetchPersistentState shld be false", (!icfg.isFetchPersistentState() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"IgnoreMods should be true", (boolean)icfg.isIgnoreModifications());
        AssertJUnit.assertEquals((int)1, (int)icfg.getProperties().size());
        icfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)c.getIndividualCacheLoaderConfigs().get(1);
        AssertJUnit.assertEquals((String)"org.jboss.cache.loader.JDBCCacheLoader", (String)icfg.getClassName());
        AssertJUnit.assertTrue((String)"Async shld be true", (boolean)icfg.isAsync());
        AssertJUnit.assertTrue((String)"fetchPersistentState shld be true", (boolean)icfg.isFetchPersistentState());
        AssertJUnit.assertTrue((String)"IgnoreMods should be false", (!icfg.isIgnoreModifications() ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)4, (int)icfg.getProperties().size());
        conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "</cacheloader>" + "<cacheloader>" + "    <class>org.jboss.cache.loader.JDBCCacheLoader</class>" + "    <async>true</async>" + "    <fetchPersistentState>false</fetchPersistentState>" + "    <ignoreModifications>false</ignoreModifications>" + "    <properties>" + "cache.jdbc.driver=com.mysql.jdbc.Driver\ncache.jdbc.url=jdbc:mysql://localhost/test\ncache.jdbc.user=user\ncache.jdbc.password=pwd" + "    </properties>" + "</cacheloader></config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null);
        AssertJUnit.assertTrue((String)"Should be false", (!mgr.isFetchPersistentState() ? 1 : 0) != 0);
    }

    public void testSingletonConfiguration() throws Exception {
        String conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "</cacheloader>" + "</config>";
        CacheLoaderConfig clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null);
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNull((String)"Singleton has not been configured", (Object)iclc.getSingletonStoreConfig());
        conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "    <singletonStore>" + "       <enabled>false</enabled>" + "    </singletonStore>" + "</cacheloader>" + "</config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new MockCacheLoaderManager();
        mgr.setConfig(clc, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertFalse((String)"Singleton is not enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "    <singletonStore>" + "       <enabled>true</enabled>" + "    </singletonStore>" + "</cacheloader>" + "</config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new MockCacheLoaderManager();
        mgr.setConfig(clc, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertTrue((String)"Singleton should enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"Singleton class should be default", (String)SingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertNotNull((String)"Singleton properties should be not null", (Object)iclc.getSingletonStoreConfig().getSingletonStoreproperties());
        AssertJUnit.assertTrue((String)"Singleton properties should be empty", (boolean)iclc.getSingletonStoreConfig().getSingletonStoreproperties().keySet().isEmpty());
        SingletonStoreDefaultConfig ssdc = ((SingletonStoreCacheLoader)mgr.getCacheLoader()).getSingletonStoreDefaultConfig();
        AssertJUnit.assertTrue((String)"Singleton pushStateWhenCoordinator should be true (default)", (boolean)ssdc.isPushStateWhenCoordinator());
        AssertJUnit.assertEquals((String)"Singleton pushStateWhenCoordinatorTimeout should be default value", (int)20000, (int)ssdc.getPushStateWhenCoordinatorTimeout());
        conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "    <singletonStore>" + "       <enabled>true</enabled>" + "       <class>org.jboss.cache.loader.CacheLoaderManagerTest$MockSingletonStoreCacheLoader</class>" + "    </singletonStore>" + "</cacheloader>" + "</config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertTrue((String)"Singleton should enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"Singleton class should be a user defined one", (String)MockSingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertNotNull((String)"Singleton properties should be not null", (Object)iclc.getSingletonStoreConfig().getSingletonStoreproperties());
        AssertJUnit.assertTrue((String)"Singleton properties should be empty", (boolean)iclc.getSingletonStoreConfig().getSingletonStoreproperties().keySet().isEmpty());
        AssertJUnit.assertTrue((boolean)(mgr.getCacheLoader() instanceof MockSingletonStoreCacheLoader));
        conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "    <singletonStore>" + "       <enabled>false</enabled>" + "       <class>org.jboss.cache.loader.FileCacheLoader</class>" + "    </singletonStore>" + "</cacheloader>" + "</config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertFalse((String)"Singleton is not enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "    <singletonStore>" + "       <enabled>true</enabled>" + "       <properties></properties>" + "    </singletonStore>" + "</cacheloader>" + "</config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new MockCacheLoaderManager();
        mgr.setConfig(clc, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertTrue((String)"Singleton should enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"Singleton class should be default", (String)SingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertNotNull((String)"Singleton properties should be defined, but empty", (Object)iclc.getSingletonStoreConfig().getSingletonStoreproperties());
        ssdc = ((SingletonStoreCacheLoader)mgr.getCacheLoader()).getSingletonStoreDefaultConfig();
        AssertJUnit.assertTrue((String)"Singleton pushStateWhenCoordinator should be true", (boolean)ssdc.isPushStateWhenCoordinator());
        conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "    <singletonStore>" + "       <enabled>true</enabled>" + "       <properties>" + "          pushStateWhenCoordinator = false" + "       </properties>" + "    </singletonStore>" + "</cacheloader>" + "</config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new MockCacheLoaderManager();
        mgr.setConfig(clc, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertTrue((String)"Singleton should enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"Singleton class should be default", (String)SingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertNotNull((String)"Singleton properties should be defined", (Object)iclc.getSingletonStoreConfig().getSingletonStoreproperties());
        ssdc = ((SingletonStoreCacheLoader)mgr.getCacheLoader()).getSingletonStoreDefaultConfig();
        AssertJUnit.assertFalse((String)"Singleton pushStateWhenCoordinator should be false", (boolean)ssdc.isPushStateWhenCoordinator());
        conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "    <singletonStore>" + "       <enabled>true</enabled>" + "       <properties>" + "          pushStateWhenCoordinator = true\n" + "          pushStateWhenCoordinatorTimeout = 5000\n" + "       </properties>" + "    </singletonStore>" + "</cacheloader>" + "</config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new MockCacheLoaderManager();
        mgr.setConfig(clc, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertTrue((String)"Singleton should enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"Singleton class should be default", (String)SingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertNotNull((String)"Singleton properties should not be defined", (Object)iclc.getSingletonStoreConfig().getSingletonStoreproperties());
        ssdc = ((SingletonStoreCacheLoader)mgr.getCacheLoader()).getSingletonStoreDefaultConfig();
        AssertJUnit.assertTrue((String)"Singleton pushStateWhenCoordinator should be true", (boolean)ssdc.isPushStateWhenCoordinator());
        AssertJUnit.assertEquals((String)"Singleton pushStateWhenCoordinatorTimeout should be default value", (int)5000, (int)ssdc.getPushStateWhenCoordinatorTimeout());
        conf = "<config><passivation>false</passivation><shared>true</shared><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "    <singletonStore>" + "       <enabled>true</enabled>" + "    </singletonStore>" + "</cacheloader>" + "</config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        try {
            mgr.setConfig(clc, null);
            AssertJUnit.fail((String)"A cache loader cannot be configured as singleton and shared, should have thrown an Exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        conf = "<config><passivation>false</passivation><preload>/, /blah, /blah2</preload><cacheloader>    <class>org.jboss.cache.loader.FileCacheLoader</class>    <async>false</async>    <fetchPersistentState>false</fetchPersistentState>    <ignoreModifications>true</ignoreModifications>    <properties>        location=" + this.getTempDir() + "    </properties>" + "    <singletonStore>" + "       <enabled>true</enabled>" + "       <class>org.jboss.cache.loader.DummyInMemoryCacheLoader</class>" + "    </singletonStore>" + "</cacheloader>" + "</config>";
        clc = XmlConfigurationParser.parseCacheLoaderConfig((Element)CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        try {
            mgr.setConfig(clc, null);
            AssertJUnit.fail((String)"A singleton store class implementation must extend AbstractDelegatingCacheLoader");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static class MockSingletonStoreCacheLoader
    extends AbstractDelegatingCacheLoader {
        public MockSingletonStoreCacheLoader() {
            super(null);
        }
    }

    private class MockCacheLoaderManager
    extends CacheLoaderManager {
        private MockCacheLoaderManager() {
        }

        protected void setCacheInLoader(CacheSPI c, CacheLoader loader) {
        }
    }
}

