/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.apache.derby.jdbc.EmbeddedXADataSource;
import org.jboss.cache.Fqn;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class JDBCCacheLoaderDerbyDSTest
extends CacheLoaderTestsBase {
    private String old_factory = null;
    private final String FACTORY = "org.jboss.cache.transaction.DummyContextFactory";
    private final String JNDI_NAME = "java:/DerbyDS";

    protected void configureCache() throws Exception {
        this.old_factory = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", "org.jboss.cache.transaction.DummyContextFactory");
        DummyTransactionManager.getInstance();
        InitialContext context = new InitialContext();
        try {
            Object obj = context.lookup("java:/DerbyDS");
            AssertJUnit.assertNull((String)"java:/DerbyDS not bound", (Object)obj);
        }
        catch (NameNotFoundException n) {
            // empty catch block
        }
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getClassLoader().getResourceAsStream("cache-jdbc.properties"));
        }
        catch (Exception e) {
            System.out.println("Error loading jdbc properties ");
        }
        EmbeddedXADataSource ds = new EmbeddedXADataSource();
        ds.setDatabaseName("jbossdb");
        ds.setCreateDatabase("create");
        ds.setUser(prop.getProperty("cache.jdbc.user"));
        ds.setPassword(prop.getProperty("cache.jdbc.password"));
        String props = "cache.jdbc.datasource =java:/DerbyDS\ncache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" + "cache.jdbc.sql-concat= 1 || 2";
        this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", props, false, true, false));
        this.cache.create();
        context.bind("java:/DerbyDS", (Object)ds);
        AssertJUnit.assertNotNull((String)"java:/DerbyDS bound", (Object)context.lookup("java:/DerbyDS"));
    }

    public void testLargeObject() {
        try {
            String key = "LargeObj";
            StringBuffer text = new StringBuffer("LargeObject");
            while (text.toString().getBytes().length < 102400) {
                text.append(text);
            }
            String initialValue = text.toString();
            this.loader.remove(Fqn.fromString((String)"/"));
            Object retVal = this.loader.put(FQN, (Object)key, (Object)initialValue);
            AssertJUnit.assertNull((Object)retVal);
            this.addDelay();
            AssertJUnit.assertEquals((String)initialValue, (String)((String)this.loader.get(FQN).get(key)));
            String updatedValue = initialValue.concat("UpdatedValue");
            retVal = this.loader.put(FQN, (Object)key, (Object)updatedValue);
            AssertJUnit.assertEquals((String)initialValue, (String)((String)retVal));
            AssertJUnit.assertEquals((String)updatedValue, (String)((String)this.loader.get(FQN).get(key)));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testTransactionRollback() throws Exception {
    }

    public void testIntegratedTransactionRollback() throws Exception {
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
        InitialContext ctx = new InitialContext();
        ctx.unbind("java:/DerbyDS");
        if (this.old_factory != null) {
            System.setProperty("java.naming.factory.initial", this.old_factory);
        } else {
            System.getProperties().remove("java.naming.factory.initial");
        }
    }
}

