/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class UnnecessaryLoadingTest {
    private CacheSPI<Object, Object> cache;
    private Fqn parent = Fqn.fromString((String)"/parent");
    private Fqn child = Fqn.fromString((String)"/parent/child");
    private String k = "k";
    private String v = "v";
    private CacheLoader mockCacheLoader;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cache = (CacheSPI)DefaultCacheFactory.getInstance().createCache(false);
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(DummyInMemoryCacheLoader.class.getName());
        clc.addIndividualCacheLoaderConfig(iclc);
        this.cache.getConfiguration().setCacheLoaderConfig(clc);
        this.cache.start();
        this.mockCacheLoader = (CacheLoader)EasyMock.createMock(CacheLoader.class);
        this.cache.getCacheLoaderManager().setCacheLoader(this.mockCacheLoader);
        InterceptorChainFactory.getInstance().initialiseInterceptors((Interceptor)this.cache.getInterceptorChain().get(0), this.cache);
        this.mockCacheLoader.stop();
        EasyMock.expectLastCall().times(0, 1);
        this.mockCacheLoader.destroy();
        EasyMock.expectLastCall().times(0, 1);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cache.stop();
    }

    protected void assertDataLoaded(Fqn f) {
        AssertJUnit.assertTrue((String)("Data should be loaded for node " + f), (boolean)this.cache.peek(f, false).isDataLoaded());
    }

    protected void assertDataNotLoaded(Fqn f) {
        AssertJUnit.assertFalse((String)("Data should not be loaded for node " + f), (boolean)this.cache.peek(f, false).isDataLoaded());
    }

    public void testNoLoading() throws Exception {
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.child), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.child))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mockCacheLoader});
        this.cache.put(this.parent, (Object)this.k, (Object)this.v);
        this.cache.put(this.child, (Object)this.k, (Object)this.v);
        EasyMock.verify((Object[])new Object[]{this.mockCacheLoader});
    }

    public void testLoadChild() throws Exception {
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.child), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.child))).andReturn(null).times(2);
        EasyMock.replay((Object[])new Object[]{this.mockCacheLoader});
        this.cache.put(this.parent, (Object)this.k, (Object)this.v);
        this.cache.put(this.child, (Object)this.k, (Object)this.v);
        this.cache.evict(this.child, false);
        this.cache.get(this.child, (Object)this.k);
        EasyMock.verify((Object[])new Object[]{this.mockCacheLoader});
    }

    public void testDontLoadChild() throws Exception {
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.child), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.child))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mockCacheLoader});
        this.cache.put(this.parent, (Object)this.k, (Object)this.v);
        this.cache.put(this.child, (Object)this.k, (Object)this.v);
        this.assertDataLoaded(this.parent);
        this.assertDataLoaded(this.child);
        this.cache.evict(this.parent, false);
        this.assertDataNotLoaded(this.parent);
        this.assertDataLoaded(this.child);
        AssertJUnit.assertNotNull((Object)this.cache.peek(this.child, false));
        this.cache.get(this.child, (Object)this.k);
        EasyMock.verify((Object[])new Object[]{this.mockCacheLoader});
    }

    public void testUnnecessaryMultipleLoading() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("foo", "bar");
        this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.child), (Map)EasyMock.eq(m));
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.child))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.getChildrenNames((Fqn)EasyMock.eq((Object)this.parent))).andReturn(Collections.singleton(this.child.getLastElementAsString()));
        EasyMock.replay((Object[])new Object[]{this.mockCacheLoader});
        this.cache.put(this.child, m);
        this.assertDataNotLoaded(this.child);
        this.cache.get(this.child, (Object)"foo");
        this.assertDataNotLoaded(this.child);
        this.cache.get(this.child, (Object)"foo");
        this.assertDataNotLoaded(this.child);
        this.cache.get(this.child, (Object)"foo2");
        this.assertDataLoaded(this.child);
        Node node = this.cache.getRoot().getChild(this.parent);
        this.assertDataLoaded(this.child);
        this.assertDataNotLoaded(this.parent);
        Set children = node.getChildren();
        AssertJUnit.assertEquals((int)1, (int)children.size());
        this.assertDataLoaded(this.child);
        this.cache.get(this.child, (Object)"foo");
        this.assertDataLoaded(this.child);
        EasyMock.verify((Object[])new Object[]{this.mockCacheLoader});
    }

    public void testDontLoadDataWhenGettingNode() throws Exception {
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.exists((Fqn)EasyMock.eq((Object)this.parent))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.mockCacheLoader});
        this.cache.put(this.parent, (Object)this.k, (Object)this.v);
        this.assertDataLoaded(this.parent);
        this.cache.evict(this.parent, false);
        AssertJUnit.assertNull((Object)this.cache.peek(this.parent, false));
        Node n = this.cache.getRoot().getChild(this.parent);
        AssertJUnit.assertNotNull((Object)n);
        this.assertDataNotLoaded(this.parent);
        EasyMock.verify((Object[])new Object[]{this.mockCacheLoader});
    }

    public void testDontLoadDataWhenClearingNode() throws Exception {
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.exists((Fqn)EasyMock.eq((Object)this.parent))).andReturn((Object)true);
        this.mockCacheLoader.removeData((Fqn)EasyMock.eq((Object)this.parent));
        EasyMock.replay((Object[])new Object[]{this.mockCacheLoader});
        this.cache.put(this.parent, (Object)this.k, (Object)this.v);
        this.assertDataLoaded(this.parent);
        this.cache.evict(this.parent, false);
        AssertJUnit.assertNull((Object)this.cache.peek(this.parent, false));
        Node n = this.cache.getRoot().getChild(this.parent);
        AssertJUnit.assertNotNull((Object)n);
        this.assertDataNotLoaded(this.parent);
        n.clearData();
        this.assertDataLoaded(this.parent);
        EasyMock.verify((Object[])new Object[]{this.mockCacheLoader});
    }

    public void testDontLoadDataWhenReplacingNode() throws Exception {
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.exists((Fqn)EasyMock.eq((Object)this.parent))).andReturn((Object)true);
        this.mockCacheLoader.removeData((Fqn)EasyMock.eq((Object)this.parent));
        this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), (Map)EasyMock.eq(Collections.singletonMap("hello", "world")));
        EasyMock.replay((Object[])new Object[]{this.mockCacheLoader});
        this.cache.put(this.parent, (Object)this.k, (Object)this.v);
        AssertJUnit.assertTrue((boolean)this.cache.peek(this.parent, false).isDataLoaded());
        this.cache.evict(this.parent, false);
        AssertJUnit.assertNull((Object)this.cache.peek(this.parent, false));
        Node n = this.cache.getRoot().getChild(this.parent);
        AssertJUnit.assertNotNull((Object)n);
        this.assertDataNotLoaded(this.parent);
        n.replaceAll(Collections.singletonMap("hello", "world"));
        this.assertDataLoaded(this.parent);
        EasyMock.verify((Object[])new Object[]{this.mockCacheLoader});
    }

    public void testLazyLoadDataWhenWorkingWithNode() throws Exception {
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.exists((Fqn)EasyMock.eq((Object)this.parent))).andReturn((Object)true);
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(Collections.singletonMap(this.k, this.v));
        EasyMock.replay((Object[])new Object[]{this.mockCacheLoader});
        this.cache.put(this.parent, (Object)this.k, (Object)this.v);
        this.assertDataLoaded(this.parent);
        this.cache.evict(this.parent, false);
        AssertJUnit.assertNull((Object)this.cache.peek(this.parent, false));
        Node n = this.cache.getRoot().getChild(this.parent);
        AssertJUnit.assertNotNull((Object)n);
        this.assertDataNotLoaded(this.parent);
        AssertJUnit.assertEquals((Object)this.v, (Object)n.get((Object)this.k));
        this.assertDataLoaded(this.parent);
        EasyMock.verify((Object[])new Object[]{this.mockCacheLoader});
    }

    public void testDontLoadWhenKeyInMemory() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("k2", "v2");
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(null);
        EasyMock.expect((Object)this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), EasyMock.eq((Object)this.k), EasyMock.eq((Object)this.v))).andReturn(null);
        this.mockCacheLoader.put((Fqn)EasyMock.eq((Object)this.parent), (Map)EasyMock.eq(m));
        EasyMock.expect((Object)this.mockCacheLoader.get((Fqn)EasyMock.eq((Object)this.parent))).andReturn(Collections.singletonMap(this.k, this.v));
        EasyMock.replay((Object[])new Object[]{this.mockCacheLoader});
        this.cache.put(this.parent, (Object)this.k, (Object)this.v);
        this.assertDataLoaded(this.parent);
        this.cache.evict(this.parent, false);
        this.cache.put(this.parent, m);
        this.assertDataNotLoaded(this.parent);
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get(this.parent, (Object)"k2"));
        this.assertDataNotLoaded(this.parent);
        AssertJUnit.assertEquals((Object)this.v, (Object)this.cache.get(this.parent, (Object)this.k));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get(this.parent, (Object)"k2"));
        EasyMock.verify((Object[])new Object[]{this.mockCacheLoader});
    }
}

