/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.StripedLock;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class StripedLockTest {
    private StripedLock stripedLock;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.stripedLock = new StripedLock();
    }

    public void testHashingDistribution() {
        List<Fqn> fqns = this.createRandomFqns(1000);
        HashMap<ReentrantReadWriteLock, Integer> distribution = new HashMap<ReentrantReadWriteLock, Integer>();
        for (Fqn f : fqns) {
            ReentrantReadWriteLock lock = this.stripedLock.getLock((Object)f);
            if (distribution.containsKey(lock)) {
                int count = (Integer)distribution.get(lock) + 1;
                distribution.put(lock, count);
                continue;
            }
            distribution.put(lock, 1);
        }
        System.out.println(distribution);
        System.out.println("dist size: " + distribution.size());
        System.out.println("num shared locks: " + this.stripedLock.sharedLocks.length);
        AssertJUnit.assertTrue((distribution.size() <= this.stripedLock.sharedLocks.length ? 1 : 0) != 0);
        AssertJUnit.assertTrue(((double)distribution.size() * 1.5 >= (double)this.stripedLock.sharedLocks.length ? 1 : 0) != 0);
    }

    private List<Fqn> createRandomFqns(int number) {
        ArrayList<Fqn> f = new ArrayList<Fqn>(number);
        Random r = new Random();
        while (f.size() < number) {
            Fqn fqn = Fqn.fromString((String)("/" + (char)(65 + r.nextInt(26)) + "/" + (char)(65 + r.nextInt(26)) + "/" + (char)(65 + r.nextInt(26))));
            f.add(fqn);
        }
        System.out.println("Fqns: " + f);
        return f;
    }
}

